/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.interfaces;

import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.OutboundWapSIMessage;
import cn.sendsms.Service;
import cn.sendsms.crypto.PwdConf;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.interfaces.ConnectionPool;
import cn.sendsms.jdsmsserver.interfaces.IlIlIIllIlIlllll;
import cn.sendsms.jdsmsserver.interfaces.Interface;
import cn.sendsms.jdsmsserver.interfaces.lIlIIIlIIllIlIll;
import cn.sendsms.jdsmsserver.web.DbHelper;
import cn.sendsms.otherModem.common.DesUtils;
import cn.sendsms.otherModem.nbiot.authorize.AuthorizeInfo;
import cn.sendsms.otherModem.nbiot.authorize.NbIoTAuthorize;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.dbutils.DbUtils;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServer
extends Interface<Integer> {
    public static final int ERR_INVALID_PARMS = -9000;
    public static final int ERR_DATABASE = -1;
    public static final int ERR_MISSING_PARMS = -9001;
    public static final int ERR_SEND_ERROR = -9002;
    public static final int ERR_WRONG_PASSWORD = -9003;
    public static final int ERR_INTERNAL_ERROR = -9999;
    private static final String _$12 = "l1gEgX#jnMau@Csi";
    private static final String _$11 = "jd.110110";
    private static DesUtils _$10;
    IlIlIIllIlIlllll _$9;
    private Server _$8;
    private static Logger _$7;

    public HttpServer(String string, PropertiesConfiguration propertiesConfiguration, JDSMSServer jDSMSServer, Interface.InterfaceTypes interfaceTypes) {
        super(string, propertiesConfiguration, jDSMSServer, interfaceTypes);
        this.setDescription("Default HTTP Server interface.");
    }

    @Override
    public void start() throws Exception {
        this._$1(new IlIlIIllIlIlllll(this, this.getServer(), Integer.parseInt(this.getProperty("port", "8080")), this.getProperty("use_ssl", "yes").equals("yes")));
        this._$7().start();
        super.start();
    }

    @Override
    public void stop() throws Exception {
        IlIlIIllIlIlllll._$1(this._$7()).stop();
        this._$7().interrupt();
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markMessage(OutboundMessage outboundMessage) {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        if (!DbUtils.loadDriver((String)propertiesConfiguration.getString("db1.driver"))) {
            return;
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        if (this.getMessageCache().get(outboundMessage.getMessageId()) == null) {
            return;
        }
        try {
            String string = "";
            string = JDSMSServer.getInstance().getProperties().getString("db1.url", "");
            connection = DriverManager.getConnection(string, propertiesConfiguration.getString("db1.username"), propertiesConfiguration.getString("db1.password"));
            preparedStatement = connection.prepareStatement("update " + propertiesConfiguration.getProperty("db1.tables.sms_out") + " set status = ?, sent_date = ?, gateway_id = ?, ref_no = ? where id = ?");
            if (outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.SENT) {
                preparedStatement.setString(1, "S");
                preparedStatement.setTimestamp(2, new Timestamp(outboundMessage.getDispatchDate().getTime()));
                preparedStatement.setString(3, outboundMessage.getGatewayId());
                preparedStatement.setString(4, outboundMessage.getRefNo());
                preparedStatement.setLong(5, ((Integer)this.getMessageCache().get(outboundMessage.getMessageId())).intValue());
            } else if (outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED) {
                preparedStatement.setString(1, "F");
                preparedStatement.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                preparedStatement.setString(3, outboundMessage.getGatewayId());
                preparedStatement.setString(4, outboundMessage.getRefNo());
                preparedStatement.setLong(5, ((Integer)this.getMessageCache().get(outboundMessage.getMessageId())).intValue());
            } else if (outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.UNSENT) {
                preparedStatement.setString(1, "U");
                preparedStatement.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                preparedStatement.setString(3, outboundMessage.getGatewayId());
                preparedStatement.setString(4, outboundMessage.getRefNo());
                preparedStatement.setLong(5, ((Integer)this.getMessageCache().get(outboundMessage.getMessageId())).intValue());
            }
            preparedStatement.executeUpdate();
            DbUtils.closeQuietly((Connection)connection, (Statement)preparedStatement, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly(connection, preparedStatement, null);
        }
    }

    IlIlIIllIlIlllll _$7() {
        return this._$9;
    }

    void _$1(IlIlIIllIlIlllll ilIlIIllIlIlllll) {
        this._$9 = ilIlIIllIlIlllll;
    }

    protected String getDateAsISO8601(Date date) {
        Date date2 = date == null ? new Date() : date;
        String string = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(date2);
        StringBuilder stringBuilder = new StringBuilder(string.length() + 1);
        stringBuilder.append(string.substring(0, string.length() - 2));
        stringBuilder.append(":");
        stringBuilder.append(string.substring(string.length() - 2));
        return stringBuilder.toString();
    }

    private Connection _$6() throws Exception {
        Connection connection = null;
        ConnectionPool connectionPool = ConnectionPool.getInstance();
        if (!connectionPool.isPoolCreate()) {
            connectionPool.createPool();
        }
        connection = connectionPool.getConnection();
        return connection;
    }

    private void _$1(Connection connection) {
        ConnectionPool connectionPool = ConnectionPool.getInstance();
        try {
            connectionPool.returnConnection(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if ("55a".matches("^\\d+")) {
            System.out.println("\u5339\u914d");
        }
    }

    private static void _$5() {
        try {
            if (_$10 == null) {
                _$10 = new DesUtils(_$12);
            }
        }
        catch (Exception exception) {
            _$7.error((Object)"\u6388\u6743\u5f02\u5e38\uff01");
        }
    }

    private String _$4() {
        String string = "*";
        int n = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.using_sorted", "0"));
        String string2 = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
        String string3 = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        String string4 = JDSMSServer.getInstance().getProperties().getString("settings.gateway_using", "yes");
        switch (n) {
            case 0: {
                if (string2.equals("yes")) {
                    string = "*";
                    break;
                }
                if (string4.equals("yes")) {
                    string = "#";
                    break;
                }
                if (!string3.equals("yes")) break;
                string = "$";
                break;
            }
            case 1: {
                if (string2.equals("yes")) {
                    string = "*";
                    break;
                }
                if (string3.equals("yes")) {
                    string = "$";
                    break;
                }
                if (!string4.equals("yes")) break;
                string = "#";
                break;
            }
            case 2: {
                if (string4.equals("yes")) {
                    string = "#";
                    break;
                }
                if (string2.equals("yes")) {
                    string = "*";
                    break;
                }
                if (!string3.equals("yes")) break;
                string = "$";
                break;
            }
            case 3: {
                if (string4.equals("yes")) {
                    string = "#";
                    break;
                }
                if (string3.equals("yes")) {
                    string = "$";
                    break;
                }
                if (!string2.equals("yes")) break;
                string = "*";
                break;
            }
            case 4: {
                if (string3.equals("yes")) {
                    string = "$";
                    break;
                }
                if (string2.equals("yes")) {
                    string = "*";
                    break;
                }
                if (!string4.equals("yes")) break;
                string = "#";
                break;
            }
            case 5: {
                if (string3.equals("yes")) {
                    string = "$";
                    break;
                }
                if (string4.equals("yes")) {
                    string = "#";
                    break;
                }
                if (!string2.equals("yes")) break;
                string = "*";
                break;
            }
        }
        return string;
    }

    static {
        _$7 = Logger.getRootLogger();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Send
    extends lIlIIIlIIllIlIll {
        public Send(JDSMSServer jDSMSServer, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            super(HttpServer.this, jDSMSServer, string, httpServletRequest, httpServletResponse);
        }

        @Override
        public void process() throws IOException {
            boolean bl = false;
            String string = "0";
            PrintWriter printWriter = this.getResponse().getWriter();
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<result>");
            Enumeration enumeration = this.getRequest().getHeaderNames();
            while (enumeration.hasMoreElements()) {
                System.out.println((String)enumeration.nextElement());
            }
            String string2 = this.getRequest().getParameter("password");
            if (string2 != null && string2.equalsIgnoreCase(HttpServer.this.getProperty("password.send", ""))) {
                String[] stringArray;
                String string3;
                String string4;
                this.getResponse().setContentType("text/xml");
                this.getResponse().setStatus(200);
                String string5 = this.getRequest().getParameter("recipient");
                String string6 = JDSMSServer.getInstance().getProperties().getString("settings.device_signature", "");
                String string7 = this.getRequest().getParameter("text");
                string = this.getRequest().getParameter("sync");
                if (!"1".equals(string)) {
                    string = "0";
                }
                if ("POST".equalsIgnoreCase(string4 = this.getRequest().getMethod())) {
                    string7 = new String(string7.getBytes("ISO-8859-1"), "UTF8");
                }
                if (!string6.trim().isEmpty()) {
                    string7 = string7 + string6;
                }
                if (null == (string3 = this.getRequest().getParameter("gateway")) || "".equals(string3)) {
                    stringArray = HttpServer.this._$4();
                    if ("*".equals(stringArray)) {
                        string3 = "*";
                    } else if ("$".equals(stringArray)) {
                        string3 = "$";
                    } else if ("#".equals(stringArray)) {
                        string3 = "#";
                    }
                }
                if (string5 == null || string5.length() == 0 || string7 == null || string7.length() == 0) {
                    bl = true;
                    this._$1(printWriter, -9001, "Missing Parameters.");
                } else if ("1".equals(string)) {
                    if ("1".equals(string)) {
                        this._$1(string3, string5, string7, printWriter);
                    }
                } else if ("md".equals(string3) || "#".equals(string3)) {
                    stringArray = string5.split(",");
                    ArrayList<OutboundMessage> arrayList = new ArrayList<OutboundMessage>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        OutboundMessage outboundMessage = new OutboundMessage(stringArray[i], string7);
                        String string8 = this.getRequest().getParameter("encoding");
                        if (string8 != null && string8.length() != 0) {
                            if (string8.equalsIgnoreCase("7")) {
                                outboundMessage.setEncoding(Message.MessageEncodings.ENC7BIT);
                            } else {
                                if (!string8.equalsIgnoreCase("U")) {
                                    bl = true;
                                    this._$1(printWriter, -9000, "Invalid encoding requested.");
                                    break;
                                }
                                outboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
                            }
                        }
                        if ((string8 = this.getRequest().getParameter("priority")) != null && string8.length() != 0) {
                            try {
                                outboundMessage.setPriority(Integer.parseInt(string8));
                            }
                            catch (Exception exception) {
                                bl = true;
                                this._$1(printWriter, -9000, "Invalid priority requested.");
                                break;
                            }
                        }
                        if ((string8 = this.getRequest().getParameter("from")) != null && string8.length() != 0) {
                            outboundMessage.setFrom(string8);
                        }
                        outboundMessage.setGatewayId(string3);
                        if (bl) continue;
                        try {
                            long l = this._$1(outboundMessage, null);
                            this._$1(printWriter, outboundMessage, l);
                            if (outboundMessage.getRecipient().matches("\\+?\\d{1,16}")) {
                                arrayList.add(outboundMessage);
                                continue;
                            }
                            outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                            this._$1(printWriter, outboundMessage);
                            HttpServer.this.markMessage(outboundMessage);
                            continue;
                        }
                        catch (Exception exception) {
                            outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                            this._$1(printWriter, outboundMessage, exception.getMessage());
                            HttpServer.this.markMessage(outboundMessage);
                        }
                    }
                } else {
                    stringArray = string5.split(",");
                    ArrayList<OutboundMessage> arrayList = new ArrayList<OutboundMessage>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        OutboundMessage outboundMessage = new OutboundMessage(stringArray[i], string7);
                        String string9 = this.getRequest().getParameter("encoding");
                        if (string9 != null && string9.length() != 0) {
                            if (string9.equalsIgnoreCase("7")) {
                                outboundMessage.setEncoding(Message.MessageEncodings.ENC7BIT);
                            } else {
                                if (!string9.equalsIgnoreCase("U")) {
                                    bl = true;
                                    this._$1(printWriter, -9000, "Invalid encoding requested.");
                                    break;
                                }
                                outboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
                            }
                        }
                        if ((string9 = this.getRequest().getParameter("priority")) != null && string9.length() != 0) {
                            try {
                                outboundMessage.setPriority(Integer.parseInt(string9));
                            }
                            catch (Exception exception) {
                                bl = true;
                                this._$1(printWriter, -9000, "Invalid priority requested.");
                                break;
                            }
                        }
                        if ((string9 = this.getRequest().getParameter("from")) != null && string9.length() != 0) {
                            outboundMessage.setFrom(string9);
                        }
                        outboundMessage.setGatewayId(string3);
                        if (bl) continue;
                        try {
                            long l = this._$1(outboundMessage, null);
                            this._$1(printWriter, outboundMessage, l);
                            if (outboundMessage.getRecipient().matches("\\+?\\d{1,16}")) {
                                arrayList.add(outboundMessage);
                                continue;
                            }
                            outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                            this._$1(printWriter, outboundMessage);
                            HttpServer.this.markMessage(outboundMessage);
                            continue;
                        }
                        catch (Exception exception) {
                            outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                            this._$1(printWriter, outboundMessage, exception.getMessage());
                            HttpServer.this.markMessage(outboundMessage);
                        }
                    }
                }
            } else {
                this._$1(printWriter, -9003, "Invalid password.");
            }
            printWriter.println("</result>");
            ((Request)this.getRequest()).setHandled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _$1(String string, String string2, String string3, PrintWriter printWriter) {
            boolean bl = false;
            String string4 = "";
            if (!"*".equals(string) && !string.startsWith("modem")) {
                bl = true;
                this._$1(printWriter, -9001, "Missing Parameters.");
            } else {
                OutboundMessage outboundMessage;
                int n;
                String[] stringArray = string2.split(",");
                ArrayList<OutboundMessage> arrayList = new ArrayList<OutboundMessage>();
                for (n = 0; n < stringArray.length; ++n) {
                    outboundMessage = new OutboundMessage(stringArray[n], string3);
                    string4 = this.getRequest().getParameter("encoding");
                    if (string4 != null && string4.length() != 0) {
                        if (string4.equalsIgnoreCase("7")) {
                            outboundMessage.setEncoding(Message.MessageEncodings.ENC7BIT);
                        } else if (string4.equalsIgnoreCase("U")) {
                            outboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
                        } else {
                            bl = true;
                            this._$1(printWriter, -9000, "Invalid encoding requested.");
                            break;
                        }
                    }
                    if ((string4 = this.getRequest().getParameter("priority")) != null && string4.length() != 0) {
                        try {
                            outboundMessage.setPriority(Integer.parseInt(string4));
                        }
                        catch (Exception exception) {
                            bl = true;
                            this._$1(printWriter, -9000, "Invalid priority requested.");
                            break;
                        }
                    }
                    if ((string4 = this.getRequest().getParameter("from")) != null && string4.length() != 0) {
                        outboundMessage.setFrom(string4);
                    }
                    outboundMessage.setGatewayId(string);
                    arrayList.add(outboundMessage);
                }
                if (!bl) {
                    for (n = 0; n < arrayList.size(); ++n) {
                        outboundMessage = (OutboundMessage)arrayList.get(n);
                        try {
                            Service.getInstance().sendMessage(outboundMessage);
                            this._$1(printWriter, outboundMessage);
                            continue;
                        }
                        catch (Exception exception) {
                            this._$1(printWriter, outboundMessage, exception.getMessage());
                            continue;
                        }
                        finally {
                            HttpServer.this.markMessage(outboundMessage);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long _$1(OutboundMessage outboundMessage, String string) {
            long l;
            Connection connection;
            block20: {
                PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
                connection = null;
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                String string2 = "";
                string2 = JDSMSServer.getInstance().getProperties().getString("db1.url", "");
                connection = HttpServer.this._$6();
                String string3 = "insert into %s (type,recipient,text,wap_url,wap_expiry_date,wap_signal,create_date,originator,encoding,status_report,flash_sms,dst_port,src_port,sent_date,ref_no,priority,status,errors,gateway_id) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                string3 = String.format(string3, propertiesConfiguration.getProperty("db1.tables.sms_out"));
                preparedStatement = connection.prepareStatement(string3);
                if (outboundMessage instanceof OutboundWapSIMessage) {
                    preparedStatement.setString(1, "W");
                } else {
                    preparedStatement.setString(1, "O");
                }
                preparedStatement.setString(2, outboundMessage.getRecipient());
                if (string != null) {
                    preparedStatement.setString(3, string);
                } else {
                    preparedStatement.setString(3, outboundMessage.getText());
                }
                preparedStatement.setString(4, "");
                if (outboundMessage instanceof OutboundWapSIMessage) {
                    preparedStatement.setString(5, ((OutboundWapSIMessage)outboundMessage).getUrl().toString());
                    preparedStatement.setString(6, ((OutboundWapSIMessage)outboundMessage).getExpireDate().toString());
                } else {
                    preparedStatement.setTimestamp(5, null);
                    preparedStatement.setString(6, null);
                }
                preparedStatement.setTimestamp(7, new Timestamp(outboundMessage.getDate().getTime()));
                preparedStatement.setString(8, "");
                if (outboundMessage.getEncoding().equals((Object)Message.MessageEncodings.ENC7BIT)) {
                    preparedStatement.setString(9, "7");
                } else if (outboundMessage.getEncoding().equals((Object)Message.MessageEncodings.ENC8BIT)) {
                    preparedStatement.setString(9, "8");
                } else if (outboundMessage.getEncoding().equals((Object)Message.MessageEncodings.ENCUCS2)) {
                    preparedStatement.setString(9, "U");
                }
                if (outboundMessage.getStatusReport()) {
                    preparedStatement.setInt(10, 1);
                } else {
                    preparedStatement.setInt(10, 0);
                }
                if (outboundMessage.getFlashSms()) {
                    preparedStatement.setInt(11, 1);
                } else {
                    preparedStatement.setInt(11, 0);
                }
                preparedStatement.setInt(12, -1);
                preparedStatement.setInt(13, -1);
                preparedStatement.setTimestamp(14, null);
                preparedStatement.setString(15, outboundMessage.getRefNo());
                preparedStatement.setInt(16, outboundMessage.getPriority());
                preparedStatement.setString(17, "U");
                preparedStatement.setInt(18, 0);
                preparedStatement.setString(19, outboundMessage.getGatewayId());
                preparedStatement.executeUpdate();
                DbUtils.close((Statement)preparedStatement);
                String string4 = null;
                string4 = propertiesConfiguration.getString("db1.type").equalsIgnoreCase("Oracle") || propertiesConfiguration.getString("db1.type").equalsIgnoreCase("Dm7") || propertiesConfiguration.getString("db1.type").equalsIgnoreCase("OSCAR7") || propertiesConfiguration.getString("db1.type").equalsIgnoreCase("KINGBASE8") ? "select smsserver_out_seq.currval from dual" : "select @@identity";
                preparedStatement = connection.prepareStatement(string4);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block20;
                long l2 = resultSet.getLong(1);
                HttpServer.this._$1(connection);
                return l2;
            }
            try {
                l = -1L;
            }
            catch (Exception exception) {
                long l3;
                try {
                    _$7.error((Object)"\u8c03\u7528http\u63a5\u53e3\u63d2\u5165\u6570\u636e\u5e93\u51fa\u9519", (Throwable)exception);
                    l3 = -1L;
                }
                catch (Throwable throwable) {
                    HttpServer.this._$1(connection);
                    throw throwable;
                }
                HttpServer.this._$1(connection);
                return l3;
            }
            HttpServer.this._$1(connection);
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean _$1(List<OutboundMessage> list, String string) {
            PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
            if (!DbUtils.loadDriver((String)propertiesConfiguration.getString("db1.driver"))) {
                return false;
            }
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            Object var6_6 = null;
            try {
                String string2;
                String string3 = "";
                string3 = JDSMSServer.getInstance().getProperties().getString("db1.url", "");
                String string4 = "";
                String string5 = JDSMSServer.getInstance().getProperties().getString("db1.enc", "");
                string4 = string2 = JDSMSServer.getInstance().getProperties().getString("db1.password", "");
                if (string5 != null && string5.equals("1")) {
                    string4 = PwdConf.decPwd(string2);
                }
                connection = DriverManager.getConnection(string3, propertiesConfiguration.getString("db1.username"), string4);
                string5 = "insert into %s (type,recipient,text,wap_url,wap_expiry_date,wap_signal,create_date,originator,encoding,status_report,flash_sms,dst_port,src_port,sent_date,ref_no,priority,status,errors,gateway_id) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                string5 = String.format(string5, propertiesConfiguration.getProperty("db1.tables.sms_out"));
                connection.setAutoCommit(false);
                preparedStatement = connection.prepareStatement(string5);
                for (int i = 0; i < list.size(); ++i) {
                    OutboundMessage outboundMessage = list.get(i);
                    if (outboundMessage instanceof OutboundWapSIMessage) {
                        preparedStatement.setString(1, "W");
                    } else {
                        preparedStatement.setString(1, "O");
                    }
                    preparedStatement.setString(2, outboundMessage.getRecipient());
                    if (string != null) {
                        preparedStatement.setString(3, string);
                    } else {
                        preparedStatement.setString(3, outboundMessage.getText());
                    }
                    preparedStatement.setString(4, "");
                    if (outboundMessage instanceof OutboundWapSIMessage) {
                        preparedStatement.setString(5, ((OutboundWapSIMessage)outboundMessage).getUrl().toString());
                        preparedStatement.setString(6, ((OutboundWapSIMessage)outboundMessage).getExpireDate().toString());
                    } else {
                        preparedStatement.setString(5, null);
                        preparedStatement.setString(6, null);
                    }
                    preparedStatement.setTimestamp(7, new Timestamp(outboundMessage.getDate().getTime()));
                    preparedStatement.setString(8, "");
                    if (outboundMessage.getEncoding().equals((Object)Message.MessageEncodings.ENC7BIT)) {
                        preparedStatement.setString(9, "7");
                    } else if (outboundMessage.getEncoding().equals((Object)Message.MessageEncodings.ENC8BIT)) {
                        preparedStatement.setString(9, "8");
                    } else if (outboundMessage.getEncoding().equals((Object)Message.MessageEncodings.ENCUCS2)) {
                        preparedStatement.setString(9, "U");
                    }
                    if (outboundMessage.getStatusReport()) {
                        preparedStatement.setInt(10, 1);
                    } else {
                        preparedStatement.setInt(10, 0);
                    }
                    if (outboundMessage.getFlashSms()) {
                        preparedStatement.setInt(11, 1);
                    } else {
                        preparedStatement.setInt(11, 0);
                    }
                    preparedStatement.setInt(12, -1);
                    preparedStatement.setInt(13, -1);
                    preparedStatement.setTimestamp(14, null);
                    preparedStatement.setString(15, outboundMessage.getRefNo());
                    preparedStatement.setInt(16, outboundMessage.getPriority());
                    preparedStatement.setString(17, "U");
                    preparedStatement.setInt(18, 0);
                    preparedStatement.setString(19, outboundMessage.getGatewayId());
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
                connection.commit();
                DbUtils.close((Statement)preparedStatement);
            }
            catch (SQLException sQLException) {
                boolean bl;
                try {
                    _$7.error((Object)"HttpServer->insertMsgSIntoDb occur error", (Throwable)sQLException);
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException2) {
                        _$7.error((Object)"HttpServer->insertMsgSIntoDb \u4e8b\u7269\u56de\u6eda\u51fa\u73b0\u5f02\u5e38", (Throwable)sQLException2);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(connection);
                    throw throwable;
                }
                DbUtils.closeQuietly((Connection)connection);
                return bl;
            }
            DbUtils.closeQuietly((Connection)connection);
            return true;
        }

        private void _$1(PrintWriter printWriter, OutboundMessage outboundMessage) {
            printWriter.println("<send>");
            if (outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.SENT || outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.UNSENT) {
                printWriter.printf("<error>%d</error>", 0);
                printWriter.printf("<message_status>%s</message_status>", new Object[]{OutboundMessage.MessageStatuses.SENT});
            } else {
                printWriter.printf("<error>%d</error>", -9002);
                printWriter.printf("<error_description>%s</error_description>", "Message not sent.");
                printWriter.printf("<message_status>%s</message_status>", new Object[]{OutboundMessage.MessageStatuses.FAILED});
            }
            printWriter.printf("<recipient>%s</recipient>", outboundMessage.getRecipient());
            printWriter.printf("<sent_date>%s</sent_date>", HttpServer.this.getDateAsISO8601(outboundMessage.getDispatchDate()));
            printWriter.printf("<submit_date>%s</submit_date>", HttpServer.this.getDateAsISO8601(outboundMessage.getDate()));
            if (outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED) {
                printWriter.printf("<failure_cause>%s</failure_cause>", new Object[]{outboundMessage.getFailureCause()});
            }
            printWriter.printf("<ref_no>%s</ref_no>", outboundMessage.getRefNo());
            printWriter.printf("<gateway>%s</gateway>", outboundMessage.getGatewayId());
            printWriter.println("</send>");
        }

        private void _$1(PrintWriter printWriter, OutboundMessage outboundMessage, long l) {
            printWriter.println("<send>");
            if (outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.SENT || outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.UNSENT) {
                printWriter.printf("<error>%d</error>", 0);
                printWriter.printf("<message_status>%s</message_status>", new Object[]{outboundMessage.getMessageStatus()});
            } else {
                printWriter.printf("<error>%d</error>", -9002);
                printWriter.printf("<error_description>%s</error_description>", "Message not sent.");
                printWriter.printf("<message_status>%s</message_status>", new Object[]{OutboundMessage.MessageStatuses.FAILED});
            }
            printWriter.printf("<recipient>%s</recipient>", outboundMessage.getRecipient());
            printWriter.printf("<sent_date>%s</sent_date>", HttpServer.this.getDateAsISO8601(outboundMessage.getDispatchDate()));
            printWriter.printf("<submit_date>%s</submit_date>", HttpServer.this.getDateAsISO8601(outboundMessage.getDate()));
            if (outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED) {
                printWriter.printf("<failure_cause>%s</failure_cause>", new Object[]{outboundMessage.getFailureCause()});
            }
            printWriter.printf("<ref_no>%s</ref_no>", outboundMessage.getRefNo());
            printWriter.printf("<msg_id>%s</msg_id>", l);
            printWriter.printf("<gateway>%s</gateway>", outboundMessage.getGatewayId());
            printWriter.println("</send>");
        }

        private void _$1(PrintWriter printWriter, OutboundMessage outboundMessage, String string) {
            printWriter.println("<send>");
            if (outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.SENT) {
                printWriter.printf("<error>%d</error>", 0);
            } else {
                printWriter.printf("<error>%d</error>", -9002);
                printWriter.printf("<error_description>%s</error_description>", string);
            }
            printWriter.printf("<message_status>%s</message_status>", new Object[]{outboundMessage.getMessageStatus()});
            printWriter.printf("<recipient>%s</recipient>", outboundMessage.getRecipient());
            printWriter.printf("<sent_date>%s</sent_date>", HttpServer.this.getDateAsISO8601(outboundMessage.getDispatchDate()));
            printWriter.printf("<submit_date>%s</submit_date>", HttpServer.this.getDateAsISO8601(outboundMessage.getDate()));
            if (outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED) {
                printWriter.printf("<failure_cause>%s</failure_cause>", new Object[]{outboundMessage.getFailureCause()});
            }
            printWriter.printf("<ref_no>%s</ref_no>", outboundMessage.getRefNo());
            printWriter.printf("<gateway>%s</gateway>", outboundMessage.getGatewayId());
            printWriter.println("</send>");
        }

        private void _$1(PrintWriter printWriter, int n, String string) {
            printWriter.printf("<error>%d</error>", n);
            printWriter.printf("<error_description>%s</error_description>", string);
        }

        private void _$1(PrintWriter printWriter, int n) {
            printWriter.printf("<error>%d</error>", n);
        }
    }

    public class Read
    extends lIlIIIlIIllIlIll {
        public Read(JDSMSServer jDSMSServer, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            super(HttpServer.this, jDSMSServer, string, httpServletRequest, httpServletResponse);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() throws IOException {
            PrintWriter printWriter = this.getResponse().getWriter();
            String string = this.getRequest().getParameter("password");
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            if (string != null && string.equalsIgnoreCase(HttpServer.this.getProperty("password.read", ""))) {
                int n;
                int n2;
                String string2;
                printWriter.println("<?xml version='1.0' encoding=\"UTF-8\"?>");
                this.getResponse().setStatus(200);
                String string3 = this.getRequest().getParameter("gateway");
                if (string3 == null) {
                    string3 = "";
                }
                if ((string2 = this.getRequest().getParameter("count")) == null || !string2.matches("^\\d+$")) {
                    string2 = "100";
                }
                if ((n2 = Integer.valueOf(string2).intValue()) > (n = Integer.valueOf(JDSMSServer.getInstance().getProperties().getString("settings.recvlimit", "5000")).intValue())) {
                    n2 = n;
                }
                String string4 = this.getRequest().getParameter("minid");
                int n3 = -1;
                if (string4 != null && string4.matches("^\\d+$")) {
                    n3 = Integer.valueOf(string4);
                }
                try {
                    connection = HttpServer.this._$6();
                    statement = connection.createStatement(1005, 1007);
                    resultSet = n3 < 0 ? statement.executeQuery(DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1").getHttpReceiveApiSQL(string3, n2)) : statement.executeQuery(DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1").getHttpReceiveApiSQL(string3, n2, n3));
                    printWriter.println("<messages>");
                    printWriter.printf("<error>0</error>", 0);
                    while (resultSet.next()) {
                        String string5 = resultSet.getString("originator");
                        Date date = new Date(resultSet.getTimestamp("message_date").getTime());
                        Date date2 = new Date(resultSet.getTimestamp("receive_date").getTime());
                        String string6 = resultSet.getString("encoding");
                        String string7 = resultSet.getString("gateway_id");
                        String string8 = resultSet.getString("type");
                        String string9 = resultSet.getString("text");
                        long l = resultSet.getLong("id");
                        printWriter.println("<message>");
                        if ("I".equalsIgnoreCase(string8)) {
                            printWriter.printf("<message_type>%s</message_type>", "Inbound");
                            printWriter.printf("<message_id>%s</message_id>", l);
                            printWriter.printf("<message_date>%s</message_date>\n", HttpServer.this.getDateAsISO8601(date));
                            printWriter.printf("<receive_date>%s</receive_date>\n", HttpServer.this.getDateAsISO8601(date2));
                            printWriter.printf("<originator>%s</originator>\n", string5);
                            printWriter.printf("<text>\n<![CDATA[\n%s\n]]>\n</text>\n", URLEncoder.encode(string9, "UTF-8"));
                            printWriter.printf("<encoding>%s</encoding>\n", string6);
                            printWriter.printf("<gateway>%s</gateway>\n", string7);
                        }
                        printWriter.println("</message>");
                    }
                    printWriter.println("</messages>");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    printWriter.println("<messages>");
                    printWriter.printf("<error>%d</error>", -9999);
                    printWriter.println("</messages>");
                }
                finally {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        _$7.error((Object)("\u5173\u95ed\u6e38\u6807\u51fa\u73b0\u5f02\u5e38" + sQLException));
                    }
                    HttpServer.this._$1(connection);
                }
            } else {
                this.getResponse().setContentType("text/xml");
                this.getResponse().setStatus(200);
                printWriter.println("<?xml version='1.0' encoding='UTF-8'?>");
                printWriter.println("<messages>");
                printWriter.printf("<error>%d</error>", -9003);
                printWriter.printf("<error_description>%s</error_description>", "Invalid password.");
                printWriter.println("</messages>");
            }
            ((Request)this.getRequest()).setHandled(true);
        }
    }

    public class Authorize
    extends lIlIIIlIIllIlIll {
        public Authorize(JDSMSServer jDSMSServer, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            super(HttpServer.this, jDSMSServer, string, httpServletRequest, httpServletResponse);
        }

        public void process() throws IOException {
            PrintWriter printWriter = this.getResponse().getWriter();
            printWriter.println("<?xml version='1.0' encoding=\"UTF-8\"?>");
            try {
                HttpServer._$5();
                String string = _$10.decrypt(this.getRequest().getParameter("token"));
                String string2 = _$10.decrypt(this.getRequest().getParameter("action"));
                String string3 = _$10.decrypt(this.getRequest().getParameter("para"));
                String string4 = _$10.decrypt(this.getRequest().getParameter("password"));
                if (!HttpServer._$11.equals(string4)) {
                    printWriter.printf("<result>%s</result>", _$10.encrypt("password error"));
                } else if (!NbIoTAuthorize.isActionAndParaLegal(string2, string3)) {
                    printWriter.printf("<result>%s</result>", _$10.encrypt("action or para illegal"));
                } else {
                    Class<?> clazz = Class.forName("cn.sendsms.otherModem.nbiot.authorize.NbIoTAuthorize");
                    NbIoTAuthorize nbIoTAuthorize = (NbIoTAuthorize)clazz.newInstance();
                    Method method = clazz.getMethod(string2, AuthorizeInfo.class);
                    AuthorizeInfo authorizeInfo = new AuthorizeInfo();
                    String[] stringArray = string3.substring(1, string3.length() - 1).split(",");
                    authorizeInfo.setSerialNum(stringArray[0]);
                    if (stringArray.length > 1) {
                        authorizeInfo.setRegCode(stringArray[1]);
                    }
                    if (stringArray.length > 2) {
                        authorizeInfo.setCompany(stringArray[2]);
                    }
                    if (stringArray.length > 3) {
                        authorizeInfo.setTelephone(stringArray[3]);
                    }
                    if (stringArray.length > 4) {
                        authorizeInfo.setTelephone(stringArray[4]);
                    }
                    Object object = method.invoke((Object)nbIoTAuthorize, authorizeInfo);
                    printWriter.printf("<result>%s</result>", _$10.encrypt((String)object));
                }
            }
            catch (Exception exception) {
                printWriter.printf("<result>%s</result>", "");
            }
            ((Request)this.getRequest()).setHandled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String _$1(long l) {
            String string;
            String string2;
            PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
            if (!DbUtils.loadDriver((String)propertiesConfiguration.getString("db1.driver"))) {
                return "load driver error";
            }
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                String string3 = "";
                string3 = JDSMSServer.getInstance().getProperties().getString("db1.url", "");
                connection = DriverManager.getConnection(string3, propertiesConfiguration.getString("db1.username"), propertiesConfiguration.getString("db1.password"));
                string2 = "select status from  %s where id ='" + l + "'";
                string2 = String.format(string2, propertiesConfiguration.getProperty("db1.tables.sms_out"));
                preparedStatement = connection.prepareStatement(string2);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    String string4 = resultSet.getString(1);
                    DbUtils.closeQuietly((Connection)connection, (Statement)preparedStatement, (ResultSet)resultSet);
                    return string4;
                }
                string = "no data";
                DbUtils.closeQuietly((Connection)connection, (Statement)preparedStatement, (ResultSet)resultSet);
            }
            catch (SQLException sQLException) {
                string2 = sQLException.toString();
                return string2;
            }
            finally {
                DbUtils.closeQuietly(connection, preparedStatement, resultSet);
            }
            return string;
        }
    }

    public class SendStatus
    extends lIlIIIlIIllIlIll {
        public SendStatus(JDSMSServer jDSMSServer, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            super(HttpServer.this, jDSMSServer, string, httpServletRequest, httpServletResponse);
        }

        public void process() throws IOException {
            PrintWriter printWriter = this.getResponse().getWriter();
            String string = this.getRequest().getParameter("msgid");
            String string2 = this._$1(Long.valueOf(string));
            this.getResponse().setStatus(200);
            printWriter.println("<?xml version='1.0' encoding=\"UTF-8\"?>");
            printWriter.printf("<status>%s</status>", string2);
            ((Request)this.getRequest()).setHandled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String _$1(long l) {
            String string;
            String string2;
            PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
            if (!DbUtils.loadDriver((String)propertiesConfiguration.getString("db1.driver"))) {
                return "load driver error";
            }
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                String string3 = "";
                string3 = JDSMSServer.getInstance().getProperties().getString("db1.url", "");
                string2 = "";
                String string4 = JDSMSServer.getInstance().getProperties().getString("db1.enc", "");
                string2 = string = JDSMSServer.getInstance().getProperties().getString("db1.password", "");
                if (string4 != null && string4.equals("1")) {
                    string2 = PwdConf.decPwd(string);
                }
                connection = DriverManager.getConnection(string3, propertiesConfiguration.getString("db1.username"), string2);
                string4 = "select status from  %s where id ='" + l + "'";
                preparedStatement = connection.prepareStatement(string4 = String.format(string4, propertiesConfiguration.getProperty("db1.tables.sms_out")));
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string = resultSet.getString(1);
                    DbUtils.closeQuietly((Connection)connection, (Statement)preparedStatement, (ResultSet)resultSet);
                    return string;
                }
                string = "no data";
                DbUtils.closeQuietly((Connection)connection, (Statement)preparedStatement, (ResultSet)resultSet);
            }
            catch (SQLException sQLException) {
                string2 = sQLException.toString();
                return string2;
            }
            finally {
                DbUtils.closeQuietly(connection, preparedStatement, resultSet);
            }
            return string;
        }
    }
}

