/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem;

import cn.sendsms.GatewayException;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.modem.ModemGateway;
import java.io.IOException;

public class IPModemGateway
extends ModemGateway {
    public IPModemGateway(String string, String string2, int n, String string3, String string4) {
        super(ModemGateway.ModemTypes.IP, string, string2, n, string3, string4);
    }

    public void setStatus(AGatewayHelper.GatewayStatuses gatewayStatuses) {
        super.setStatus(gatewayStatuses);
        SerialModemBean serialModemBean = DeviceInfoCache.getInstance().get(this.getModemDevice() + ":" + this.getModemParms());
        if (serialModemBean != null) {
            serialModemBean.setStatus(this.getStatus());
        }
    }

    public IPModemGateway(SerialModemBean serialModemBean) {
        super(ModemGateway.ModemTypes.IP, serialModemBean.getGatewayID(), serialModemBean.getIpAddress(), serialModemBean.getIpPort(), serialModemBean.getManufacturer(), serialModemBean.getModel());
        this.setProtocol(serialModemBean.getProtocol());
        if (serialModemBean.getInbound().equalsIgnoreCase("yes")) {
            this.setInbound(true);
        } else {
            this.setInbound(false);
        }
        if (serialModemBean.getOutbound().equalsIgnoreCase("yes")) {
            this.setOutbound(true);
        } else {
            this.setOutbound(false);
        }
        this.setSimPin(serialModemBean.getPin());
        this.setCustomInitString(serialModemBean.getInit_string());
        this.setSmscNumber(serialModemBean.getSmsc_number());
    }

    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        SerialModemBean serialModemBean = DeviceInfoCache.getInstance().get(this.getGatewayId());
        this.setStatus(AGatewayHelper.GatewayStatuses.STARTING);
        try {
            super.startGateway();
        }
        catch (GatewayException gatewayException) {
            gatewayException.printStackTrace();
            if (gatewayException instanceof GatewayException) {
                if (gatewayException.getMessage().indexOf("NoSuchPort") != -1) {
                    this.setStatus(AGatewayHelper.GatewayStatuses.NOPORT);
                } else if (gatewayException.getMessage().indexOf("PortInUse") != -1) {
                    this.setStatus(AGatewayHelper.GatewayStatuses.OCCUPY);
                } else {
                    this.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                }
                return;
            }
            throw gatewayException;
        }
        this.judgeAuthorize();
    }

    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.setStatus(AGatewayHelper.GatewayStatuses.STOPPING);
        super.stopGateway();
    }
}

