/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.Logger;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler_Huawei;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATHandler_Huawei_MC323
extends ATHandler_Huawei {
    private Object _$4 = new Object();

    public ATHandler_Huawei_MC323(ModemGateway modemGateway) {
        super(modemGateway);
        this.setStorageLocations("ME");
    }

    public String getNetworkOperator() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CREG?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPBS=\"ME\"\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT^CPBR=1\r");
        String string = this.getModemDriver().getResponse();
        string = string.replaceAll("AT^CPBR=1\r", "").replaceAll("\\s+OK\\s+", "").replaceAll("\\s+", "");
        string = string.substring(string.indexOf(58) + 1);
        String string2 = string.substring(string.lastIndexOf(44, string.length() - 3) + 1, string.lastIndexOf(","));
        if (string.indexOf("ERROR") != -1) {
            return "N/A";
        }
        if (string.trim().equals("")) {
            return "N/A";
        }
        if (!string2.equals("\"WMSN\"")) {
            return "N/A";
        }
        String string3 = string.split(",")[1];
        return string3.substring(1, string3.length() - 1);
    }

    @Override
    public String getSerialNumber() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPBS=\"ME\"\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT^CPBR=1\r");
        String string = this.getModemDriver().getResponse();
        string = string.replaceAll("AT^CPBR=1\r", "").replaceAll("\\s+OK\\s+", "").replaceAll("\\s+", "");
        string = string.substring(string.indexOf(58) + 1);
        String string2 = string.substring(string.lastIndexOf(44, string.length() - 3) + 1, string.lastIndexOf(","));
        if (string.indexOf("ERROR") != -1) {
            return "N/A";
        }
        if (string.trim().equals("")) {
            return "N/A";
        }
        if (!string2.equals("\"WMSN\"")) {
            return "N/A";
        }
        String string3 = string.split(",")[1];
        return string3.substring(1, string3.length() - 1);
    }

    @Override
    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().clearBuffer();
        this.getModemDriver().write("AT^CURC=0\r");
        this.getModemDriver().getResponse();
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClasses) throws TimeoutException, GatewayException, IOException, InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        this.getModemDriver().clearBuffer();
        if (messageClasses == InboundMessage.MessageClasses.ALL) {
            this.getModemDriver().write("AT^HCMGL=4\r");
        } else if (messageClasses == InboundMessage.MessageClasses.UNREAD) {
            this.getModemDriver().write("AT^HCMGL=0\r");
        } else if (messageClasses == InboundMessage.MessageClasses.READ) {
            this.getModemDriver().write("AT^HCMGL=1\r");
        }
        String string = this.getModemDriver().getResponse();
        ArrayList<Integer> arrayList = this._$2(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = arrayList.get(i);
            String string2 = "";
            String string3 = "";
            this.getModemDriver().write("AT^HCMGR=" + n + "\r");
            byte[] byArray = this.getModemDriver().getResponseByteArray();
            int n2 = 0;
            for (n2 = 0; n2 < byArray.length && byArray[n2] != 13; ++n2) {
                string2 = string2 + (char)byArray[n2];
            }
            ++n2;
            String string4 = "(\\d{4},)(\\d{2},)(\\d{2},)(\\d{2},)(\\d{2},)(\\d{2},)(\\d,)(\\d)";
            Pattern pattern = Pattern.compile(string4);
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find()) continue;
            Object object = matcher.group();
            char c = matcher.group().substring(((String)object).lastIndexOf(",") + 1, ((String)object).length()).trim().charAt(0);
            String string5 = "";
            if (c == '6') {
                object = new byte[byArray.length - n2 - 4];
                for (int j = 0; j < ((Object)object).length; ++j) {
                    object[j] = byArray[n2 + j];
                }
                string5 = ATHandler_Huawei_MC323.unicode2Ascii((byte[])object);
            } else {
                while (n2 < byArray.length) {
                    if (byArray[n2] == 26) {
                        ++n2;
                        continue;
                    }
                    string5 = string5 + (char)byArray[n2++];
                }
            }
            if (string5.charAt(0) == '\u0500') {
                string5 = string5.substring(3);
            }
            string3 = string2 + "#" + n + "#\r" + string5 + "\r";
            stringBuffer.append(string3);
        }
        stringBuffer.append("OK\r");
        return stringBuffer.toString();
    }

    private ArrayList<Integer> _$2(String string) throws IOException {
        String string2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string3 = string;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
        while ((string2 = bufferedReader.readLine().trim()) != null && (string2 = string2.trim()).length() <= 0) {
        }
        while (string2 != null && (string2 = string2.trim()).length() > 0 && !string2.equalsIgnoreCase("OK")) {
            if (string2.matches("^\\^HCMGL:\\s*\\d+,.*")) {
                int n = string2.indexOf(58);
                int n2 = string2.indexOf(44);
                int n3 = Integer.parseInt(string2.substring(n + 1, n2).trim());
                arrayList.add(n3);
            }
            string2 = bufferedReader.readLine().trim();
            while (string2.length() == 0) {
                string2 = bufferedReader.readLine().trim();
            }
        }
        bufferedReader.close();
        return arrayList;
    }

    @Override
    public boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGF=1\r");
        this.getModemDriver().getResponse();
        if (this.getModemDriver().isOk()) {
            this.getModemDriver().write("AT^HSMSSS=0,0,6,0\r");
            this.getModemDriver().getResponse();
            return this.getModemDriver().isOk();
        }
        return false;
    }

    @Override
    public int getTextSplitNum(String string) {
        byte[] byArray = ATHandler_Huawei_MC323.ascii2UnicodeBytes(string, false);
        int n = (byArray.length - 1) / 130 + 1;
        return n;
    }

    private ArrayList<String> _$1(String string) {
        ArrayList<String> arrayList;
        block3: {
            int n;
            int n2;
            block4: {
                block2: {
                    arrayList = new ArrayList<String>();
                    n2 = string.length();
                    if (n2 > (n = 70)) break block2;
                    arrayList.add(string);
                    break block3;
                }
                if (n2 <= n) break block3;
                if (n2 > 585) break block4;
                n = 65;
                int n3 = n2 / n;
                for (int i = 0; i <= n3; ++i) {
                    int n4;
                    int n5 = n4 + ((n4 = i * n) + n > n2 ? n2 % n : n);
                    String string2 = string.substring(n4, n5);
                    String string3 = "(" + String.valueOf(i) + "/" + String.valueOf(n3) + ")";
                    string3 = string3 + string2;
                    arrayList.add(string3);
                }
                break block3;
            }
            if (n2 <= 585 || n2 > 6237) break block3;
            n = 63;
            int n6 = n2 / n;
            for (int i = 0; i <= n6; ++i) {
                int n7;
                int n8 = n7 + ((n7 = i * n) + n > n2 ? n2 % n : n);
                String string4 = string.substring(n7, n8);
                String string5 = "";
                string5 = i < 10 ? "(0" + String.valueOf(i) + "/" + String.valueOf(n6) + ")" : "(" + String.valueOf(i) + "/" + String.valueOf(n6) + ")";
                string5 = string5 + string4;
                arrayList.add(string5);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendMessage(int n, String string, String string2, String string3) throws GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT_CGMS);
        String string4 = "";
        int n2 = -1;
        boolean bl = true;
        Logger.getInstance().logDebug("wait...", null, this.getGateway().getGatewayId());
        byte[] byArray = ATHandler_Huawei_MC323.ascii2UnicodeBytes(string3, false);
        for (int i = 0; i <= (byArray.length - 1) / 120; ++i) {
            int n3;
            int n4 = n3 = byArray.length < 130 * (i + 1) ? byArray.length - 130 * i : 130;
            if (n3 <= 0) continue;
            byte[] byArray2 = new byte[n3];
            try {
                System.arraycopy(byArray, i * 130, byArray2, 0, n3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Logger.getInstance().logDebug(string3 + " : \u7684unicode bytes are: " + new String(byArray), null, this.getGateway().getGatewayId());
            Object object = this._$4;
            synchronized (object) {
                this.getModemDriver().clearBuffer();
                if (byArray.length <= 140) {
                    this.getModemDriver().write("AT^HCMGS=\"_1_\",_2_\r".replaceAll("_1_", string2).replaceAll("_2_", "0"));
                    this.threadWait(200L);
                    Logger.getInstance().logDebug("\u5f00\u59cb\u53d1\u77ed\u4fe1:" + "AT^HCMGS=\"_1_\"\r".replaceAll("_1_", string2), null, this.getGateway().getGatewayId());
                    this.getModemDriver().write(byArray);
                    bl = false;
                } else {
                    int n5 = (byArray.length - 1) / 130 + 1;
                    String string5 = "(" + (i + 1) + "/" + n5 + ")";
                    byte[] byArray3 = ATHandler_Huawei_MC323.ascii2UnicodeBytes(string5, false);
                    byte[] byArray4 = new byte[byArray3.length + byArray2.length];
                    System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
                    System.arraycopy(byArray2, 0, byArray4, byArray3.length, byArray2.length);
                    this.getModemDriver().write("AT^HCMGS=\"_1_\"\r".replaceAll("_1_", string2));
                    this.threadWait(200L);
                    Logger.getInstance().logDebug("\u5f00\u59cb\u53d1\u77ed\u4fe1:" + "AT^HCMGS=\"_1_\"\r".replaceAll("_1_", string2), null, this.getGateway().getGatewayId());
                    this.getModemDriver().write(byArray4);
                }
                Logger.getInstance().logDebug("\u77ed\u4fe1\u5185\u5bb9: " + string3, null, this.getGateway().getGatewayId());
                byte[] byArray5 = new byte[]{0, 26};
                this.getModemDriver().write(byArray5);
                boolean bl2 = true;
                boolean bl3 = false;
                this.threadWait(1000L);
                long l = System.currentTimeMillis();
                while (bl2) {
                    if ((System.currentTimeMillis() - l) / 1000L >= 60L) {
                        n2 = -1;
                        break;
                    }
                    Logger.getInstance().logDebug("response \u5f00\u59cb\u54cd\u5e94...", null, this.getGateway().getGatewayId());
                    try {
                        if (bl3) {
                            string4 = this.getModemDriver().getResponseString();
                            System.out.println("\u53d1\u77ed\u4fe1\u54cd\u5e942: " + string4);
                        } else {
                            this.threadWait(100L);
                            string4 = this.getModemDriver().getResponse();
                            System.out.println("\u53d1\u77ed\u4fe1\u54cd\u5e941: " + string4);
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        timeoutException.printStackTrace();
                    }
                    Logger.getInstance().logDebug("response \u5df2\u7ecf\u54cd\u5e94,\u8fd4\u56de\u7684\u54cd\u5e94: " + string4, null, this.getGateway().getGatewayId());
                    if (string4.indexOf("^HCMGSS:") == -1 && string4.indexOf("^HCMGSF:") == -1) {
                        bl3 = true;
                        continue;
                    }
                    String string6 = string4.substring(0, string4.length());
                    if (string6.indexOf("^HCMGSS") != -1) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int n6 = string4.indexOf(":");
                        while (!Character.isDigit(string4.charAt(n6))) {
                            ++n6;
                        }
                        while (Character.isDigit(string4.charAt(n6))) {
                            stringBuilder.append(string4.charAt(n6));
                            ++n6;
                        }
                        n2 = Integer.parseInt(stringBuilder.toString());
                    } else {
                        n2 = -1;
                    }
                    Logger.getInstance().logDebug("\u8fd4\u56de\u54cd\u5e94: " + string4, null, this.getGateway().getGatewayId());
                    break;
                }
            }
            if (!bl) break;
        }
        return n2;
    }

    public static byte[] ascii2UnicodeBytes(String string, boolean bl) {
        int n = string.length();
        int n2 = n * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray[2 * i] = (byte)(c >> 8);
            byArray[2 * i + 1] = (byte)(c << 8 >> 8);
        }
        return byArray;
    }

    public static String unicode2Ascii(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(byArray[2 * i] << 8 | byArray[2 * i + 1] & 0xFF);
        }
        return new String(cArray);
    }
}

