/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040;

import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.ajwcc.pduUtils.gsm3040.ie.ConcatInformationElement;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElement;
import cn.ajwcc.pduUtils.gsm3040.ie.PortInformationElement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pdu {
    private int _$18;
    private int _$17;
    private String _$16;
    private int _$15 = 0;
    private int _$14 = 0;
    private int _$13 = 0;
    private int _$12;
    private String _$11;
    private int _$10;
    private byte[] _$9;
    private static final int _$8 = 0;
    private static final int _$7 = 1;
    private static final int _$6 = 2;
    private HashMap<Integer, InformationElement> _$5 = new HashMap();
    private ArrayList<InformationElement> _$4 = new ArrayList();
    private String _$3;
    private byte[] _$2;
    private String _$1;

    public int getSmscInfoLength() {
        return this._$18;
    }

    public void setSmscInfoLength(int n) {
        this._$18 = n;
    }

    public void setSmscAddressType(int n) {
        this._$17 = PduUtils.createAddressType(n);
    }

    public int getSmscAddressType() {
        return this._$17;
    }

    public void setSmscAddress(String string) {
        if (string.equals("")) {
            this._$16 = null;
            this._$17 = 0;
            this._$18 = 0;
            return;
        }
        this._$16 = string.startsWith("+") ? string.substring(1) : string;
    }

    public String getSmscAddress() {
        return this._$16;
    }

    public int getFirstOctet() {
        return this._$15;
    }

    public void setFirstOctet(int n) {
        this._$15 = n;
    }

    protected void setFirstOctetField(int n, int n2, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n2) continue;
            this._$15 &= n;
            this._$15 |= n2;
            return;
        }
        throw new RuntimeException("Invalid value for fieldName.");
    }

    protected int getFirstOctetField(int n) {
        return this._$15 & ~n;
    }

    protected void checkTpMti(int n) {
        int n2 = this.getTpMti();
        if (n2 != n) {
            throw new RuntimeException("Invalid message type : " + this.getTpMti());
        }
    }

    protected void checkTpMti(int[] nArray) {
        int n = this.getTpMti();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return;
        }
        throw new RuntimeException("Invalid message type : " + this.getTpMti());
    }

    public void setTpMti(int n) {
        this.setFirstOctetField(252, n, new int[]{0, 2, 1});
    }

    public int getTpMti() {
        return this.getFirstOctetField(252);
    }

    public void setTpUdhi(int n) {
        this.setFirstOctetField(191, n, new int[]{0, 64});
    }

    public boolean hasTpUdhi() {
        return this.getFirstOctetField(191) == 64;
    }

    public void setProtocolIdentifier(int n) {
        this._$14 = n;
    }

    public int getProtocolIdentifier() {
        return this._$14;
    }

    public void setDataCodingScheme(int n) {
        switch (n & 0xFFFFFF0C) {
            case 0: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid encoding value: " + PduUtils.byteToPdu(n));
            }
        }
        this._$13 = n;
    }

    public int getDataCodingScheme() {
        return this._$13;
    }

    public int getAddressType() {
        return this._$12;
    }

    public void setAddressType(int n) {
        this._$12 = PduUtils.createAddressType(n);
    }

    public void setAddress(String string) {
        if (string == null) {
            throw new RuntimeException("SendSMS internal error: <address> is null!");
        }
        this._$11 = string.startsWith("+") ? string.substring(1) : string;
        this.setAddressType(PduUtils.getAddressTypeFor(string));
    }

    public String getAddress() {
        return this._$11;
    }

    public int getUDLength() {
        return this._$10;
    }

    public void setUDLength(int n) {
        this._$10 = n;
    }

    public byte[] getUDData() {
        return this._$9;
    }

    public void setUDData(byte[] byArray) {
        this._$9 = byArray;
    }

    private void _$1(int n) {
        if (!this.hasTpUdhi()) {
            switch (n) {
                case 1: {
                    throw new IllegalStateException("PDU does not have a UDHI in the first octet");
                }
                case 0: {
                    this.setTpUdhi(64);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid UDH check mode");
                }
            }
        }
    }

    public int getTotalUDHLength() {
        int n = this.getUDHLength();
        if (n == 0) {
            return 0;
        }
        return n + 1;
    }

    public int getUDHLength() {
        int n = 0;
        for (InformationElement informationElement : this._$5.values()) {
            n = n + informationElement.getLength() + 2;
        }
        Iterator<InformationElement> iterator = null;
        return n;
    }

    public byte[] getUDHData() {
        this._$1(2);
        int n = this.getTotalUDHLength();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this._$9, 0, byArray, 0, n);
        return byArray;
    }

    public void addInformationElement(InformationElement informationElement) {
        this._$1(0);
        this._$5.put(informationElement.getIdentifier(), informationElement);
        this._$4.add(informationElement);
    }

    public InformationElement getInformationElement(int n) {
        this._$1(2);
        return this._$5.get(n);
    }

    public Iterator<InformationElement> getInformationElements() {
        this._$1(2);
        return this._$4.iterator();
    }

    public boolean isConcatMessage() {
        return this.getConcatInfo() != null;
    }

    public ConcatInformationElement getConcatInfo() {
        this._$1(2);
        ConcatInformationElement concatInformationElement = (ConcatInformationElement)this.getInformationElement(0);
        if (concatInformationElement == null) {
            concatInformationElement = (ConcatInformationElement)this.getInformationElement(8);
        }
        return concatInformationElement;
    }

    public int getMpRefNo() {
        ConcatInformationElement concatInformationElement = this.getConcatInfo();
        if (concatInformationElement != null) {
            return concatInformationElement.getMpRefNo();
        }
        return 0;
    }

    public int getMpMaxNo() {
        ConcatInformationElement concatInformationElement = this.getConcatInfo();
        if (concatInformationElement != null) {
            return concatInformationElement.getMpMaxNo();
        }
        return 1;
    }

    public int getMpSeqNo() {
        ConcatInformationElement concatInformationElement = this.getConcatInfo();
        if (concatInformationElement != null) {
            return concatInformationElement.getMpSeqNo();
        }
        return 0;
    }

    public boolean isPortedMessage() {
        return this._$2() != null;
    }

    private PortInformationElement _$2() {
        this._$1(2);
        return (PortInformationElement)this.getInformationElement(5);
    }

    public int getDestPort() {
        PortInformationElement portInformationElement = this._$2();
        if (portInformationElement == null) {
            return -1;
        }
        return portInformationElement.getDestPort();
    }

    public int getSrcPort() {
        PortInformationElement portInformationElement = this._$2();
        if (portInformationElement == null) {
            return -1;
        }
        return portInformationElement.getSrcPort();
    }

    public void setDataBytes(byte[] byArray) {
        this._$2 = byArray;
        this._$3 = null;
    }

    public byte[] getDataBytes() {
        return this._$2;
    }

    public boolean isBinary() {
        return ((this._$13 & 0xF0) == 240 || (this._$13 & 4) == 4) && (this._$13 & 4) == 4;
    }

    public void setDecodedText(String string) {
        this._$3 = string;
        this._$2 = null;
        boolean bl = false;
        if (PduUtils.extractDcsFlash(this._$13) == 16) {
            bl = true;
        }
        this._$13 &= 0xF;
        if (bl) {
            this._$13 |= 0x10;
        }
    }

    public String getDecodedText() {
        if (this._$3 != null) {
            return this._$3;
        }
        if (this._$9 == null) {
            throw new NullPointerException("No udData to decode");
        }
        try {
            return this._$1();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public byte[] getUserDataAsBytes() {
        int n = this._$9.length - this.getTotalUDHLength();
        byte[] byArray = new byte[n];
        System.arraycopy(this._$9, this.getTotalUDHLength(), byArray, 0, n);
        return byArray;
    }

    private String _$1() {
        switch (PduUtils.extractDcsEncoding(this.getDataCodingScheme())) {
            case 0: {
                return PduUtils.decode7bitEncoding(this.getUDHData(), this._$9);
            }
            case 4: {
                return PduUtils.byteArr2HexStr(this.getUDHData(), this._$9);
            }
            case 8: {
                return PduUtils.decodeUcs2Encoding(this.getUDHData(), this._$9);
            }
        }
        throw new RuntimeException("Invalid dataCodingScheme: " + this.getDataCodingScheme());
    }

    public String getRawPdu() {
        return this._$1;
    }

    public void setRawPdu(String string) {
        this._$1 = string;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("=================================================\n");
        stringBuffer.append("<< " + this.getClass().getSimpleName() + " >>");
        stringBuffer.append("\n");
        stringBuffer.append("Raw Pdu: ");
        stringBuffer.append(this._$1);
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (this._$16 != null) {
            stringBuffer.append("SMSC Address: [Length: " + this.getSmscInfoLength() + " (" + PduUtils.byteToPdu((byte)this.getSmscInfoLength()) + ") octets");
            stringBuffer.append(", Type: " + PduUtils.byteToPdu(this._$17) + " (" + PduUtils.byteToBits((byte)this._$17) + ")");
            stringBuffer.append(", Address: " + this._$16);
            stringBuffer.append("]");
        } else {
            stringBuffer.append("SMSC Address: [Length: 0 octets]");
        }
        stringBuffer.append("\n");
        stringBuffer.append(PduUtils.decodeFirstOctet(this));
        String string = this.pduSubclassInfo();
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append("\n");
        if (this._$9 != null) {
            switch (PduUtils.extractDcsEncoding(this.getDataCodingScheme())) {
                case 0: {
                    stringBuffer.append("User Data Length: " + this.getUDLength() + " (" + PduUtils.byteToPdu(this.getUDLength()) + ") septets");
                    stringBuffer.append("\n");
                    break;
                }
                case 4: 
                case 8: {
                    stringBuffer.append("User Data Length: " + this.getUDLength() + " (" + PduUtils.byteToPdu(this.getUDLength()) + ") octets");
                    stringBuffer.append("\n");
                }
            }
            stringBuffer.append("User Data (pdu) : " + PduUtils.bytesToPdu(this.getUDData()));
            stringBuffer.append("\n");
            if (this.hasTpUdhi()) {
                stringBuffer.append("User Data Header (pdu) : " + PduUtils.bytesToPdu(this.getUDHData()));
                stringBuffer.append("\n");
                int n = this.getUDHLength();
                stringBuffer.append("User Data Header Length: " + n + " (" + PduUtils.byteToPdu(n) + ") octets");
                stringBuffer.append("\n");
                stringBuffer.append("\n");
                stringBuffer.append("UDH Information Elements:\n");
                Iterator<InformationElement> iterator = this._$5.values().iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next().toString());
                    stringBuffer.append("\n");
                }
                iterator = null;
                stringBuffer.append("\n");
                stringBuffer.append("Non UDH Data (pdu)    : " + PduUtils.bytesToPdu(this.getUserDataAsBytes()));
                stringBuffer.append("\n");
                if (!this.isBinary()) {
                    stringBuffer.append("Non UDH Data (decoded): [" + this.getDecodedText() + "]");
                    stringBuffer.append("\n");
                }
            } else if (!this.isBinary()) {
                stringBuffer.append("User Data (decoded): [" + this.getDecodedText() + "]");
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("=================================================\n");
        return stringBuffer.toString();
    }

    protected String pduSubclassInfo() {
        return null;
    }

    protected String formatTimestamp(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.applyPattern("EEE dd-MMM-yyyy HH:mm:ss z");
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        return simpleDateFormat.format(calendar.getTime());
    }
}

