/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduFactory;
import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import cn.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElement;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElementFactory;
import java.util.Calendar;
import java.util.TimeZone;

public class PduParser {
    private int _$2;
    private byte[] _$1;

    private int _$5() {
        int n = this._$1[this._$2] & 0xFF;
        ++this._$2;
        return n;
    }

    private int _$4() {
        int n = this._$5();
        n = PduUtils.swapNibbles((byte)n);
        int n2 = 0;
        n2 += (n >>> 4 & 0xF) * 10;
        return n2 += n & 0xF;
    }

    private Calendar _$3() {
        int n;
        int n2 = this._$4();
        int n3 = this._$4();
        int n4 = this._$4();
        int n5 = this._$4();
        int n6 = this._$4();
        int n7 = this._$4();
        int n8 = this._$5();
        boolean bl = (n8 & 8) == 8;
        int n9 = PduUtils.swapNibbles(n8) & 0x7F;
        TimeZone timeZone = null;
        if (bl) {
            n = 0;
            n += (n9 >>> 4 & 0xF) * 10;
            n += n9 & 0xF;
            n9 = n;
            int n10 = n9 * 15;
            int n11 = n10 / 60;
            int n12 = n10 % 60;
            String string = "GMT-" + n11 + ":" + (n12 < 10 ? "0" : "") + n12;
            timeZone = TimeZone.getTimeZone(string);
        } else {
            n = 0;
            n += (n9 >>> 4 & 0xF) * 10;
            n += n9 & 0xF;
            n9 = n;
            int n13 = n9 * 15;
            int n14 = n13 / 60;
            int n15 = n13 % 60;
            String string = "GMT+" + n14 + ":" + (n15 < 10 ? "0" : "") + n15;
            timeZone = TimeZone.getTimeZone(string);
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.set(1, n2 + 2000);
        calendar.set(2, n3 - 1);
        calendar.set(5, n4);
        calendar.set(11, n5);
        calendar.set(12, n6);
        calendar.set(13, n7);
        return calendar;
    }

    private String _$1(int n, int n2) {
        if (n > 0) {
            int n3 = n / 2 + (n % 2 == 1 ? 1 : 0);
            byte[] byArray = new byte[n3];
            System.arraycopy(this._$1, this._$2, byArray, 0, n3);
            this._$2 += n3;
            switch (PduUtils.extractAddressType(n2)) {
                case 80: {
                    return this._$1(n, PduUtils.decode7bitEncoding(byArray));
                }
            }
            return PduUtils.readBCDNumbers(n, byArray);
        }
        return null;
    }

    private int _$2() {
        int n = this._$5();
        int n2 = 0;
        if (n > 0 && n <= 143) {
            n2 = (n + 1) * 5;
        } else if (n > 143 && n <= 167) {
            n2 = 720 + (n - 143) * 30;
        } else if (n > 167 && n <= 196) {
            n2 = (n - 166) * 24 * 60;
        } else if (n > 197 && n <= 255) {
            n2 = (n - 192) * 7 * 24 * 60;
        }
        return n2;
    }

    public Pdu parsePdu(String string) {
        this._$1 = PduUtils.pduToBytes(string);
        this._$2 = 0;
        Pdu pdu = this._$1();
        pdu.setRawPdu(string);
        switch (pdu.getTpMti()) {
            case 0: {
                this._$1((SmsDeliveryPdu)pdu);
                break;
            }
            case 1: {
                this._$1((SmsSubmitPdu)pdu);
                break;
            }
            case 2: {
                this._$1((SmsStatusReportPdu)pdu);
            }
        }
        return pdu;
    }

    private Pdu _$1() {
        int n = this._$5();
        Pdu pdu = null;
        if (n > 0) {
            int n2 = this._$5();
            String string = this._$1((n - 1) * 2, n2);
            int n3 = this._$5();
            pdu = PduFactory.createPdu(n3);
            pdu.setSmscAddressType(n2);
            pdu.setSmscAddress(string);
            pdu.setSmscInfoLength(n);
        } else {
            int n4 = this._$5();
            pdu = PduFactory.createPdu(n4);
        }
        return pdu;
    }

    private void _$1(Pdu pdu) {
        int n = this._$5();
        pdu.setUDLength(n);
        int n2 = this._$1.length - this._$2;
        byte[] byArray = new byte[n2];
        System.arraycopy(this._$1, this._$2, byArray, 0, n2);
        pdu.setUDData(byArray);
        if (pdu.hasTpUdhi()) {
            int n3 = this._$5();
            int n4 = this._$2 + n3;
            while (this._$2 < n4) {
                int n5 = this._$5();
                int n6 = this._$5();
                byte[] byArray2 = new byte[n6];
                System.arraycopy(this._$1, this._$2, byArray2, 0, n6);
                InformationElement informationElement = InformationElementFactory.createInformationElement(n5, byArray2);
                pdu.addInformationElement(informationElement);
                this._$2 += n6;
                if (this._$2 <= n4) continue;
                throw new RuntimeException("UDH is shorter than expected endUdh=" + n4 + ", position=" + this._$2);
            }
        }
    }

    private void _$1(SmsDeliveryPdu smsDeliveryPdu) {
        int n = this._$5();
        int n2 = this._$5();
        String string = this._$1(n, n2);
        smsDeliveryPdu.setAddressType(n2);
        if (string != null) {
            smsDeliveryPdu.setAddress(string);
        }
        int n3 = this._$5();
        smsDeliveryPdu.setProtocolIdentifier(n3);
        int n4 = this._$5();
        smsDeliveryPdu.setDataCodingScheme(n4);
        Calendar calendar = this._$3();
        smsDeliveryPdu.setTimestamp(calendar);
        this._$1((Pdu)smsDeliveryPdu);
    }

    private void _$1(SmsStatusReportPdu smsStatusReportPdu) {
        int n = this._$5();
        smsStatusReportPdu.setMessageReference(n);
        int n2 = this._$5();
        int n3 = this._$5();
        String string = this._$1(n2, n3);
        smsStatusReportPdu.setAddressType(n3);
        smsStatusReportPdu.setAddress(string);
        Calendar calendar = this._$3();
        smsStatusReportPdu.setTimestamp(calendar);
        Calendar calendar2 = this._$3();
        smsStatusReportPdu.setDischargeTime(calendar2);
        int n4 = this._$5();
        smsStatusReportPdu.setStatus(n4);
    }

    private void _$1(SmsSubmitPdu smsSubmitPdu) {
        int n = this._$5();
        smsSubmitPdu.setMessageReference(n);
        int n2 = this._$5();
        int n3 = this._$5();
        String string = this._$1(n2, n3);
        smsSubmitPdu.setAddressType(n3);
        smsSubmitPdu.setAddress(string);
        int n4 = this._$5();
        smsSubmitPdu.setProtocolIdentifier(n4);
        int n5 = this._$5();
        smsSubmitPdu.setDataCodingScheme(n5);
        switch (smsSubmitPdu.getTpVpf()) {
            case 0: {
                break;
            }
            case 16: {
                int n6 = this._$2();
                smsSubmitPdu.setValidityPeriod(n6 / 60);
                break;
            }
            case 24: {
                Calendar calendar = this._$3();
                smsSubmitPdu.setValidityTimestamp(calendar);
            }
        }
        this._$1((Pdu)smsSubmitPdu);
    }

    private String _$1(int n, String string) {
        int n2 = n * 4;
        int n3 = n2 / 7;
        return string.substring(0, n3);
    }
}

