/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms;

import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.sendsms.InboundBinaryMessage;
import cn.sendsms.InboundEncryptedMessage;
import cn.sendsms.Message;
import cn.sendsms.StatusReportMessage;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class InboundMessage
extends Message {
    private static final long serialVersionUID = 2L;
    private int _$28;
    private String _$27;
    private int _$26;
    private String _$25;
    private int _$24;
    private int _$23;
    private int _$22;
    private String _$21;
    protected String ud;
    protected String udh;
    protected String smscNumber;
    private boolean _$20;
    private boolean _$19;
    private boolean _$18 = false;
    private boolean _$17 = false;
    private boolean _$16;
    private int _$15;
    private String _$14;
    private String _$13;
    private boolean _$12;
    private boolean _$11;

    public boolean isCdmaFlag() {
        return this._$16;
    }

    public void setCdmaFlag(boolean bl) {
        this._$16 = bl;
    }

    public boolean isTmpDeleteFlag() {
        return this._$18;
    }

    public void setTmpDeleteFlag(boolean bl) {
        this._$18 = bl;
    }

    public boolean isFlag4G() {
        return this._$17;
    }

    public void setFlag4G(boolean bl) {
        this._$17 = bl;
    }

    public int getTmpMsgId() {
        return this._$15;
    }

    public void setTmpMsgId(int n) {
        this._$15 = n;
    }

    public boolean isTmpFlag() {
        return this._$19;
    }

    public void setTmpFlag(boolean bl) {
        this._$19 = bl;
    }

    public boolean getStoreFlag() {
        return this._$12;
    }

    void _$1(boolean bl) {
        this._$12 = bl;
    }

    public InboundMessage(Date date, String string, String string2, String string3) {
        super(Message.MessageTypes.INBOUND, date, string2);
        this.setOriginator(string);
        this.setGatewayId(string3);
        this.setMemIndex(0);
        this.setMemLocation(null);
        this.setMpRefNo(0);
        this.setMpMaxNo(0);
        this.setMpSeqNo(0);
        this.setMpMemIndex(-1);
        this._$1((String)null);
        this._$1(false);
        this.setError(false);
    }

    public InboundMessage(Date date, String string, String string2, int n, String string3) {
        super(Message.MessageTypes.INBOUND, date, string2);
        this.setOriginator(string);
        this.setMemIndex(n);
        this.setMemLocation(string3);
        this.setMpRefNo(0);
        this.setMpMaxNo(0);
        this.setMpSeqNo(0);
        this.setMpMemIndex(-1);
        this._$1((String)null);
    }

    public InboundMessage(Message.MessageTypes messageTypes, int n, String string) {
        super(messageTypes, null, null);
        this.setOriginator("");
        this.setMemIndex(n);
        this.setMemLocation(string);
        this.setMpRefNo(0);
        this.setMpMaxNo(0);
        this.setMpSeqNo(0);
        this.setMpMemIndex(-1);
        this._$1((String)null);
    }

    public InboundMessage(SmsDeliveryPdu smsDeliveryPdu, int n, String string, String string2) {
        super(Message.MessageTypes.INBOUND, null, null);
        this.setMemIndex(n);
        this.setMemLocation(string);
        this.setMpRefNo(0);
        this.setMpMaxNo(0);
        this.setMpSeqNo(0);
        this.setCCID(string2);
        this.setMpMemIndex(-1);
        int n2 = PduUtils.extractDcsEncoding(smsDeliveryPdu.getDataCodingScheme());
        switch (n2) {
            case 0: {
                this.setEncoding(Message.MessageEncodings.ENC7BIT);
                break;
            }
            case 4: {
                this.setEncoding(Message.MessageEncodings.ENC8BIT);
                break;
            }
            case 8: {
                this.setEncoding(Message.MessageEncodings.ENCUCS2);
                break;
            }
            default: {
                throw new RuntimeException("Unknown encoding value: " + n2);
            }
        }
        if ((smsDeliveryPdu.getAddressType() & 0x50) == 80) {
            this.setOriginator(smsDeliveryPdu.getAddress());
        } else if ((smsDeliveryPdu.getAddressType() & 0x10) == 16) {
            this.setOriginator("+" + smsDeliveryPdu.getAddress());
        } else {
            this.setOriginator(smsDeliveryPdu.getAddress());
        }
        this.setDate(smsDeliveryPdu.getTimestamp());
        this._$1(smsDeliveryPdu.getSmscAddress());
        this.extractData(smsDeliveryPdu);
        if (smsDeliveryPdu.isConcatMessage()) {
            this.setMpRefNo(smsDeliveryPdu.getMpRefNo());
            this.setMpMaxNo(smsDeliveryPdu.getMpMaxNo());
            this.setMpSeqNo(smsDeliveryPdu.getMpSeqNo());
        }
        if (smsDeliveryPdu.isPortedMessage()) {
            this.setDstPort(smsDeliveryPdu.getDestPort());
            this.setSrcPort(smsDeliveryPdu.getSrcPort());
        }
        if (smsDeliveryPdu.hasTpUdhi()) {
            this.udh = PduUtils.bytesToPdu(smsDeliveryPdu.getUDHData());
        }
        this.ud = PduUtils.bytesToPdu(smsDeliveryPdu.getUserDataAsBytes());
        if (this.getEncoding() == Message.MessageEncodings.ENC7BIT) {
            byte[] byArray = PduUtils.encodedSeptetsToUnencodedSeptets(smsDeliveryPdu.getUDData());
            if (byArray.length == 0) {
                this._$20 = false;
            } else if (byArray[byArray.length - 1] == 27) {
                this._$20 = true;
            }
        }
    }

    public void setEndsWithMultiChar(boolean bl) {
        this._$20 = bl;
    }

    public boolean getEndsWithMultiChar() {
        return this._$20;
    }

    public String getOriginator() {
        return this._$27;
    }

    public void setOriginator(String string) {
        this._$27 = string;
    }

    public int getMemIndex() {
        return this._$26;
    }

    public void setMemIndex(int n) {
        this._$26 = n;
    }

    public int getPushMsgId() {
        return this._$28;
    }

    public void setPushMsgId(int n) {
        this._$28 = n;
    }

    public String getMemLocation() {
        return this._$25;
    }

    public void setMemLocation(String string) {
        this._$25 = string;
    }

    public int getMpMaxNo() {
        return this._$23;
    }

    public void setMpMaxNo(int n) {
        this._$23 = n;
    }

    public String getMpMemIndex() {
        return this._$21;
    }

    public void setMpMemIndex(int n) {
        this._$21 = n == -1 ? "" : this._$21 + (this._$21.length() == 0 ? "" : ",") + n;
    }

    public int getMpRefNo() {
        return this._$24;
    }

    public void setMpRefNo(int n) {
        this._$24 = n;
    }

    public int getMpSeqNo() {
        return this._$22;
    }

    public void setMpSeqNo(int n) {
        this._$22 = n;
    }

    public String toString() {
        String string = "\n";
        string = string + "===============================================================================";
        string = string + "\n";
        string = string + "<< " + this.getClass().getSimpleName() + " >>";
        string = string + "\n";
        string = string + "-------------------------------------------------------------------------------";
        string = string + "\n";
        string = string + " Gateway Id: " + this.getGatewayId();
        string = string + "\n";
        string = string + " Message UUID: " + this.getUuid();
        string = string + "\n";
        string = string + " Encoding: " + (this.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (this.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        string = string + "\n";
        string = string + " Date: " + this.getDate();
        string = string + "\n";
        string = string + " Dispatched via SMSC: " + this.getSmscNumber();
        string = string + "\n";
        if (this instanceof InboundBinaryMessage) {
            Object object;
            InboundBinaryMessage inboundBinaryMessage = (InboundBinaryMessage)this;
            if (inboundBinaryMessage.getDataBytes() != null) {
                object = PduUtils.bytesToPdu(inboundBinaryMessage.getDataBytes());
                string = string + " Binary: " + (String)object;
                string = string + "\n";
            } else {
                string = string + " Binary: null";
                string = string + "\n";
            }
            if (this instanceof InboundEncryptedMessage) {
                try {
                    object = (InboundEncryptedMessage)this;
                    string = string + " Message is **encrypted**, decrypted text: " + ((InboundEncryptedMessage)object).getDecryptedText() + "\n";
                }
                catch (Exception exception) {
                    string = string + " Could not decrypt message: " + exception.getMessage() + "\n";
                }
            }
        } else {
            string = string + " Text: " + this.getText();
            string = string + "\n";
            try {
                string = string + " PDU data: " + this.getPduUserData();
                string = string + "\n";
            }
            catch (Exception exception) {
                string = string + " PDU data: <cannot extract properly, udh present>";
                string = string + "\n";
            }
        }
        string = string + " Originator: " + this._$27;
        string = string + "\n";
        if (this instanceof StatusReportMessage) {
            string = string + " Original Recipient: " + ((StatusReportMessage)this).getRecipient();
            string = string + "\n";
            string = string + " Delivery Status: " + (Object)((Object)((StatusReportMessage)this).getStatus());
            string = string + "\n";
            string = string + " SMSC Ref No: " + ((StatusReportMessage)this).getRefNo();
            string = string + "\n";
            string = string + " Sent Date: " + ((StatusReportMessage)this).getSent();
            string = string + "\n";
            string = string + " Delivered Date: " + ((StatusReportMessage)this).getReceived();
            string = string + "\n";
        }
        string = string + " Memory Index: " + this.getMemIndex();
        string = string + "\n";
        string = string + " Multi-part Memory Index: " + this.getMpMemIndex();
        string = string + "\n";
        string = string + " Memory Location: " + this.getMemLocation();
        string = string + "\n";
        string = string + " Source / Destination Ports: " + this.getSrcPort() + " / " + this.getDstPort();
        string = string + "\n";
        string = string + "===============================================================================";
        string = string + "\n";
        return string;
    }

    protected void extractData(SmsDeliveryPdu smsDeliveryPdu) {
        if (smsDeliveryPdu.isBinary()) {
            throw new RuntimeException("Trying to apply a binary pdu to an InboundMessage");
        }
        this.setText(smsDeliveryPdu.getDecodedText());
    }

    public String getPduUserData() {
        if (this.udh != null && this.getEncoding() == Message.MessageEncodings.ENC7BIT) {
            throw new RuntimeException("getPduUserData() not supported for 7-bit messages with UDH");
        }
        return this.ud;
    }

    public String getPduUserDataHeader() {
        return this.udh;
    }

    public void addText(String string) throws UnsupportedEncodingException {
        super.addText(string);
        if (this.getEncoding() == Message.MessageEncodings.ENCUCS2) {
            this.ud = this.ud + PduUtils.bytesToPdu(string.getBytes("UTF-16BE"));
        }
    }

    public String getSmscNumber() {
        return this.smscNumber;
    }

    private void _$1(String string) {
        this.smscNumber = string;
    }

    public InboundMessage(String string) {
        super(Message.MessageTypes.INBOUND, null, "");
        this._$13 = string;
    }

    public String getMessageID() {
        return this._$13;
    }

    public void setMessageID(String string) {
        this._$13 = string;
    }

    public boolean isError() {
        return this._$11;
    }

    public void setError(boolean bl) {
        this._$11 = bl;
    }

    public String getCCID() {
        return this._$14;
    }

    public void setCCID(String string) {
        this._$14 = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageClasses {
        READ,
        UNREAD,
        ALL;

    }
}

