/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduFactory;
import cn.ajwcc.pduUtils.gsm3040.PduGenerator;
import cn.ajwcc.pduUtils.gsm3040.PduParser;
import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElementFactory;
import cn.sendsms.Message;
import cn.sendsms.OutboundBinaryMessage;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutboundMessage
extends Message {
    private static final long serialVersionUID = 2L;
    private int _$28;
    protected String recipient;
    private Date _$27;
    private int _$26;
    private boolean _$25;
    private String _$24;
    private MessageStatuses _$23;
    private FailureCauses _$22;
    private int _$21;
    private int _$20;
    private String _$19;
    private String _$18;
    private boolean _$17;
    private String _$16;
    private String _$15;
    private int _$14;
    private long _$13;
    private Date _$12;
    private int _$11;

    public long getHandleTime() {
        return this._$13;
    }

    public void setHandleTime(long l) {
        this._$13 = l;
    }

    public int getSplitNum() {
        return this._$28;
    }

    public void setSplitNum(int n) {
        this._$28 = n;
    }

    public OutboundMessage() {
        super(Message.MessageTypes.OUTBOUND, null, null);
        this.setRecipient("");
        this.setValidityPeriod(-1);
        this.setStatusReport(false);
        this.setDCSMessageClass(Message.MessageClasses.MSGCLASS_NONE);
        this.setFrom("");
        this.setDispatchDate(null);
        this.setDate(new Date());
        this.setEncoding(Message.MessageEncodings.ENC7BIT);
        this.setMessageStatus(MessageStatuses.UNSENT);
        this.setFailureCause(FailureCauses.NO_ERROR);
        this.setPriority(0);
        this.setRefNo("");
        this.setGatewayId("*");
        this.setRetryCount(0);
        this.setSendFlag(false);
        this.setTryTimes(0);
    }

    public boolean getSendFlag() {
        return this._$17;
    }

    public void setSendFlag(boolean bl) {
        this._$17 = bl;
    }

    public int getTryTimes() {
        return this._$14;
    }

    public void addTryTimes(int n) {
        this._$14 += n;
    }

    public void setTryTimes(int n) {
        this._$14 = n;
    }

    public String getUsingPhoneNo() {
        return this._$16;
    }

    public void setUsingPhoneNo(String string) {
        this._$16 = string;
    }

    public OutboundMessage(String string, String string2) {
        super(Message.MessageTypes.OUTBOUND, new Date(), string2);
        this.setRecipient(string);
        this.setValidityPeriod(-1);
        this.setStatusReport(false);
        this.setDCSMessageClass(Message.MessageClasses.MSGCLASS_NONE);
        this.setFrom("");
        this.setDispatchDate(null);
        this.setDate(new Date());
        this.setEncoding(Message.MessageEncodings.ENC7BIT);
        this.setMessageStatus(MessageStatuses.UNSENT);
        this.setFailureCause(FailureCauses.NO_ERROR);
        this.setPriority(0);
        this.setRefNo("");
        this.setGatewayId("*");
        this.setRetryCount(0);
        this.setSendFlag(false);
        this.setUsingPhoneNo("$");
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String string) {
        this.recipient = string;
    }

    public Date getDispatchDate() {
        if (this._$27 != null) {
            return new Date(this._$27.getTime());
        }
        return null;
    }

    public void setDispatchDate(Date date) {
        this._$27 = date;
    }

    public boolean getFlashSms() {
        return this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_FLASH;
    }

    public void setFlashSms(boolean bl) {
        if (bl) {
            this.setDCSMessageClass(Message.MessageClasses.MSGCLASS_FLASH);
        } else {
            this.setDCSMessageClass(Message.MessageClasses.MSGCLASS_NONE);
        }
    }

    public boolean getStatusReport() {
        return this._$25;
    }

    public void setStatusReport(boolean bl) {
        this._$25 = bl;
    }

    public int getValidityPeriod() {
        return this._$26;
    }

    public void setValidityPeriod(int n) {
        this._$26 = n;
    }

    public String getFrom() {
        return this._$24;
    }

    public void setFrom(String string) {
        this._$24 = string;
    }

    public MessageStatuses getMessageStatus() {
        return this._$23;
    }

    public void setMessageStatus(MessageStatuses messageStatuses) {
        this._$23 = messageStatuses;
    }

    public FailureCauses getFailureCause() {
        return this._$22;
    }

    public void setFailureCause(FailureCauses failureCauses) {
        if (failureCauses != FailureCauses.NO_ERROR) {
            this._$23 = MessageStatuses.FAILED;
        }
        this._$22 = failureCauses;
    }

    public int getRetryCount() {
        return this._$21;
    }

    public void setRetryCount(int n) {
        this._$21 = n;
    }

    void _$1() {
        ++this._$21;
    }

    public int getPriority() {
        return this._$20;
    }

    public void setPriority(int n) {
        this._$20 = n;
    }

    public String getRefNo() {
        return this._$19;
    }

    public void setRefNo(String string) {
        this._$19 = string;
    }

    public String getErrorMessage() {
        return this._$18;
    }

    public void setErrorMessage(String string) {
        this._$18 = string;
    }

    public String toString() {
        String string = "\n";
        string = string + "===============================================================================";
        string = string + "\n";
        string = string + "<< " + this.getClass().getSimpleName() + " >>";
        string = string + "\n";
        string = string + "-------------------------------------------------------------------------------";
        string = string + "\n";
        string = string + " Gateway Id: " + this.getGatewayId();
        string = string + "\n";
        string = string + " Message Id: " + this.getMessageId();
        string = string + "\n";
        string = string + " Message UUID: " + this.getUuid();
        string = string + "\n";
        string = string + " Encoding: " + (this.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (this.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        string = string + "\n";
        string = string + " Date: " + this.getDate();
        string = string + "\n";
        string = string + " SMSC Ref No: " + this.getRefNo();
        string = string + "\n";
        string = string + " Recipient: " + this.getRecipient();
        string = string + "\n";
        string = string + " Dispatch Date: " + this.getDispatchDate();
        string = string + "\n";
        string = string + " Message Status: " + (Object)((Object)this.getMessageStatus());
        string = string + "\n";
        string = string + " Failure Cause: " + (Object)((Object)this.getFailureCause());
        string = string + "\n";
        string = string + " Validity Period (Hours): " + this.getValidityPeriod();
        string = string + "\n";
        string = string + " Status Report: " + this.getStatusReport();
        string = string + "\n";
        string = string + " Source / Destination Ports: " + this.getSrcPort() + " / " + this.getDstPort();
        string = string + "\n";
        string = string + " Flash SMS: " + this.getFlashSms();
        string = string + "\n";
        if (this instanceof OutboundBinaryMessage) {
            OutboundBinaryMessage outboundBinaryMessage = (OutboundBinaryMessage)this;
            if (outboundBinaryMessage.getDataBytes() != null) {
                String string2 = PduUtils.bytesToPdu(outboundBinaryMessage.getDataBytes());
                string = string + " Binary: " + string2;
                string = string + "\n";
            } else {
                string = string + " Binary: null";
                string = string + "\n";
            }
        } else {
            string = string + " Text: " + this.getText();
            string = string + "\n";
            try {
                string = string + " PDU data: " + this.getPduUserData();
                string = string + "\n";
            }
            catch (Exception exception) {
                string = string + " PDU data: <cannot extract properly, udh present>";
                string = string + "\n";
            }
        }
        string = string + " Scheduled Delivery: " + this._$12;
        string = string + "\n";
        string = string + "===============================================================================";
        string = string + "\n";
        return string;
    }

    public List<String> getPdus(String string, int n) {
        PduGenerator pduGenerator = new PduGenerator();
        SmsSubmitPdu smsSubmitPdu = this.createPduObject();
        this.initPduObject(smsSubmitPdu, string);
        return pduGenerator.generatePduList(smsSubmitPdu, n);
    }

    protected SmsSubmitPdu createPduObject() {
        SmsSubmitPdu smsSubmitPdu = this._$25 ? PduFactory.newSmsSubmitPdu(48) : PduFactory.newSmsSubmitPdu();
        return smsSubmitPdu;
    }

    protected void initPduObject(SmsSubmitPdu smsSubmitPdu, String string) {
        if (this.getDstPort() > -1 && this.getSrcPort() > -1) {
            smsSubmitPdu.addInformationElement(InformationElementFactory.generatePortInfo(this.getDstPort(), this.getSrcPort()));
        }
        String string2 = string;
        if (string.startsWith("+")) {
            string2 = string.substring(1);
        }
        smsSubmitPdu.setSmscInfoLength(1 + string2.length() / 2 + (string2.length() % 2 == 1 ? 1 : 0));
        smsSubmitPdu.setSmscAddress(string);
        smsSubmitPdu.setSmscAddressType(PduUtils.getAddressTypeFor(string));
        smsSubmitPdu.setMessageReference(0);
        smsSubmitPdu.setAddress(this.getRecipient());
        smsSubmitPdu.setProtocolIdentifier(0);
        if (!smsSubmitPdu.isBinary()) {
            int n = 0;
            if (this.getEncoding() == Message.MessageEncodings.ENC7BIT) {
                n = 0;
            } else if (this.getEncoding() == Message.MessageEncodings.ENC8BIT) {
                n = 4;
            } else if (this.getEncoding() == Message.MessageEncodings.ENCUCS2) {
                n = 8;
            } else if (this.getEncoding() == Message.MessageEncodings.ENCCUSTOM) {
                n = 0;
            }
            if (this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_FLASH) {
                n |= 0x10;
            } else if (this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_ME) {
                n |= 0x11;
            } else if (this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_SIM) {
                n |= 0x12;
            } else if (this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_TE) {
                n |= 0x13;
            }
            smsSubmitPdu.setDataCodingScheme(n);
        }
        smsSubmitPdu.setValidityPeriod(this._$26);
        this.setPduPayload(smsSubmitPdu);
    }

    protected void setPduPayload(SmsSubmitPdu smsSubmitPdu) {
        smsSubmitPdu.setDecodedText(this.getText());
    }

    @Override
    public String getPduUserData() {
        PduGenerator pduGenerator = new PduGenerator();
        SmsSubmitPdu smsSubmitPdu = this.createPduObject();
        this.initPduObject(smsSubmitPdu, "");
        List<String> list = pduGenerator.generatePduList(smsSubmitPdu, 1);
        if (smsSubmitPdu.hasTpUdhi() && this.getEncoding() == Message.MessageEncodings.ENC7BIT) {
            throw new RuntimeException("getPduUserData() not supported for 7-bit messages with UDH");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            Pdu pdu = new PduParser().parsePdu(string);
            stringBuffer.append(PduUtils.bytesToPdu(pdu.getUserDataAsBytes()));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getPduUserDataHeader() {
        PduGenerator pduGenerator = new PduGenerator();
        SmsSubmitPdu smsSubmitPdu = this.createPduObject();
        this.initPduObject(smsSubmitPdu, "");
        List<String> list = pduGenerator.generatePduList(smsSubmitPdu, 1);
        Pdu pdu = new PduParser().parsePdu(list.get(0));
        byte[] byArray = pdu.getUDHData();
        if (byArray != null) {
            return PduUtils.bytesToPdu(byArray);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setEncoding(Message.MessageEncodings messageEncodings) {
        if (messageEncodings == Message.MessageEncodings.ENC8BIT) {
            if (!(this instanceof OutboundBinaryMessage)) throw new RuntimeException("Cannot use 8-bit encoding with OutgoingMessage, use OutgoingBinaryMessage instead");
            super.setEncoding(messageEncodings);
            return;
        } else {
            super.setEncoding(messageEncodings);
        }
    }

    public void setEncodingForOthers(Message.MessageEncodings messageEncodings) {
        super.setEncoding(messageEncodings);
    }

    public void copyTo(OutboundMessage outboundMessage) {
        super.copyTo(outboundMessage);
        outboundMessage.setRecipient(this.getRecipient());
        outboundMessage.setDispatchDate(this.getDispatchDate());
        outboundMessage.setValidityPeriod(this.getValidityPeriod());
        outboundMessage.setStatusReport(this.getStatusReport());
        outboundMessage.setFlashSms(this.getFlashSms());
        outboundMessage.setFrom(this.getFrom());
        outboundMessage.setMessageStatus(this.getMessageStatus());
        outboundMessage.setFailureCause(this.getFailureCause());
        outboundMessage._$21 = this.getRetryCount();
        outboundMessage.setPriority(this.getPriority());
        outboundMessage.setRefNo(this.getRefNo());
        outboundMessage.setSendFlag(this.getSendFlag());
    }

    public void setScheduledDeliveryDate(Date date) {
        this._$12 = date;
    }

    public Date getScheduledDeliveryDate() {
        return this._$12;
    }

    public long getDeliveryDelay() {
        return this._$12 == null ? 0L : this._$12.getTime() - System.currentTimeMillis();
    }

    public void setDeliveryDelay(long l) {
        this._$12 = new Date(System.currentTimeMillis() + l);
    }

    public String getUsingPortID() {
        return this._$15;
    }

    public void setUsingPortID(String string) {
        this._$15 = string;
    }

    public int getMessageID() {
        return this._$11;
    }

    public void setMessageID(int n) {
        this._$11 = n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageStatuses {
        UNSENT,
        SENT,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FailureCauses {
        NO_ERROR,
        BAD_NUMBER,
        BAD_FORMAT,
        GATEWAY_FAILURE,
        NO_CREDIT,
        GATEWAY_AUTH,
        NO_ROUTE,
        LOCAL_OPTOUT,
        GLOBAL_OPTOUT,
        UNKNOWN;

    }
}

