/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms;

import cn.sendsms.InvalidMessageException;
import cn.sendsms.USSDDatagram;
import cn.sendsms.USSDDcs;
import cn.sendsms.USSDSessionStatus;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class USSDResponse
extends USSDDatagram {
    private static final long serialVersionUID = 1L;
    private static final Pattern _$9 = Pattern.compile("^\\+CUSD:\\s+(\\d)(?:,\\s*\"([^\"]*))?(?:\",\\s*(\\d+)\\s*)?\"?\r?$");
    private static final int _$8 = 1;
    private static final int _$7 = 2;
    private static final int _$6 = 3;
    private String _$5;
    private USSDSessionStatus _$4;

    public USSDResponse() {
        this._$5 = null;
        this._$4 = null;
    }

    public USSDResponse(String string, String string2) throws InvalidMessageException {
        Matcher matcher = _$9.matcher(string);
        if (!matcher.matches()) {
            throw new InvalidMessageException("Not a well-formed +CUSD response: |" + string + "|");
        }
        try {
            this.setGatewayId(string2);
            this._$5 = string;
            this._$4 = USSDSessionStatus.getByNumeric(Integer.valueOf(matcher.group(1)));
            if (matcher.groupCount() >= 2 && matcher.group(2) != null) {
                this.setContent(matcher.group(2));
            }
            if (matcher.groupCount() >= 3 && matcher.group(3) != null) {
                this.setDcs(USSDDcs.getByNumeric(Integer.valueOf(matcher.group(3))));
            }
        }
        catch (Exception exception) {
            throw new InvalidMessageException("Session status: " + matcher.group(1) + "; DCS: " + matcher.group(3));
        }
    }

    public String getRawResponse() {
        return this._$5;
    }

    public void setRawResponse(String string) {
        this._$5 = string;
    }

    public USSDSessionStatus getSessionStatus() {
        return this._$4;
    }

    public void setUSSDSessionStatus(USSDSessionStatus uSSDSessionStatus) {
        this._$4 = uSSDSessionStatus;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Gateway: ");
        stringBuffer.append(this.getGatewayId());
        stringBuffer.append("\n");
        stringBuffer.append("Session status: ");
        stringBuffer.append((Object)this._$4);
        stringBuffer.append("\n");
        stringBuffer.append("Data coding scheme: ");
        stringBuffer.append(this.getDcs() != null ? this.getDcs() : "Unspecified");
        stringBuffer.append("\n");
        stringBuffer.append("Content: ");
        stringBuffer.append(this.getContent() != null ? this.getContent() : "(EMPTY)");
        return stringBuffer.toString();
    }
}

