/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.addressbook;

import cn.sendsms.addressbook.AddressFolder;
import cn.sendsms.addressbook.FormatPair;
import cn.sendsms.helper.Logger;
import cn.sendsms.util.ConfParam;
import cn.sendsms.util.StringUtil;
import cn.sendsms.util.Util;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Address
implements Comparable<Address> {
    public String m_id = "";
    public String Name = "";
    public String Telephone = "";
    public String EmailAddress = "";
    public String Organization = "";
    public String Department = "";
    public String Employment = "";
    public String Address = "";
    public String Postalcode = "";
    public String username = null;
    public String m_foldertype = "";
    public String Orderrule = "";
    public AddressFolder m_parentFolder = null;

    public String getFullId() {
        String string = "";
        String string2 = "";
        string2 = this.m_parentFolder == null ? "/" : this.m_parentFolder.getFullId();
        string = string2.equals("/") ? string2 + this.m_id : string2 + "/" + this.m_id;
        return string;
    }

    public String outputFormatAddress(ArrayList arrayList) {
        FormatPair formatPair = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            formatPair = (FormatPair)arrayList.get(i);
            if (formatPair.m_FieldName.equals("name")) {
                stringBuffer.append(",\"" + this.Name + "\"");
                continue;
            }
            if (formatPair.m_FieldName.equals("email")) {
                stringBuffer.append(",\"" + this.EmailAddress + "\"");
                continue;
            }
            if (formatPair.m_FieldName.equals("telephone")) {
                stringBuffer.append(",\"" + this.Telephone + "\"");
                continue;
            }
            if (formatPair.m_FieldName.equals("postalcode")) {
                stringBuffer.append(",\"" + this.Postalcode + "\"");
                continue;
            }
            if (formatPair.m_FieldName.equals("address")) {
                stringBuffer.append(",\"" + this.Address + "\"");
                continue;
            }
            if (formatPair.m_FieldName.equals("employment")) {
                stringBuffer.append(",\"" + this.Employment + "\"");
                continue;
            }
            if (formatPair.m_FieldName.equals("organization")) {
                stringBuffer.append(",\"" + this.Organization + "\"");
                continue;
            }
            if (formatPair.m_FieldName.equals("department")) {
                stringBuffer.append(",\"" + this.Department + "\"");
                continue;
            }
            if (!formatPair.m_FieldName.equals("orderrule")) continue;
            stringBuffer.append(",\"" + this.Orderrule + "\"");
        }
        String string = stringBuffer.toString();
        string = StringUtil.supertrim(string, ",");
        return string;
    }

    public static Address parseXml(String string) {
        ConfParam confParam = new ConfParam();
        if (confParam.OpenString(string) == 1) {
            return null;
        }
        Address address = new Address();
        address.Name = confParam.GetParamString("address.name");
        address.EmailAddress = confParam.GetParamString("address.email");
        address.Organization = confParam.GetParamString("address.organization");
        address.Department = confParam.GetParamString("address.department");
        address.Address = confParam.GetParamString("address.address");
        address.Postalcode = confParam.GetParamString("address.postalcode");
        address.Telephone = confParam.GetParamString("address.telephone");
        address.Employment = confParam.GetParamString("address.employment");
        address.Orderrule = confParam.GetParamString("address.orderrule");
        address.m_id = confParam.GetParamString("address.id");
        return address;
    }

    public String getXml() {
        Address address = this;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("   <address>\r\n");
        stringBuffer.append("        <id>" + address.m_id + "</id>\r\n");
        stringBuffer.append("        <name>" + Util.htmlspecialchars(address.Name, false, false) + "</name>\r\n");
        stringBuffer.append("        <telephone>" + Util.htmlspecialchars(address.Telephone, false, false) + "</telephone>\r\n");
        stringBuffer.append("        <email>" + Util.htmlspecialchars(address.EmailAddress, false, false) + "</email>\r\n");
        stringBuffer.append("        <organization>" + Util.htmlspecialchars(address.Organization, false, false) + "</organization>\r\n");
        stringBuffer.append("        <department>" + Util.htmlspecialchars(address.Department, false, false) + "</department>\r\n");
        stringBuffer.append("        <employment>" + Util.htmlspecialchars(address.Employment, false, false) + "</employment>\r\n");
        stringBuffer.append("        <orderrule>" + Util.htmlspecialchars(address.Orderrule, false, false) + "</orderrule>\r\n");
        stringBuffer.append("        <address>" + Util.htmlspecialchars(address.Address, false, false) + "</address>\r\n");
        stringBuffer.append("        <postalcode>" + Util.htmlspecialchars(address.Postalcode, false, false) + "</postalcode>\r\n");
        stringBuffer.append("   </address>\r\n");
        return stringBuffer.toString();
    }

    public String toString() {
        return "ID: " + this.m_id + " \u59d3\u540d: " + this.Name + " \u7535\u8bdd\u53f7\u7801: " + this.Telephone + " \u90ae\u4ef6\u5730\u5740: " + this.EmailAddress + " \u516c\u53f8\u540d\u79f0 : " + this.Organization + "\n \u90e8\u95e8\u540d\u79f0: " + this.Department + " \u804c\u4f4d\u540d\u79f0: " + this.Employment + "  \u5730\u5740: " + this.Address + " \u90ae\u7f16: " + this.Postalcode + " \u6392\u5e8f\u89c4\u5219\uff1a " + this.Orderrule;
    }

    @Override
    public int compareTo(Address address) {
        double d = 0.0;
        double d2 = 0.0;
        try {
            Address address2 = this;
            Address address3 = address;
            if (!address2.Orderrule.trim().isEmpty()) {
                d = Double.parseDouble(address2.Orderrule.trim());
            }
            if (!address3.Orderrule.trim().isEmpty()) {
                d2 = Double.parseDouble(address3.Orderrule.trim());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.getInstance().logError(" Number format error.", exception, null);
        }
        if (d > d2) {
            return 1;
        }
        if (d == d2) {
            return 0;
        }
        return -1;
    }
}

