/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.crypto;

import cn.sendsms.crypto.ASymmetricKey;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESKey
extends ASymmetricKey {
    public AESKey() throws NoSuchAlgorithmException {
        this.setKey(this.generateKey());
    }

    public AESKey(SecretKeySpec secretKeySpec) {
        this.setKey(secretKeySpec);
    }

    public SecretKeySpec generateKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(128);
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] byArray = secretKey.getEncoded();
        return new SecretKeySpec(byArray, "AES");
    }

    public byte[] encrypt(byte[] byArray) throws NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, this.getKey());
        return cipher.doFinal(byArray);
    }

    public byte[] decrypt(byte[] byArray) throws NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, this.getKey());
        return cipher.doFinal(byArray);
    }

    public static void main(String[] stringArray) {
        try {
            AESKey aESKey = new AESKey();
            aESKey.setKey(aESKey.generateKey());
            String string = "Hello from Thanasis :)";
            System.out.println(">>> " + string);
            byte[] byArray = aESKey.encrypt(string.getBytes());
            byte[] byArray2 = aESKey.decrypt(byArray);
            System.out.println(">>> " + AESKey.asString(byArray2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

