/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.http;

import cn.sendsms.GatewayException;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.http.IIllIlIllIIlIIlI;
import cn.sendsms.http.llIIlIlIIllIllII;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KannelHTTPGateway
extends llIIlIlIIllIllII {
    String _$19;
    String _$18;
    String _$17;
    String _$16;
    String _$15;
    String _$14;
    boolean _$13;
    boolean _$12;
    Object _$11;

    public KannelHTTPGateway(String string, String string2, String string3, String string4) {
        super(string);
        this._$19 = string2;
        this._$18 = string3;
        this._$17 = string4;
        this._$11 = new Object();
        this.setAttributes(79);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(OutboundMessage outboundMessage) throws TimeoutException, GatewayException, IOException, InterruptedException {
        String string;
        String string2;
        ArrayList<IIllIlIllIIlIIlI> arrayList = new ArrayList<IIllIlIllIIlIIlI>();
        String string3 = outboundMessage.getFrom();
        arrayList.add(new IIllIlIllIIlIIlI(this, "username", this._$18, false));
        arrayList.add(new IIllIlIllIIlIIlI(this, "password", this._$17, false));
        arrayList.add(new IIllIlIllIIlIIlI(this, "smsc", this.getGatewayId(), false));
        arrayList.add(new IIllIlIllIIlIIlI(this, "to", outboundMessage.getRecipient(), false));
        int n = outboundMessage.getPriority();
        if (n < 0) {
            n = 0;
        } else if (n > 3) {
            n = 3;
        }
        arrayList.add(new IIllIlIllIIlIIlI(this, "priority", n + "", false));
        if (outboundMessage.getValidityPeriod() >= 0) {
            arrayList.add(new IIllIlIllIIlIIlI(this, "validity", outboundMessage.getValidityPeriod() * 60 + "", false));
        }
        if (string3 == null) {
            string3 = this.getFrom();
        }
        if (string3 != null) {
            arrayList.add(new IIllIlIllIIlIIlI(this, "from", outboundMessage.getRecipient(), false));
        }
        Message.MessageEncodings messageEncodings = outboundMessage.getEncoding();
        switch (messageEncodings) {
            case ENC8BIT: {
                string2 = "1";
                string = URLEncoder.encode(outboundMessage.getText(), "utf-8");
                break;
            }
            case ENCUCS2: {
                string2 = "2";
                string = URLEncoder.encode(outboundMessage.getText(), "utf-16BE");
                break;
            }
            default: {
                string2 = "0";
                string = URLEncoder.encode(outboundMessage.getText(), "utf-8");
            }
        }
        arrayList.add(new IIllIlIllIIlIIlI(this, "coding", string2, false));
        if (outboundMessage.getFlashSms()) {
            arrayList.add(new IIllIlIllIIlIIlI(this, "mclass", "1", false));
        }
        arrayList.add(new IIllIlIllIIlIIlI(this, "text", string, false));
        String string4 = this._$1(arrayList);
        URL uRL = new URL(this._$19 + "?" + string4);
        Object object = this._$11;
        synchronized (object) {
            List<String> list = this._$1(uRL);
            if (!list.get(0).startsWith("202")) {
                Logger.getInstance().logError("Error sending message. Response: " + list.get(0) + " - " + list.get(1), null, this.getGatewayId());
                outboundMessage.setRefNo(null);
                outboundMessage.setDispatchDate(null);
                outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                outboundMessage.setFailureCause(this._$2(list));
                return false;
            }
            Logger.getInstance().logInfo("Message sent. Response: " + list.get(0) + " - " + list.get(1), null, this.getGatewayId());
        }
        outboundMessage.setDispatchDate(new Date());
        outboundMessage.setGatewayId(this.getGatewayId());
        outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
        this.incOutboundMessageCount();
        return true;
    }

    private OutboundMessage.FailureCauses _$2(List<String> list) {
        if (list.get(0).startsWith("503")) {
            return OutboundMessage.FailureCauses.GATEWAY_FAILURE;
        }
        String string = list.get(0);
        if (string.startsWith("Authorization failed")) {
            return OutboundMessage.FailureCauses.GATEWAY_AUTH;
        }
        if (string.startsWith("Missing receiver")) {
            return OutboundMessage.FailureCauses.BAD_NUMBER;
        }
        if (string.startsWith("Not routable")) {
            return OutboundMessage.FailureCauses.NO_ROUTE;
        }
        if (string.startsWith("Sender missing")) {
            return OutboundMessage.FailureCauses.BAD_FORMAT;
        }
        return OutboundMessage.FailureCauses.UNKNOWN;
    }

    public String getSendUrl() {
        return this._$19;
    }

    public void setSendUrl(String string) {
        this._$19 = string;
    }

    public String getUsername() {
        return this._$18;
    }

    public void setUsername(String string) {
        this._$18 = string;
    }

    public String getPassword() {
        return this._$17;
    }

    public void setPassword(String string) {
        this._$17 = string;
    }

    public String getAdminUrl() {
        return this._$16;
    }

    public void setAdminUrl(String string) {
        this._$16 = string;
        if (!this._$16.endsWith("/")) {
            this._$16 = this._$16 + "/";
        }
    }

    public String getAdminPassword() {
        return this._$15;
    }

    public void setAdminPassword(String string) {
        this._$15 = string;
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this._$13 && !this.startSmsc()) {
            this.setStatus(AGatewayHelper.GatewayStatuses.STARTING);
            super.stopGateway();
            this.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            return;
        }
        super.startGateway();
    }

    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this._$12) {
            this.stopSmsc();
        }
        super.stopGateway();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSmsc() throws TimeoutException, GatewayException, IOException, InterruptedException {
        boolean bl = true;
        KannelSMSCStatuses kannelSMSCStatuses = this.getKannelSMSCStatus();
        if (kannelSMSCStatuses == KannelSMSCStatuses.UNAVAILABLE || kannelSMSCStatuses == KannelSMSCStatuses.UNKNOWN) {
            bl = false;
            Logger.getInstance().logError("SMSC was not found on Kannel.", null, this.getGatewayId());
        } else if (kannelSMSCStatuses == KannelSMSCStatuses.DEAD) {
            if (this._$15 == null) {
                Logger.getInstance().logWarn("Can't start Kannel SMSC, admin password not set.", null, this.getGatewayId());
            } else {
                List<String> list;
                ArrayList<IIllIlIllIIlIIlI> arrayList = new ArrayList<IIllIlIllIIlIIlI>();
                arrayList.add(new IIllIlIllIIlIIlI(this, "smsc", this.getGatewayId(), false));
                arrayList.add(new IIllIlIllIIlIIlI(this, "password", this._$15, false));
                String string = this._$1(arrayList);
                URL uRL = new URL(this._$16 + "start-smsc.txt?" + string);
                Object object = this._$11;
                synchronized (object) {
                    list = this._$1(uRL);
                }
                if (list.get(1).startsWith("Denied")) {
                    Logger.getInstance().logError("Could not start SMSC." + list.get(0) + " - " + list.get(1), null, this.getGatewayId());
                    bl = false;
                } else {
                    Logger.getInstance().logInfo("Sent command to start SMSC." + list.get(0) + " - " + list.get(1), null, this.getGatewayId());
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopSmsc() throws TimeoutException, GatewayException, IOException, InterruptedException {
        boolean bl = true;
        if (this._$16 == null || this._$15 == null) {
            Logger.getInstance().logError("Can't stop Kannel SMSC, admin Url and password need to be set.", null, this.getGatewayId());
            bl = false;
        } else {
            List<String> list;
            ArrayList<IIllIlIllIIlIIlI> arrayList = new ArrayList<IIllIlIllIIlIIlI>();
            arrayList.add(new IIllIlIllIIlIIlI(this, "smsc", this.getGatewayId(), false));
            arrayList.add(new IIllIlIllIIlIIlI(this, "password", this._$15, false));
            String string = this._$1(arrayList);
            URL uRL = new URL(this._$16 + "stop-smsc.txt?" + string);
            Object object = this._$11;
            synchronized (object) {
                list = this._$1(uRL);
            }
            if (list.get(1).startsWith("Denied")) {
                Logger.getInstance().logError("Could not stop SMSC." + list.get(0) + " - " + list.get(1), null, this.getGatewayId());
                bl = false;
            } else {
                Logger.getInstance().logInfo("Sent command to stop SMSC." + list.get(0) + " - " + list.get(1), null, this.getGatewayId());
            }
        }
        return bl;
    }

    public KannelSMSCStatuses getKannelSMSCStatus() {
        Object object;
        if (this._$16 == null) {
            Logger.getInstance().logWarn("Can't check Kannel SMSC status, admin URL not set.", null, this.getGatewayId());
            return KannelSMSCStatuses.UNKNOWN;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            object = this._$16 + "status.xml";
            if (this._$14 != null) {
                object = (String)object + "?password=" + this._$14;
            }
            document = documentBuilder.parse((String)object);
        }
        catch (SAXException sAXException) {
            Logger.getInstance().logError("Error getting smsc status.", sAXException, this.getGatewayId());
            return KannelSMSCStatuses.UNKNOWN;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getInstance().logError("Error getting smsc status.", parserConfigurationException, this.getGatewayId());
            return KannelSMSCStatuses.UNKNOWN;
        }
        catch (IOException iOException) {
            Logger.getInstance().logError("Error getting smsc status. Make sure Kannel is running.", iOException, this.getGatewayId());
            return KannelSMSCStatuses.UNKNOWN;
        }
        object = document.getElementsByTagName("smsc");
        int n = object.getLength();
        KannelSMSCStatuses kannelSMSCStatuses = KannelSMSCStatuses.UNAVAILABLE;
        for (int i = 0; i < n; ++i) {
            Node node = object.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            NodeList nodeList = element.getElementsByTagName("id");
            String string = nodeList.item(0).getTextContent();
            if (!this.getGatewayId().equalsIgnoreCase(string)) continue;
            NodeList nodeList2 = element.getElementsByTagName("status");
            String string2 = nodeList2.item(0).getTextContent();
            if (string2.startsWith("online")) {
                kannelSMSCStatuses = KannelSMSCStatuses.ONLINE;
            } else if (string2.startsWith("connecting")) {
                kannelSMSCStatuses = KannelSMSCStatuses.CONNECTING;
            } else if (string2.startsWith("re-connecting")) {
                kannelSMSCStatuses = KannelSMSCStatuses.RECONNECTING;
            } else if (string2.startsWith("dead")) {
                kannelSMSCStatuses = KannelSMSCStatuses.DEAD;
            }
            return kannelSMSCStatuses;
        }
        return kannelSMSCStatuses;
    }

    @Override
    List<String> _$1(URL uRL) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        Logger.getInstance().logInfo("HTTP GET: " + uRL, null, this.getGatewayId());
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(20000);
        httpURLConnection.setAllowUserInteraction(false);
        arrayList.add(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
        InputStream inputStream = httpURLConnection.getErrorStream();
        if (inputStream == null) {
            inputStream = httpURLConnection.getInputStream();
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        bufferedReader.close();
        return arrayList;
    }

    public String getStatusPassword() {
        return this._$14;
    }

    public void setStatusPassword(String string) {
        this._$14 = string;
    }

    public boolean isAutoStartSmsc() {
        return this._$13;
    }

    public void setAutoStartSmsc(boolean bl) {
        this._$13 = bl;
    }

    public boolean isAutoStopSmsc() {
        return this._$12;
    }

    public void setAutoStopSmsc(boolean bl) {
        this._$12 = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KannelSMSCStatuses {
        ONLINE,
        DEAD,
        CONNECTING,
        RECONNECTING,
        UNAVAILABLE,
        UNKNOWN;

    }
}

