/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.gateways;

import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.gateways.BaseGatewayInfo;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.SerialModemGateway;
import cn.sendsms.modem.athandler.ATHandler;
import java.util.StringTokenizer;
import org.apache.commons.configuration.PropertiesConfiguration;

public class SerialModem
extends BaseGatewayInfo {
    public SerialModem(String string, PropertiesConfiguration propertiesConfiguration, JDSMSServer jDSMSServer) {
        super(string, propertiesConfiguration, jDSMSServer);
        this.setDescription("Default Serial Modem Gateway.");
    }

    public boolean create() throws Exception {
        String string = this.getGatewayId() + ".";
        if (DeviceInfoCache.getInstance().findByPort(this.getProperties().getString(string + "port")) != null) {
            return false;
        }
        this.setGateway(new SerialModemGateway(this.getGatewayId(), this.getProperties().getString(string + "port"), Integer.parseInt(this.getProperties().getString(string + "baudrate")), this.getProperties().getString(string + "manufacturer"), this.getProperties().getString(string + "model")));
        if (this.getProperties().getString(string + "protocol").equalsIgnoreCase("pdu")) {
            this.getGateway().setProtocol(AGatewayHelper.Protocols.PDU);
        } else if (this.getProperties().getString(string + "protocol").equalsIgnoreCase("text")) {
            this.getGateway().setProtocol(AGatewayHelper.Protocols.TEXT);
        } else {
            throw new Exception("Incorrect parameter: " + string + "protocol");
        }
        ((SerialModemGateway)this.getGateway()).setSimPin(this.getProperties().getString(string + "pin"));
        if (this.getProperties().getString(string + "inbound").equalsIgnoreCase("yes")) {
            this.getGateway().setInbound(true);
        } else if (this.getProperties().getString(string + "inbound").equalsIgnoreCase("no")) {
            this.getGateway().setInbound(false);
        } else {
            throw new Exception("Incorrect parameter: " + string + "inbound");
        }
        if (this.getProperties().getString(string + "outbound").equalsIgnoreCase("yes")) {
            this.getGateway().setOutbound(true);
        } else if (this.getProperties().getString(string + "outbound").equalsIgnoreCase("no")) {
            this.getGateway().setOutbound(false);
        } else {
            throw new Exception("Incorrect parameter: " + string + "outbound");
        }
        ((ModemGateway)this.getGateway()).setCustomInitString(this.getProperties().getString(string + "init_string", ""));
        if (this.getProperties().getString(string + "smsc_number", "").length() > 0) {
            ((ModemGateway)this.getGateway()).setSmscNumber(this.getProperties().getString(string + "smsc_number"));
        }
        DeviceInfoCache.getInstance().add(this.getDeviceConfigInfo()).setGateway((ModemGateway)this.getGateway());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialModemBean getInfo() throws Exception {
        SerialModemBean serialModemBean = new SerialModemBean();
        String string = this.getGatewayId() + ".";
        serialModemBean.setPort(this.getProperties().getString(string + "port"));
        serialModemBean.setGatewayID(this.getGatewayId());
        SerialModemGateway serialModemGateway = (SerialModemGateway)this.getGateway();
        serialModemBean.setBaudrate(Integer.parseInt(this.getProperties().getString(string + "baudrate")));
        serialModemBean.setManufacturer(this.getProperties().getString(string + "manufacturer"));
        serialModemBean.setModel(this.getProperties().getString(string + "model"));
        serialModemBean.setInit_string(this.getProperties().getString(string + "init_string"));
        serialModemBean.setProtocol(AGatewayHelper.Protocols.valueOf(this.getProperties().getString(string + "protocol")));
        serialModemBean.setPin(this.getProperties().getString(string + "pin"));
        serialModemBean.setInbound(this.getProperties().getString(string + "inbound"));
        serialModemBean.setOutbound(this.getProperties().getString(string + "outbound"));
        serialModemBean.setSmsc_number(this.getProperties().getString(string + "smsc_number"));
        Object object = serialModemGateway.getDriver().getSYNCCommander();
        synchronized (object) {
            String string2 = serialModemGateway.getAtHandler().getSignalLevel();
            if (string2.indexOf("ERROR") >= 0) {
                serialModemBean.setCsq("\u65e0\u4fe1\u53f7");
            }
            string2 = string2.replaceAll("\\s+OK\\s+", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            stringTokenizer.nextToken();
            serialModemBean.setCsq(stringTokenizer.nextToken().trim());
            ATHandler aTHandler = (ATHandler)serialModemGateway.getAtHandler();
            aTHandler.getModemDriver().write("AT+CCID\r");
            string2 = aTHandler.getModemDriver().getResponse();
            string2 = string2.replaceAll("\\s+OK\\s+", "");
            stringTokenizer = new StringTokenizer(string2, ":");
            stringTokenizer.nextToken();
            serialModemBean.setCcid(stringTokenizer.nextToken().trim());
            if (aTHandler.isAlive()) {
                serialModemBean.setAtFlag("OK");
            } else {
                serialModemBean.setAtFlag("NO");
            }
        }
        return serialModemBean;
    }

    public SerialModemBean getDeviceConfigInfo() {
        SerialModemBean serialModemBean = new SerialModemBean();
        String string = this.getGatewayId() + ".";
        serialModemBean.setPort(this.getProperties().getString(string + "port"));
        serialModemBean.setGatewayID(this.getGatewayId());
        serialModemBean.setBaudrate(Integer.parseInt(this.getProperties().getString(string + "baudrate")));
        serialModemBean.setManufacturer(this.getProperties().getString(string + "manufacturer"));
        serialModemBean.setModel(this.getProperties().getString(string + "model"));
        serialModemBean.setInit_string(this.getProperties().getString(string + "init_string"));
        serialModemBean.setProtocol(AGatewayHelper.Protocols.valueOf(this.getProperties().getString(string + "protocol")));
        serialModemBean.setPin(this.getProperties().getString(string + "pin"));
        serialModemBean.setInbound(this.getProperties().getString(string + "inbound"));
        serialModemBean.setOutbound(this.getProperties().getString(string + "outbound"));
        serialModemBean.setSmsc_number(this.getProperties().getString(string + "smsc_number"));
        return serialModemBean;
    }
}

