/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.crypto.PwdConf;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.ResourceManager;
import cn.sendsms.jdsmsserver.interfaces.ConnectionPool;
import cn.sendsms.jdsmsserver.interfaces.Database;
import cn.sendsms.jdsmsserver.interfaces.Interface;
import cn.sendsms.jdsmsserver.web.DataSourceBean;
import cn.sendsms.jdsmsserver.web.DatabaseCreator;
import cn.sendsms.jdsmsserver.web.JDWebAction;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.sql.DriverManager;
import java.sql.Statement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.ArrayUtils;

public class DataSourceAction
extends JDWebAction {
    private static final long serialVersionUID = -7235907240359901762L;
    private DataSourceBean datasource;
    private String racurl;

    public void Init(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.datasource = this.findDataSourceFromConfig("db1");
        if (httpServletRequest.getParameter("datasource.type") != null && !httpServletRequest.getParameter("datasource.type").equals("mssql2000") && !httpServletRequest.getParameter("datasource.type").equals("mssql2005-2017")) {
            this.datasource.setType(httpServletRequest.getParameter("datasource.type"));
        }
        if (httpServletRequest.getParameter("datasource.port") != null) {
            this.datasource.setPort(Integer.parseInt(httpServletRequest.getParameter("datasource.port")));
        }
        if (httpServletRequest.getParameter("datasource.mstype") != null) {
            this.datasource.setMssqltype(httpServletRequest.getParameter("datasource.mstype"));
        }
        this.findForward("database-config.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void save(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = "";
        Database database = null;
        for (int i = 0; i < JDSMSServer.getInstance().getInfList().size(); ++i) {
            object = JDSMSServer.getInstance().getInfList().get(i);
            if (!((Interface)object).getId().equals(this.datasource.getInfid())) continue;
            database = object;
            break;
        }
        this.setMssqltype();
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        propertiesConfiguration.setProperty(this.datasource.getInterfaceid(), (Object)(this.datasource.getInfid() + " ,Database"));
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".type", (Object)this.datasource.getType());
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".mssqltype", (Object)this.datasource.getMssqltype());
        object = "";
        String string2 = "";
        if (this.datasource.getType().equalsIgnoreCase("mysql")) {
            object = "jdbc:mysql://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName() + "?useUnicode=true&characterEncoding=utf8";
            string2 = "com.mysql.jdbc.Driver";
        } else if (this.datasource.getType().equalsIgnoreCase("mysql8")) {
            object = "jdbc:mysql://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName() + "?useUnicode=true&characterEncoding=utf8&useSSL=false&serverTimezone=Asia/Shanghai";
            string2 = "com.mysql.cj.jdbc.Driver";
        } else if (this.datasource.getType().equalsIgnoreCase("DM7")) {
            object = "jdbc:dm://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            string2 = "dm.jdbc.driver.DmDriver";
        } else if (this.datasource.getType().equalsIgnoreCase("OSCAR7")) {
            object = "jdbc:oscar://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            string2 = "com.oscar.Driver";
        } else if (this.datasource.getType().equalsIgnoreCase("KINGBASE8")) {
            object = "jdbc:kingbase8://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            string2 = "com.kingbase8.Driver";
        } else if (this.datasource.getType().equalsIgnoreCase("GBASE8A")) {
            object = "jdbc:gbase://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName() + "?useUnicode=true&characterEncoding=utf8";
            string2 = "com.gbase.jdbc.Driver";
        } else if (this.datasource.getType().equalsIgnoreCase("mssql")) {
            object = "jdbc:sqlserver://" + this.datasource.getIp() + ":" + this.datasource.getPort() + ";SelectMethod=cursor;DatabaseName=" + this.datasource.getDatabaseName();
            if (this.datasource.getMssqltype().equalsIgnoreCase("mssql2000")) {
                string2 = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
            } else if (this.datasource.getMssqltype().equalsIgnoreCase("mssql2005-2017")) {
                string2 = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            }
        } else if (this.datasource.getType().equalsIgnoreCase("oracle")) {
            object = "jdbc:oracle:thin:@" + this.datasource.getIp() + ":" + this.datasource.getPort() + ":" + this.datasource.getDatabaseName();
            string2 = "oracle.jdbc.OracleDriver";
        } else if (this.datasource.getType().equalsIgnoreCase("oracle-rac")) {
            object = this.racurl;
            string2 = "oracle.jdbc.OracleDriver";
        } else if (this.datasource.getType().equalsIgnoreCase("postgresql")) {
            object = "jdbc:postgresql://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            string2 = "org.postgresql.Driver";
        } else {
            string = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_info1") + "[" + this.datasource.getType() + "]" + ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_info2");
            httpServletRequest.setAttribute("global_info", (Object)string);
            this.findForward("/database-config.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".url", object);
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".driver", (Object)string2);
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".username", (Object)this.datasource.getUsername());
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".enc", (Object)"1");
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".password", (Object)PwdConf.encPwd(this.datasource.getPassword()));
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".tables.sms_in", (Object)this.datasource.getTablesIn());
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".tables.sms_out", (Object)this.datasource.getTablesOut());
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".tables.calls", (Object)this.datasource.getTablesCall());
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".retries", (Object)("" + this.datasource.getRetries()));
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".update_outbound_on_statusreport", (Object)this.datasource.getUpdate_outbound_on_statusreport());
        propertiesConfiguration.setProperty(this.datasource.getInfid() + ".batch_size", (Object)("" + this.datasource.getBatch_size()));
        if (this.datasource.getType().equalsIgnoreCase("oracle-rac")) {
            propertiesConfiguration.setProperty(this.datasource.getInfid() + ".url.rac", (Object)this.racurl);
        }
        try {
            propertiesConfiguration.save();
            ConnectionPool.getInstance().initConnectionPool();
            ConnectionPool.getInstance().closeConnectionPool();
        }
        catch (Exception exception) {
            Logger.getInstance().logError("\u4fdd\u5b58\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38", exception, null);
            string = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_save_failure_info");
            this.findForward("/database-config.jsp", true, httpServletRequest, httpServletResponse);
            FileInputStream fileInputStream = null;
            fileInputStream = System.getProperty("jdsmsserver.configdir") != null ? new FileInputStream(System.getProperty("jdsmsserver.configdir") + "JDSMSServer.conf") : (System.getProperty("jdsmsserver.configfile") != null ? new FileInputStream(System.getProperty("jdsmsserver.configfile")) : new FileInputStream("JDSMSServer.conf"));
            try {
                JDSMSServer.getInstance().getProperties().load((InputStream)fileInputStream);
            }
            catch (ConfigurationException configurationException) {
                Logger.getInstance().logError("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u73b0\u5f02\u5e38", exception, null);
            }
            httpServletRequest.setAttribute("global_info", (Object)string);
            this.findForward("/database-config.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        string = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_save_success_info");
        if (database == null) {
            database = new Database(this.datasource.getInfid(), propertiesConfiguration, JDSMSServer.getInstance(), Interface.InterfaceTypes.INOUTBOUND);
            JDSMSServer.getInstance().getInfList().add(database);
        } else {
            try {
                ((Interface)database).stop();
            }
            catch (Exception exception) {
                Logger.getInstance().logError("\u4fdd\u5b58\u6570\u636e\u6e90\u65f6\u505c\u6b62\u6570\u636e\u5e93\u670d\u52a1\u5931\u8d25", exception, null);
            }
            try {
                ((Interface)database).start();
            }
            catch (Exception exception) {
                Logger.getInstance().logError("\u4fdd\u5b58\u6570\u636e\u6e90\u65f6\u542f\u52a8\u6570\u636e\u5e93\u670d\u52a1\u5931\u8d25", exception, null);
            }
        }
        httpServletRequest.setAttribute("global_info", (Object)string);
        this.Init(httpServletRequest, httpServletResponse);
    }

    public void test(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = "";
        String string2 = "";
        String string3 = "";
        this.setMssqltype();
        if (this.datasource.getType().equalsIgnoreCase("mysql")) {
            string = "jdbc:mysql://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + "?useUnicode=true&characterEncoding=gb2312";
            string2 = "com.mysql.jdbc.Driver";
            string3 = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("mysql8")) {
            string = "jdbc:mysql://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + "?useUnicode=true&characterEncoding=gb2312&useSSL=false&serverTimezone=Asia/Shanghai";
            string2 = "com.mysql.cj.jdbc.Driver";
            string3 = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("mssql") && this.datasource.getMssqltype().equalsIgnoreCase("mssql2000")) {
            string = "jdbc:sqlserver://" + this.datasource.getIp() + ":" + this.datasource.getPort() + ";SelectMethod=cursor;";
            string2 = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
            string3 = "select abs(-1) value";
        }
        if (this.datasource.getType().equalsIgnoreCase("mssql") && this.datasource.getMssqltype().equalsIgnoreCase("mssql2005-2017")) {
            string = "jdbc:sqlserver://" + this.datasource.getIp() + ":" + this.datasource.getPort() + ";SelectMethod=cursor;";
            string2 = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            string3 = "select abs(-1) value";
        }
        if (this.datasource.getType().equalsIgnoreCase("DM7")) {
            string = "jdbc:dm://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            string2 = "dm.jdbc.driver.DmDriver";
            string3 = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("OSCAR7")) {
            string = "jdbc:oscar://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            string2 = "com.oscar.Driver";
            string3 = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("KINGBASE8")) {
            string = "jdbc:kingbase8://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            string2 = "com.kingbase8.Driver";
            string3 = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("GBASE8A")) {
            string = "jdbc:gbase://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + "?useUnicode=true&characterEncoding=gb2312";
            string2 = "com.gbase.jdbc.Driver";
            string3 = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("oracle")) {
            string = "jdbc:oracle:thin:@" + this.datasource.getIp() + ":" + this.datasource.getPort() + ":" + this.datasource.getDatabaseName();
            string2 = "oracle.jdbc.OracleDriver";
            string3 = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("oracle-rac")) {
            object = httpServletRequest.getParameter("datasource.racurl");
            string = object;
            string2 = "oracle.jdbc.OracleDriver";
            string3 = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("postgresql")) {
            string = "jdbc:postgresql://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            string2 = "org.postgresql.Driver";
            string3 = "select 1 from user";
        }
        object = null;
        try {
            Class.forName(string2);
            object = DriverManager.getConnection(string, this.datasource.getUsername(), this.datasource.getPassword());
            Statement statement = object.createStatement();
            statement.executeQuery(string3);
            statement.close();
            object.close();
            if (this.datasource.getType().equalsIgnoreCase("oracle-rac")) {
                this.datasource.setUrlRac(string);
            }
        }
        catch (Exception exception) {
            if (this.datasource.getType().equalsIgnoreCase("oracle-rac")) {
                this.datasource.setUrlRac(string);
            }
            Logger.getInstance().logInfo("\u6570\u636e\u5e93\u9519\u8bef: driver=" + string2, null, null);
            Logger.getInstance().logInfo("\u6570\u636e\u5e93\u9519\u8bef: url=" + string, null, null);
            this.log.error((Object)"\u6d4b\u8bd5\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25", (Throwable)exception);
            httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_test_failure_info1"));
            this.findForward("/database-config.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_test_failure_info2"));
        this.findForward("/database-config.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void initDatabase(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            this.setMssqltype();
            String string = "cn.sendsms.jdsmsserver.web.CreatorFor" + this.datasource.getType().toUpperCase();
            if (this.datasource.getType().equals("oracle-rac")) {
                string = "cn.sendsms.jdsmsserver.web.CreatorForORACLE";
                this.datasource.setUrlRac(httpServletRequest.getParameter("datasource.racurl"));
            }
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(DataSourceBean.class);
            DatabaseCreator databaseCreator = (DatabaseCreator)constructor.newInstance(this.datasource);
            databaseCreator.initDataBase();
        }
        catch (Exception exception) {
            Logger.getInstance().logError("\u8fde\u63a5\u6570\u636e\u5e93\u65f6\u5931\u8d25", exception, null);
            httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_init_failure_info1"));
            this.findForward("/database-config.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_init_failure_info2"));
        this.findForward("/database-config.jsp", true, httpServletRequest, httpServletResponse);
    }

    private DataSourceBean findDataSourceFromConfig(String string) {
        String string2;
        Object object;
        int n;
        DataSourceBean dataSourceBean = new DataSourceBean();
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        for (n = 0; n < Integer.MAX_VALUE && !ArrayUtils.isEmpty((Object[])(object = propertiesConfiguration.getStringArray("interface." + n))) && !((String)object[1]).trim().equals("Database"); ++n) {
        }
        dataSourceBean.setInterfaceid("interface." + n);
        dataSourceBean.setInfid(string);
        if (propertiesConfiguration.getString("interface." + n, "").length() == 0) {
            return dataSourceBean;
        }
        object = propertiesConfiguration.getString(dataSourceBean.getInfid() + ".url");
        dataSourceBean.setType(propertiesConfiguration.getString(dataSourceBean.getInfid() + ".type"));
        dataSourceBean.setMssqltype(propertiesConfiguration.getString(dataSourceBean.getInfid() + ".mssqltype"));
        String[] stringArray = this.splitURL((String)object, dataSourceBean.getType());
        dataSourceBean.setBatch_size(Integer.parseInt(propertiesConfiguration.getString(dataSourceBean.getInfid() + ".batch_size")));
        dataSourceBean.setDatabaseName(stringArray[2]);
        dataSourceBean.setIp(stringArray[0]);
        String string3 = propertiesConfiguration.getString(dataSourceBean.getInfid() + ".enc");
        String string4 = string2 = propertiesConfiguration.getString(dataSourceBean.getInfid() + ".password");
        if (string3 != null && string3.equals("1")) {
            string4 = PwdConf.decPwd(string2);
        }
        dataSourceBean.setPassword(string4);
        if (dataSourceBean.getType().equals("oracle-rac")) {
            dataSourceBean.setPort(1521);
        } else {
            dataSourceBean.setPort(Integer.parseInt(stringArray[1]));
        }
        dataSourceBean.setRetries(Integer.parseInt(propertiesConfiguration.getString(dataSourceBean.getInfid() + ".retries")));
        dataSourceBean.setTablesCall(propertiesConfiguration.getString(dataSourceBean.getInfid() + ".tables.calls"));
        dataSourceBean.setTablesIn(propertiesConfiguration.getString(dataSourceBean.getInfid() + ".tables.sms_in"));
        dataSourceBean.setTablesOut(propertiesConfiguration.getString(dataSourceBean.getInfid() + ".tables.sms_out"));
        dataSourceBean.setType(propertiesConfiguration.getString(dataSourceBean.getInfid() + ".type"));
        dataSourceBean.setUpdate_outbound_on_statusreport(propertiesConfiguration.getString(dataSourceBean.getInfid() + ".update_outbound_on_statusreport"));
        dataSourceBean.setUsername(propertiesConfiguration.getString(dataSourceBean.getInfid() + ".username"));
        dataSourceBean.setUrlRac(propertiesConfiguration.getString(dataSourceBean.getInfid() + ".url.rac", "jdbc:oracle:thin:@(DESCRIPTION=(LOAD_BALANCE=on)(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.0.186)(PORT=1521))(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.0.187)(PORT=1521)))(CONNECT_DATA=(SERVICE_NAME=jdsms)))"));
        return dataSourceBean;
    }

    String[] splitURL(String string, String string2) {
        if (string2.equalsIgnoreCase("mysql") || string2.equalsIgnoreCase("mysql8")) {
            if (string2.equalsIgnoreCase("mysql8")) {
                string = string.substring(0, string.lastIndexOf(47));
            }
            String string3 = string.substring(string.indexOf(47) + 2, string.lastIndexOf(47));
            String[] stringArray = string3.split(":");
            String string4 = string.substring(string.lastIndexOf(47) + 1, string.indexOf(63));
            String[] stringArray2 = new String[]{stringArray[0], stringArray[1], string4};
            return stringArray2;
        }
        if (string2.equalsIgnoreCase("oracle")) {
            String string5 = string.substring(string.indexOf(64) + 1);
            String[] stringArray = string5.split(":");
            return stringArray;
        }
        if (string2.equalsIgnoreCase("mssql")) {
            String string6 = string.substring(string.indexOf(47) + 2, string.indexOf(59));
            String[] stringArray = string6.split(":");
            String string7 = string.substring(string.indexOf(59) + 1);
            String[] stringArray3 = string7.split(";");
            for (int i = 0; i < stringArray3.length; ++i) {
                if (!stringArray3[i].startsWith("Database")) continue;
                String[] stringArray4 = stringArray3[i].split("=");
                string7 = stringArray4[1];
            }
            String[] stringArray5 = new String[]{stringArray[0], stringArray[1], string7};
            return stringArray5;
        }
        if (string2.equalsIgnoreCase("postgresql") || string2.equalsIgnoreCase("DM7")) {
            String string8 = string.substring(string.indexOf(47) + 2, string.lastIndexOf(47));
            String[] stringArray = string8.split(":");
            String string9 = string.substring(string.lastIndexOf(47) + 1).trim();
            String[] stringArray6 = new String[]{stringArray[0], stringArray[1], string9};
            return stringArray6;
        }
        if (string2.equalsIgnoreCase("OSCAR7")) {
            String string10 = string.substring(string.indexOf(47) + 2, string.lastIndexOf(47));
            String[] stringArray = string10.split(":");
            String string11 = string.substring(string.lastIndexOf(47) + 1).trim();
            String[] stringArray7 = new String[]{stringArray[0], stringArray[1], string11};
            return stringArray7;
        }
        if (string2.equalsIgnoreCase("KINGBASE8")) {
            String string12 = string.substring(string.indexOf(47) + 2, string.lastIndexOf(47));
            String[] stringArray = string12.split(":");
            String string13 = string.substring(string.lastIndexOf(47) + 1).trim();
            String[] stringArray8 = new String[]{stringArray[0], stringArray[1], string13};
            return stringArray8;
        }
        if (string2.equalsIgnoreCase("GBASE8A")) {
            String string14 = string.substring(string.indexOf(47) + 2, string.lastIndexOf(47));
            String[] stringArray = string14.split(":");
            String string15 = string.substring(string.lastIndexOf(47) + 1, string.indexOf(63));
            String[] stringArray9 = new String[]{stringArray[0], stringArray[1], string15};
            return stringArray9;
        }
        String[] stringArray = new String[]{"", "", ""};
        return stringArray;
    }

    private void setMssqltype() {
        if (this.datasource.getType().startsWith("mssql")) {
            if (this.datasource.getType().equalsIgnoreCase("mssql2000")) {
                this.datasource.setType("mssql");
                this.datasource.setMssqltype("mssql2000");
            }
            if (this.datasource.getType().equalsIgnoreCase("mssql2005-2017")) {
                this.datasource.setType("mssql");
                this.datasource.setMssqltype("mssql2005-2017");
            }
        }
    }
}

