/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.jdsmsserver.web.DataSourceBean;
import cn.sendsms.jdsmsserver.web.User;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class DatabaseCreator {
    protected String url = "";
    protected DataSourceBean datasource = null;
    protected String driver = null;
    protected Connection conn = null;
    protected Statement stmt = null;

    public void initDataBase() throws ClassNotFoundException, SQLException, IOException, InstantiationException, IllegalAccessException {
        this.connect();
        this.createDatabase();
        this.createCallTable();
        this.createInTable();
        this.createOutTable();
        this.createUserTable();
        this.createAddRecordTable();
        this.createUserTable();
        this.createAddRecordTable();
        this.createAlertTable();
        this.createTmpMsgTable();
        this.initUserTable();
        this.rollBack();
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void connect() throws ClassNotFoundException, SQLException {
        Class.forName(this.driver);
        if (this.datasource.getType().equals("oracle-rac")) {
            this.url = this.datasource.getUrlRac();
        }
        this.conn = DriverManager.getConnection(this.url, this.datasource.getUsername(), this.datasource.getPassword());
        this.stmt = this.conn.createStatement();
    }

    public void disconnect() throws SQLException {
        if (this.stmt != null) {
            this.stmt.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public void initUserTable() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        User user = this.findUserById("admin");
        if (user == null) {
            user = new User();
            user.setUserId("admin");
            user.setPassword("admin");
            user.setUserDesc("\u7cfb\u7edf\u7ba1\u7406\u5458");
            user.setSurplusNumber(10000);
            this.addUser(user);
        }
    }

    public boolean addUser(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string = "insert into %s (user_id,password,user_desc,surplus_number) values('" + user.getUserId() + "','" + user.getPassword() + "','" + user.getUserDesc() + "','" + user.getSurplusNumber() + "')";
        string = String.format(string, this.datasource.getTablesUser());
        this.stmt.executeUpdate(string);
        return true;
    }

    public User findUserById(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string2 = "select * from " + this.datasource.getTablesUser() + " where user_id = '" + string + "'";
        ResultSet resultSet = this.stmt.executeQuery(string2);
        User user = null;
        if (resultSet.next()) {
            user = new User();
            user.setUserId(resultSet.getString("user_id"));
            user.setPassword(resultSet.getString("password"));
            user.setUserDesc(resultSet.getString("user_desc"));
            user.setSurplusNumber(resultSet.getInt("surplus_number"));
        }
        return user;
    }

    public abstract void createDatabase() throws SQLException;

    public abstract void createOutTable() throws SQLException;

    public abstract void createInTable() throws SQLException;

    public abstract void createCallTable() throws SQLException;

    public abstract void createUserTable() throws SQLException;

    public abstract void createAddRecordTable() throws SQLException;

    public abstract void rollBack();

    public abstract void createAlertTable() throws SQLException;

    public abstract void createTmpMsgTable() throws SQLException;
}

