/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.GatewayException;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.GetSerialPortInfo;
import cn.sendsms.jdsmsserver.web.IIIllllIllIlllll;
import cn.sendsms.jdsmsserver.web.NetDeviceBean;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.jdsmsserver.web.lIIIIIlllIlIllII;
import cn.sendsms.jdsmsserver.web.llIllllIllIlllll;
import cn.sendsms.modem.IPModemGateway;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.SerialModemGateway;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import jssc.SerialPort;
import jssc.SerialPortList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceInfoCache {
    private static final DeviceInfoCache _$6 = new DeviceInfoCache();
    private static final String _$5 = "newmodem";
    private static byte _$4;
    private static Logger _$3;
    private CheckStatus _$2 = CheckStatus.STOPPED;
    private Vector<DeviceBean> _$1 = new Vector();

    public CheckStatus getStatus() {
        return this._$2;
    }

    public void setStatus(CheckStatus checkStatus) {
        this._$2 = checkStatus;
    }

    private DeviceInfoCache() {
        _$4 = 1;
    }

    private synchronized void _$3() {
        _$4 = (byte)(_$4 + 1);
    }

    public static final DeviceInfoCache getInstance() {
        return _$6;
    }

    public void deleteConfiguration(SerialModemBean serialModemBean) throws ConfigurationException {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        boolean bl = false;
        int n = 0;
        for (n = 0; n < 64; ++n) {
            if (propertiesConfiguration.getString("gateway." + n, "").trim().length() == 0 || propertiesConfiguration.getString("gateway." + n, "").indexOf(serialModemBean.getGatewayID() + " ,") == -1) continue;
            bl = true;
            propertiesConfiguration.clearProperty("gateway." + n);
            break;
        }
        if (bl) {
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".port");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".baudrate");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".manufacturer");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".model");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".protocol");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".pin");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".inbound");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".outbound");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".smsc_number");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".init_string");
        }
        propertiesConfiguration.save();
    }

    public void updateDeviceInfo() {
        Iterator iterator;
        int n;
        SerialModemBean serialModemBean;
        Object object;
        Object object2;
        Object[] objectArray;
        this._$2 = CheckStatus.RUNNING;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        String[] stringArray = SerialPortList.getPortNames();
        double d = System.currentTimeMillis();
        for (int i = 0; i < stringArray.length; ++i) {
            long l = System.currentTimeMillis();
            objectArray = new Properties();
            object2 = new SerialPort(stringArray[i]);
            objectArray.setProperty("portname", object2.getPortName());
            SerialModemBean serialModemBean2 = this.get(object2.getPortName());
            if (serialModemBean2 != null) {
                objectArray.setProperty("baudrate", serialModemBean2.getBaudrate() + "");
            }
            object = executorService.submit(new lIIIIIlllIlIllII(this, (Properties)objectArray));
            serialModemBean = null;
            try {
                serialModemBean = object.get(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException interruptedException) {
                _$3.error((Object)("\u68c0\u6d4b\u7aef\u53e3[" + object2.getPortName() + "]\u88ab\u6253\u65ad"), (Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                _$3.error((Object)("\u68c0\u6d4b\u7aef\u53e3[" + object2.getPortName() + "]\u51fa\u73b0\u5f02\u5e38"), (Throwable)executionException);
            }
            catch (java.util.concurrent.TimeoutException timeoutException) {
                _$3.error((Object)("\u68c0\u6d4b\u7aef\u53e3[" + object2.getPortName() + "]\u8d85\u65f6"), (Throwable)timeoutException);
                object.cancel(true);
                _$3.info((Object)("\u53d6\u6d88\u68c0\u6d4b\u7aef\u53e3[" + object2.getPortName() + "]\u7684\u4efb\u52a1\u6210\u529f\u3002"));
            }
            if (serialModemBean2 != null) {
                serialModemBean.setGatewayID(serialModemBean2.getGatewayID());
            }
            if (serialModemBean == null) {
                serialModemBean = new SerialModemBean();
                serialModemBean.setPort(object2.getPortName());
                serialModemBean.setBaudrate(GetSerialPortInfo.botelvs[GetSerialPortInfo.botelvs.length - 1]);
                serialModemBean.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
                serialModemBean.setGatewayID(null);
            }
            this.put(serialModemBean);
            arrayList.add(object2.getPortName());
            long l2 = System.currentTimeMillis();
            double d2 = l2 - l;
            _$3.info((Object)("\u68c0\u6d4b\u7aef\u53e3[" + object2.getPortName() + "]\u8017\u8d39\u65f6\u95f4" + (d2 /= 1000.0) + "\u79d2"));
        }
        executorService.shutdownNow();
        executorService = Executors.newSingleThreadExecutor();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (n = 0; n < 64; ++n) {
            try {
                iterator = "netdevice." + n;
                objectArray = JDSMSServer.getInstance().getProperties().getStringArray((String)((Object)iterator));
                if (ArrayUtils.isEmpty((Object[])objectArray)) break;
                object2 = new NetDeviceBean();
                ((NetDeviceBean)object2).setId((String)objectArray[0]);
                ((NetDeviceBean)object2).setDeviceIp(JDSMSServer.getInstance().getProperties().getString((String)objectArray[0] + ".ip"));
                ((NetDeviceBean)object2).setStartPort(JDSMSServer.getInstance().getProperties().getInt((String)objectArray[0] + ".startPort"));
                ((NetDeviceBean)object2).setEndPort(JDSMSServer.getInstance().getProperties().getInt((String)objectArray[0] + ".endPort"));
                arrayList2.add(object2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            iterator = (NetDeviceBean)arrayList2.get(n);
            for (int i = ((NetDeviceBean)((Object)iterator)).getStartPort(); i <= ((NetDeviceBean)((Object)iterator)).getEndPort(); ++i) {
                long l = System.currentTimeMillis();
                ((NetDeviceBean)((Object)iterator)).setCheckingPort(i);
                object = ((NetDeviceBean)((Object)iterator)).getDeviceIp() + ":" + ((NetDeviceBean)((Object)iterator)).getCheckingPort();
                serialModemBean = this.get(object);
                Future<SerialModemBean> future = executorService.submit(new lIIIIIlllIlIllII(this, (NetDeviceBean)((Object)iterator)));
                SerialModemBean serialModemBean3 = null;
                try {
                    serialModemBean3 = future.get(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException interruptedException) {
                    _$3.error((Object)("\u68c0\u6d4b\u7aef\u53e3[" + (String)object + "]\u88ab\u6253\u65ad"), (Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    _$3.error((Object)("\u68c0\u6d4b\u7aef\u53e3[" + (String)object + "]\u51fa\u73b0\u5f02\u5e38"), (Throwable)executionException);
                }
                catch (java.util.concurrent.TimeoutException timeoutException) {
                    _$3.error((Object)("\u68c0\u6d4b\u7aef\u53e3[" + (String)object + "]\u8d85\u65f6"), (Throwable)timeoutException);
                    future.cancel(true);
                    _$3.info((Object)("\u53d6\u6d88\u68c0\u6d4b\u7aef\u53e3[" + (String)object + "]\u7684\u4efb\u52a1\u6210\u529f\u3002"));
                }
                if (serialModemBean != null) {
                    serialModemBean3.setGatewayID(serialModemBean.getGatewayID());
                }
                if (serialModemBean3 == null) {
                    serialModemBean3 = new SerialModemBean();
                    serialModemBean3.setPort((String)object);
                    serialModemBean3.setBaudrate(115200);
                    serialModemBean3.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
                    serialModemBean3.setGatewayID(null);
                }
                this.put(serialModemBean3);
                arrayList.add(object);
                long l3 = System.currentTimeMillis();
                double d3 = l3 - l;
                _$3.info((Object)("\u68c0\u6d4b\u7aef\u53e3[" + (String)object + "]\u8017\u8d39\u65f6\u95f4" + (d3 /= 1000.0) + "\u79d2"));
            }
        }
        executorService.shutdownNow();
        Collection collection = CollectionUtils.selectRejected(this._$1, (Predicate)new llIllllIllIlllll(this, arrayList));
        this._$1.removeAll(collection);
        for (Object e : collection) {
            try {
                this.deleteConfiguration(((DeviceBean)e).getDeviceInfo());
            }
            catch (ConfigurationException configurationException) {
                configurationException.printStackTrace();
            }
        }
        iterator = null;
        double d4 = System.currentTimeMillis();
        _$3.info((Object)("\u603b\u5171\u68c0\u6d4b\u4e86" + this._$1.size() + "\u4e2a\u8bbe\u5907\uff0c\u8017\u65f6" + (d4 - d) / 1000.0 + "\u79d2"));
        this._$2 = CheckStatus.STOPPED;
    }

    public void remove(Object object) {
        DeviceBean deviceBean = this.findDevice(object);
        if (deviceBean == null) {
            return;
        }
        this._$1.remove(deviceBean);
    }

    public DeviceBean add(SerialModemBean serialModemBean) {
        DeviceBean deviceBean = this.findDevice(serialModemBean);
        if (deviceBean != null) {
            return deviceBean;
        }
        return this.add(new DeviceBean(serialModemBean));
    }

    public DeviceBean add(DeviceBean deviceBean) {
        DeviceBean deviceBean2 = this.findDevice(deviceBean);
        if (deviceBean2 != null) {
            return deviceBean2;
        }
        this._$1.add(deviceBean);
        Collections.sort(this._$1);
        return deviceBean;
    }

    public DeviceBean add(String string) {
        String string2 = _$5 + _$4;
        this._$3();
        SerialModemBean serialModemBean = new SerialModemBean(string, string2);
        return this.add(serialModemBean);
    }

    public SerialModemBean get(Object object) {
        DeviceBean deviceBean = this.findDevice(object);
        if (deviceBean == null) {
            return null;
        }
        return deviceBean._$3;
    }

    public SerialModemBean findByPort(String string) {
        SerialModemBean serialModemBean = null;
        for (DeviceBean deviceBean : this._$1) {
            SerialModemBean serialModemBean2 = deviceBean.getDeviceInfo();
            if (serialModemBean2 == null || serialModemBean2.getPort() == null || !serialModemBean2.getPort().equalsIgnoreCase(string)) continue;
            serialModemBean = serialModemBean2;
            break;
        }
        return serialModemBean;
    }

    public DeviceBean findDevice(Object object) {
        DeviceBean deviceBean = (DeviceBean)CollectionUtils.find(this._$1, (Predicate)new IIIllllIllIlllll(this, object));
        return deviceBean;
    }

    public List<SerialModemBean> getAll() throws CloneNotSupportedException {
        ArrayList<SerialModemBean> arrayList = new ArrayList<SerialModemBean>();
        for (int i = 0; i < this._$1.size(); ++i) {
            arrayList.add(this._$1.get(i)._$3);
        }
        return arrayList;
    }

    public DeviceBean put(SerialModemBean serialModemBean) {
        DeviceBean deviceBean = this.findDevice(serialModemBean);
        if (deviceBean == null) {
            deviceBean = this.add(new DeviceBean(serialModemBean));
        } else {
            deviceBean._$3 = serialModemBean;
        }
        return deviceBean;
    }

    static /* synthetic */ Logger _$2() {
        return _$3;
    }

    static {
        _$3 = Logger.getRootLogger();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DeviceBean
    implements Comparable<Object> {
        private SerialModemBean _$3;
        private ModemGateway _$2;

        public SerialModemBean getDeviceInfo() {
            return this._$3;
        }

        public ModemGateway getGateway() {
            return this._$2;
        }

        public void setGateway(ModemGateway modemGateway) {
            this._$2 = modemGateway;
        }

        public DeviceBean(String string) {
            String string2 = DeviceInfoCache._$5 + _$4;
            DeviceInfoCache.this._$3();
            this._$3 = new SerialModemBean(string, string2);
        }

        public DeviceBean(SerialModemBean serialModemBean) {
            if (serialModemBean.getGatewayID() == null) {
                serialModemBean.setGatewayID(DeviceInfoCache._$5 + _$4);
                DeviceInfoCache.this._$3();
            }
            this._$3 = serialModemBean;
        }

        public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
            this._$2 = "IpModem".equals(this._$3.getModemFlag()) ? new IPModemGateway(this._$3) : new SerialModemGateway(this._$3);
            this._$2.startGateway();
        }

        @Override
        public int compareTo(Object object) {
            int n = 0;
            if (object instanceof String) {
                String string = (String)object;
                n = string.equals(this._$3.getPort()) || string.equals(this._$3.getGatewayID()) ? 0 : (string.length() > this._$3.getPort().length() ? -1 : (string.length() == this._$3.getPort().length() ? this._$3.getPort().compareTo(string) : 1));
            } else if (object instanceof DeviceBean) {
                DeviceBean deviceBean = (DeviceBean)object;
                String string = deviceBean._$3.getPort();
                n = string.length() > this._$3.getPort().length() ? -1 : (string.length() == this._$3.getPort().length() ? this._$3.getPort().compareTo(string) : 1);
            } else if (object instanceof SerialModemBean) {
                SerialModemBean serialModemBean = (SerialModemBean)object;
                String string = serialModemBean.getPort();
                n = string.length() > this._$3.getPort().length() ? -1 : (string.length() == this._$3.getPort().length() ? this._$3.getPort().compareTo(string) : 1);
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CheckStatus {
        RUNNING,
        STOPPED;

    }
}

