/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.Service;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.web.GetPortInfo;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.commons.io.IOUtils;

public class GetSerialPortInfo
extends GetPortInfo {
    protected SerialPort serialPort = null;
    private InputStream _$2 = null;
    private OutputStream _$1 = null;
    protected Properties options = null;
    public static int[] botelvs = new int[]{115200, 9600};
    public static final String PORT_NAME = "portname";
    public static final String BAUDRATE = "baudrate";
    public static final String AT = "at";
    public static final String NOCSQ = "csq";
    public static final String NOCCID = "ccid";
    public static final String NOVERSION = "version";
    public static final String NOMODEL = "model";
    public static final String NOSERIALNUMBER = "serialnumber";
    public static final String NOMANUFACTURER = "manufacturer";
    public static final String CFUN = "cfun";
    public static final int SERVER_PORT = 8092;

    public GetSerialPortInfo(Properties properties) {
        this.options = properties;
        this.serialmodem = new SerialModemBean(properties.getProperty(PORT_NAME, ""), null);
    }

    protected void open() throws Exception {
        this.serialPort = new SerialPort(this.serialmodem.getPort());
        boolean bl = this.serialPort.openPort();
        this.serialPort.setFlowControlMode(0);
    }

    protected void init(int n) throws Exception {
        this.serialPort.setParams(n, 8, 1, 0);
        this.serialmodem.setBaudrate(n);
    }

    protected void testOK() throws Exception {
        String string = "";
        String[] stringArray = null;
        boolean bl = this.serialPort.writeString("AT\r");
        Thread.sleep(Service.getInstance().getSettings().AT_WAIT);
        int n = 0;
        while (this.serialPort.getInputBufferBytesCount() <= 0) {
            Thread.sleep(200L);
            if (++n != 15) continue;
        }
        if (n >= 15 && this.serialPort.getInputBufferBytesCount() <= 0) {
            Logger.getInstance().logError("\u8d85\u8fc73s\u53d1\u9001at\u6307\u4ee4\u6ca1\u6709\u5f97\u5230\u8fd4\u56de\u6570\u636e", null, null);
            throw new Exception();
        }
        string = this.serialPort.readString();
        bl = this.serialPort.writeBytes("AT\r".getBytes());
        Thread.sleep(Service.getInstance().getSettings().AT_WAIT);
        n = 0;
        while (this.serialPort.getInputBufferBytesCount() <= 0) {
            Thread.sleep(200L);
            if (++n != 30) continue;
        }
        if ((stringArray = (string = this.serialPort.readString()).replaceAll("\\s+\\s+", " ").replaceAll("\n", " ").replaceAll("\r", " ").split(" "))[stringArray.length - 1].indexOf("OK") == -1 && stringArray[stringArray.length - 1].indexOf("ERROR") == -1) {
            throw new Exception();
        }
        this.serialmodem.setAtFlag(stringArray[stringArray.length - 1]);
    }

    protected void getCardNumber() throws Exception {
        if (this.options.getProperty(NOCCID) != null) {
            return;
        }
        String string = null;
        string = this.athandle("AT+CCID\r");
        if (string.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(string.substring(string.indexOf(58) + 1));
        }
    }

    protected void getCardNumberForINCORPORATED() throws Exception {
        if (this.options.getProperty(NOCCID) != null) {
            return;
        }
        String string = null;
        string = this.athandle("AT+CICCID\r");
        if (string.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(string.substring(string.indexOf(58) + 1));
        }
    }

    protected void getCardNumber2() throws Exception {
        if (this.options.getProperty(NOCCID) != null) {
            return;
        }
        String string = null;
        string = this.athandle("AT^ICCID?\r");
        if (string.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(string.substring(string.indexOf(58) + 1));
        }
    }

    protected void getCardNumber3() throws Exception {
        this.getCardNumber2();
    }

    protected void getCardNumber1() throws Exception {
        if (this.options.getProperty(NOCCID) != null) {
            return;
        }
        String string = null;
        string = this.athandle("AT+CXXCID\r");
        if (string.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(string.substring(string.indexOf(58) + 1));
        }
    }

    protected void getCardNumber4() throws Exception {
        if (this.options.getProperty(NOCCID) != null) {
            return;
        }
        String string = null;
        string = this.athandle("AT+ICCID\r");
        if (string.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(string.substring(string.indexOf(58) + 1));
        }
    }

    protected void getSignal() throws Exception {
        if (this.options.getProperty(NOCSQ) != null) {
            return;
        }
        String string = null;
        String string2 = "\\+CSQ:\\s*\\d{1,2},\\d{1,2}";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string = this.athandle("AT+CSQ\r"));
        if (matcher.find()) {
            string = matcher.group(0);
            this.serialmodem.setCsq(string.substring(string.indexOf(58) + 1));
        } else if (string.indexOf("ERROR") == -1) {
            throw new Exception();
        }
    }

    protected String getVersion() throws Exception {
        if (this.options.getProperty(NOVERSION) != null) {
            return NOVERSION;
        }
        String string = null;
        string = this.athandle("ATI3\r");
        if (string == null) {
            return NOVERSION;
        }
        return string;
    }

    protected void getSerialNumber() throws Exception {
        if (this.options.getProperty(NOSERIALNUMBER) != null) {
            return;
        }
        String string = null;
        String string2 = "SerialNumber[a-z0-9A-Z]+";
        String string3 = "\\+WMSN:SerialNumber:[a-z0-9A-Z]+";
        Logger.getInstance().logInfo("TO SEND AT+WMSN (2)", null, null);
        string = this.athandle("AT+WMSN\r");
        if (string.matches(string2) || string.matches(string3)) {
            if (string.matches(string2)) {
                this.serialmodem.setSerialnum(string.replace("SerialNumber", ""));
            } else {
                this.serialmodem.setSerialnum(string.replaceFirst("\\+WMSN:SerialNumber:", ""));
            }
        } else if (string.indexOf("SerialNumber") != -1) {
            this.serialmodem.setSerialnum(string.substring(string.indexOf("SerialNumber") + 12));
        } else if (string.indexOf("ERROR") != -1) {
            this.getSerialNumber1();
        } else if (string.indexOf("NOT") != -1) {
            this.getSerialNumber1();
        } else {
            throw new Exception();
        }
    }

    protected void getSerialNumber1() throws Exception {
        if (this.options.getProperty(NOSERIALNUMBER) != null) {
            return;
        }
        String string = null;
        String string2 = "[a-z0-9A-Z]+";
        string = this.athandle("AT+CGSN\r");
        if ((string = string.substring(string.indexOf(58) + 1)).matches(string2)) {
            this.serialmodem.setSerialnum(string.substring(string.indexOf(58) + 1));
        } else if (string.indexOf("ERROR") == -1) {
            throw new Exception();
        }
    }

    protected void getManufacturer() throws Exception {
        if (this.options.getProperty(NOMANUFACTURER) != null) {
            return;
        }
        String string = null;
        string = this.athandle("ATI\r");
        System.out.println("result=" + string);
        if (string.indexOf("ERROR") != -1) {
            this.serialmodem.setManufacturer("");
        } else if (string.indexOf("WAVECOM") != -1 || string.indexOf("WISMOQ") != -1 || string.indexOf("SierraWireless") != -1) {
            this.serialmodem.setManufacturer("Wavecom");
        } else if (string.indexOf("SIEMENS") != -1) {
            this.serialmodem.setManufacturer("Siemens");
        } else if (string.indexOf("Quectel_Ltd") != -1) {
            this.serialmodem.setManufacturer("Quectel_Ltd");
        } else if (string.indexOf("Quectel") != -1) {
            this.serialmodem.setManufacturer("Quectel");
        } else if (string.indexOf("Yuga") != -1) {
            this.serialmodem.setManufacturer("Yuga");
        } else if (string.indexOf("TDTech") != -1) {
            this.serialmodem.setManufacturer("TDTech");
        } else if (string.indexOf("INCORPORATED") != -1) {
            this.serialmodem.setManufacturer("INCORPORATED");
        } else if (string.indexOf("MEIG") != -1) {
            this.serialmodem.setManufacturer("MEIG");
        } else if ((string = string.toLowerCase()).indexOf("huawei") != -1) {
            this.serialmodem.setManufacturer("Huawei");
        } else {
            throw new Exception();
        }
    }

    protected void getModel1() throws Exception {
        if (this.options.getProperty(NOMODEL) != null) {
            return;
        }
        String string = null;
        string = this.athandle("AT+CGMR\r");
        System.out.println("debug: " + string);
        if (string.indexOf("ERROR") != -1) {
            this.serialmodem.setModel("");
        } else if (string.indexOf("WISM") != -1) {
            this.serialmodem.setModel("WISMOQCDMA");
        } else {
            this.serialmodem.setModel("");
        }
    }

    protected void getModel2() throws Exception {
        this.getModel();
    }

    protected void getModel() throws Exception {
        if (this.options.getProperty(NOMODEL) != null) {
            return;
        }
        String string = null;
        string = this.athandle("AT+CGMM\r");
        if (string.indexOf("ERROR") != -1) {
            this.serialmodem.setModel("");
        } else if (string.indexOf("Quectel_M35") != -1) {
            this.serialmodem.setModel("Quectel_M35");
        } else if (string.indexOf("Quectel_M26") != -1) {
            this.serialmodem.setModel("Quectel_M26");
        } else if (string.indexOf("EC20F") != -1) {
            this.serialmodem.setModel("EC20F");
        } else if (string.indexOf("MC323") != -1) {
            this.serialmodem.setModel("MC323");
        } else if (string.indexOf("MG301") != -1) {
            this.serialmodem.setModel("MG301");
        } else if (string.indexOf("ME909") != -1) {
            this.serialmodem.setModel("ME909");
        } else if (string.indexOf("ME901") != -1) {
            this.serialmodem.setModel("ME901");
        } else if (string.indexOf("CLM920_NC5") != -1) {
            this.serialmodem.setModel("CLM920_NC5");
        } else if (string.indexOf("CLM920_RC3") != -1) {
            this.serialmodem.setModel("CLM920_RC3");
        } else if (string.indexOf("CLM920_RV3") != -1) {
            this.serialmodem.setModel("CLM920_RV3");
        } else if (string.indexOf("A7600C1-SE") != -1) {
            this.serialmodem.setModel("A7600C1_SE");
        } else if (string.indexOf("SIMCOM_SIM7600CE-L") != -1) {
            this.serialmodem.setModel("SIMCOM_SIM7600CE_L");
        } else if (string.indexOf("MH5000-31") != -1) {
            this.serialmodem.setModel("MH5000-31");
        } else if (string.indexOf("SLM750-V") != -1) {
            this.serialmodem.setModel("SLM750_V");
        } else {
            this.serialmodem.setModel("");
        }
    }

    protected String athandle(String string) throws Exception {
        String string2 = null;
        this._$1.write(string.getBytes());
        this._$1.flush();
        string2 = "";
        int n = this._$2.read();
        while (n != -1) {
            string2 = string2 + (char)n;
            n = this._$2.read();
        }
        System.out.println(string2);
        string2 = string2.replace(string, "").replaceAll("\\s+OK\\s+", "").replaceAll("\\s+", "");
        return string2;
    }

    protected void close() {
        IOUtils.closeQuietly((InputStream)this._$2);
        IOUtils.closeQuietly((OutputStream)this._$1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handler() {
        try {
            this.open();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                // empty if block
            }
            this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
            exception.printStackTrace();
            return;
        }
        for (int i = 0; i < botelvs.length; ++i) {
            int n = Integer.parseInt(this.options.getProperty(BAUDRATE, "0"));
            try {
                String string;
                if (n == 0) {
                    this.init(botelvs[i]);
                } else {
                    this.init(n);
                }
                this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                this.testOK();
                this.getSignal();
                this.getManufacturer();
                if (this.serialmodem.getManufacturer().equalsIgnoreCase("Siemens")) {
                    this.getModel2();
                    this.getCardNumber1();
                    this.getSerialNumber1();
                } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("Huawei")) {
                    this.getModel2();
                    if (this.serialmodem.getModel().equalsIgnoreCase("MC323")) {
                        this.serialmodem.setProtocol(AGatewayHelper.Protocols.TEXT);
                        this._$1();
                    }
                    if (this.serialmodem.getModel().equalsIgnoreCase("MG301")) {
                        string = null;
                        string = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(string);
                    }
                    this.getCardNumber();
                } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("WAVECOM")) {
                    this.getModel1();
                    if (this.serialmodem.getModel().equalsIgnoreCase("WISMOQCDMA")) {
                        this.getSerialNumber1();
                        this.serialmodem.setProtocol(AGatewayHelper.Protocols.TEXT);
                    } else {
                        this.getSerialNumber();
                    }
                    this.getCardNumber();
                } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("Yuga")) {
                    this.getModel();
                    if (this.serialmodem.getModel().equalsIgnoreCase("CLM920_RC3")) {
                        this.getCardNumber4();
                    } else if (this.serialmodem.getModel().equalsIgnoreCase("CLM920_RV3")) {
                        this.getCardNumber4();
                    } else if (this.serialmodem.getModel().equalsIgnoreCase("CLM920_NC5")) {
                        this.getCardNumber();
                    }
                } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("INCORPORATED")) {
                    this.getModel();
                    if (this.serialmodem.getModel().equalsIgnoreCase("A7600C1_SE")) {
                        string = null;
                        string = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(string);
                        this.getCardNumberForINCORPORATED();
                    } else if (this.serialmodem.getModel().equalsIgnoreCase("SIMCOM_SIM7600CE_L")) {
                        string = null;
                        string = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(string);
                        this.getCardNumberForINCORPORATED();
                    }
                } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("TDTech")) {
                    this.getModel();
                    if (this.serialmodem.getModel().equalsIgnoreCase("ME909")) {
                        string = null;
                        string = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(string);
                        this.getCardNumber2();
                    } else if (this.serialmodem.getModel().equalsIgnoreCase("ME901")) {
                        string = null;
                        string = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(string);
                        this.getCardNumber();
                    }
                } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("MEIG")) {
                    this.getModel();
                    if (this.serialmodem.getModel().equalsIgnoreCase("SLM750_V")) {
                        this.getCardNumber4();
                    }
                }
            }
            catch (Exception exception) {
                if (!this.serialmodem.getAtFlag().equals("OK")) {
                    this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
                }
            }
            if (this.serialmodem.getStatus() != AGatewayHelper.GatewayStatuses.FAILURE || n != 0) break;
        }
        if (this.serialPort != null && this.serialPort.isOpened()) {
            try {
                this.serialPort.closePort();
            }
            catch (SerialPortException serialPortException) {
                serialPortException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress("127.0.0.1", 8092), 10000);
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            properties = (Properties)objectInputStream.readObject();
            GetSerialPortInfo getSerialPortInfo = new GetSerialPortInfo(properties);
            getSerialPortInfo.handler();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(getSerialPortInfo.serialmodem);
            objectOutputStream.flush();
            socket.getInputStream().read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        System.exit(0);
    }

    private static String _$2() {
        char[] cArray = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        Random random = new Random();
        String string = "";
        for (int i = 0; i < 17; ++i) {
            string = string + cArray[random.nextInt(10)];
        }
        return string;
    }

    private void _$1() throws Exception {
        String string;
        String string2 = null;
        string2 = this.athandle("AT+CPBS=\"ME\"\r");
        string2 = this.athandle("AT^CPBR=1\r");
        String string3 = "";
        if (string2.indexOf("ERROR") != -1) {
            string = GetSerialPortInfo._$2();
            this.athandle("AT^CPBW=1,\"" + string + "\",129,\"WMSN\"\r");
            string2 = this.athandle("AT^CPBR=1\r");
        } else {
            string3 = string2.substring(string2.lastIndexOf(44, string2.length() - 3) + 1, string2.lastIndexOf(","));
            System.out.println("key:" + string3);
            if ((string2.equals("") || !string3.equals("\"WMSN\"")) && string2.indexOf("ERROR") == -1) {
                string = GetSerialPortInfo._$2();
                this.athandle("AT^CPBW=1,\"" + string + "\",129,\"WMSN\"\r");
                string2 = this.athandle("AT^CPBR=1\r");
            }
        }
        string2 = string2.substring(string2.indexOf(58) + 1);
        string3 = string2.substring(string2.lastIndexOf(44, string2.length() - 3) + 1, string2.lastIndexOf(","));
        if (string2.indexOf("ERROR") != -1) {
            return;
        }
        if (string2.trim().equals("")) {
            return;
        }
        if (!string3.equals("\"WMSN\"")) {
            return;
        }
        string = string2.split(",")[1];
        this.serialmodem.setSerialnum(string.substring(1, string.length() - 1));
    }
}

