/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduParser;
import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import cn.sendsms.AGateway;
import cn.sendsms.Contact;
import cn.sendsms.GatewayException;
import cn.sendsms.InboundBinaryMessage;
import cn.sendsms.InboundEncryptedMessage;
import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundBinaryMessage;
import cn.sendsms.OutboundMessage;
import cn.sendsms.Phonebook;
import cn.sendsms.Service;
import cn.sendsms.StatusReportMessage;
import cn.sendsms.TimeoutException;
import cn.sendsms.TmpMsg;
import cn.sendsms.USSDRequest;
import cn.sendsms.UnknownMessage;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.AlertInfo;
import cn.sendsms.jdsmsserver.web.Authorize1;
import cn.sendsms.jdsmsserver.web.DbHelper;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.RegCodeGen;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.modem.AModemDriver;
import cn.sendsms.modem.SerialModemDriver;
import cn.sendsms.modem.athandler.AATHandler;
import cn.sendsms.modem.athandler.ATHandler_Huawei_ME909;
import cn.sendsms.modem.athandler.ATHandler_INCORPORATED_A7600C1_SE;
import cn.sendsms.modem.athandler.ATHandler_INCORPORATED_SIMCOM_SIM7600CE_L;
import cn.sendsms.modem.athandler.ATHandler_TDTech_ME901;
import cn.sendsms.modem.athandler.ATHandler_TDTech_ME909;
import cn.sendsms.modem.athandler.ATHandler_Yuga;
import cn.sendsms.modem.athandler.ATHandler_Yuga_CLM920_NC5;
import cn.sendsms.modem.athandler.ATHandler_Yuga_CLM920_RC3;
import cn.sendsms.modem.athandler.ATHandler_Yuga_CLM920_RV3;
import cn.sendsms.modem.lIIlIlIIlIIIlIll;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModemGateway
extends AGateway {
    private static boolean _$28 = false;
    private AModemDriver _$27;
    private AATHandler _$26;
    private String _$25;
    private int _$24;
    private IPProtocols _$23;
    private boolean _$22;
    private long _$21;
    private String _$20;
    private String _$19;
    private String _$18;
    private String _$17;
    private String _$16;
    private String _$15;
    private int _$14;
    private List<List<InboundMessage>> _$13;
    private Object _$12 = new Object();
    private boolean _$11;

    public ModemGateway(ModemTypes modemTypes, String string, String string2, int n, String string3, String string4) {
        super(string);
        this._$1(modemTypes, string2, n, string3, string4, null);
    }

    public ModemGateway(String string, String string2, int n, String string3, String string4, AModemDriver aModemDriver) {
        super(string);
        this._$1(null, string2, n, string3, string4, aModemDriver);
    }

    private void _$1(ModemTypes modemTypes, String string, int n, String string2, String string3, AModemDriver aModemDriver) {
        if ("MH5000-31".equals(string3)) {
            string3 = "MH5000_31";
            string3 = string3.replaceAll("-", "_");
        }
        this.setModemDevice(string);
        this.setModemParms(n);
        this.setIpProtocol(IPProtocols.BINARY);
        this.setIpEncryption(false);
        this._$1(-1L);
        this._$20 = string2;
        this._$19 = string3;
        this.setAttributes(251);
        if (aModemDriver != null) {
            this.setDriver(aModemDriver);
        } else if (modemTypes == ModemTypes.SERIAL) {
            this.setDriver(new SerialModemDriver(this, this.getModemDevice() + ":" + this.getModemParms()));
        } else {
            this.setDriver(new lIIlIlIIlIIIlIll(this, this.getModemDevice() + ":" + this.getModemParms()));
        }
        this.setAtHandler(AATHandler.load(this, this._$20, this._$19));
        this.setSimPin("");
        this.setSimPin2("");
        this.setSmscNumber("");
        this.setCustomInitString("");
        this._$14 = new Random().nextInt();
        if (this._$14 < 0) {
            this._$14 *= -1;
        }
        this._$14 %= 65536;
        this._$13 = new ArrayList<List<InboundMessage>>();
    }

    private boolean _$3() {
        return this.getAtHandler() instanceof ATHandler_Huawei_ME909 || this.getAtHandler() instanceof ATHandler_Yuga || this.getAtHandler() instanceof ATHandler_Yuga_CLM920_RC3 || this.getAtHandler() instanceof ATHandler_Yuga_CLM920_RV3 || this.getAtHandler() instanceof ATHandler_Yuga_CLM920_NC5 || this.getAtHandler() instanceof ATHandler_TDTech_ME909 || this.getAtHandler() instanceof ATHandler_TDTech_ME901 || this.getAtHandler() instanceof ATHandler_INCORPORATED_A7600C1_SE || this.getAtHandler() instanceof ATHandler_INCORPORATED_SIMCOM_SIM7600CE_L;
    }

    public void setIpProtocol(IPProtocols iPProtocols) {
        this._$23 = iPProtocols;
    }

    public IPProtocols getIpProtocol() {
        return this._$23;
    }

    public void setIpEncryption(boolean bl) {
        this._$22 = bl;
    }

    public boolean getIpEncryption() {
        return this._$22;
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Starting gateway, using " + this.getATHandler().getDescription() + " AT Handler.", null, this.getGatewayId());
        this.getDriver().connect();
        super.startGateway();
        Logger.getInstance().logInfo("Gateway started.", null, this.getGatewayId());
    }

    protected void judgeAuthorize() {
        String string = null;
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        try {
            SerialModemBean serialModemBean = DeviceInfoCache.getInstance().get(this.getGatewayId());
            if (serialModemBean.getManufacturer().equalsIgnoreCase("Wavecom") && !serialModemBean.getModel().equalsIgnoreCase("WISMOQCDMA")) {
                String string4 = this.sendCustomATCommand("ATI3\r");
                string2 = string4.indexOf("Q2406B") != -1 ? this.getSerialNo() : this.getSerialNumber();
                if (string2 == null || string2.indexOf("ERROR") >= 0 || string2.indexOf("N/A") >= 0) {
                    string2 = this.getSerialNo();
                }
            } else {
                string2 = this.getSerialNo();
            }
            Logger.getInstance().logInfo("\u8bbe\u5907\u5e8f\u5217\u53f7\uff1a" + string2, null, this.getGatewayId());
            if (string2.equalsIgnoreCase("N/A")) {
                return;
            }
            string3 = serialModemBean.getPort();
            serialModemBean.setSerialnum(string2);
            string = Authorize1.getAuthorizeInfo(string2, "regcode");
            Logger.getInstance().logInfo("\u8bbe\u5907\u6ce8\u518c\u7801\uff1a" + string, null, this.getGatewayId());
            bl = RegCodeGen.getRegCode(string2).equals(string);
            DeviceInfoCache.getInstance().get(this.getGatewayId()).setValidate(bl);
            if (bl) {
                Authorize1.updateAuthorize(string3, string2, string, 1);
                Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, this.getGatewayId());
            } else {
                Authorize1.updateAuthorize(string3, string2, string, 0);
                Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, this.getGatewayId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Starting gateway ", null, this.getGatewayId());
        this.getDriver().testconnect();
        Logger.getInstance().logInfo("Gateway started.", null, this.getGatewayId());
    }

    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Stopping gateway...", null, this.getGatewayId());
        try {
            super.stopGateway();
        }
        catch (Exception exception) {
            Logger.getInstance().logError("Gateway stopping occur error.", null, this.getGatewayId());
        }
        this.getDriver().disconnect();
        Logger.getInstance().logInfo("Gateway stopped.", null, this.getGatewayId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readMessages(Collection<InboundMessage> collection, InboundMessage.MessageClasses messageClasses) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
            return;
        }
        SerialModemBean serialModemBean = DeviceInfoCache.getInstance().get(this.getGatewayId());
        String string = serialModemBean.getSerialnum();
        if (string.trim().length() <= 0) {
            string = serialModemBean.getManufacturer().equalsIgnoreCase("Wavecom") && !serialModemBean.getModel().equalsIgnoreCase("WISMOQCDMA") ? this.getSerialNumber() : this.getSerialNo();
        }
        if (string.indexOf("N/A") >= 0) {
            throw new GatewayException("\u83b7\u53d6\u8bbe\u5907\u5e8f\u5217\u53f7\u5931\u8d25");
        }
        try {
            int n;
            boolean bl = Authorize1.isAuthorized2(string);
            if (!bl && (n = Authorize1.getAvaliableNum(string)) < 1 && !_$28) {
                _$28 = true;
                Logger.getInstance().logWarn("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1", null, this.getGatewayId());
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        Iterator<InboundMessage> iterator = this.getDriver().getSYNCCommander();
        synchronized (iterator) {
            if (this.getModemDriver().isOccurTimeoutError()) {
                return;
            }
            if (this.getProtocol() == AGatewayHelper.Protocols.PDU) {
                try {
                    this._$1(collection, messageClasses, 0);
                }
                catch (Exception exception) {
                    Logger.getInstance().logError("\u8bfb\u53d6pdu\u77ed\u4fe1\u65f6\u51fa\u73b0\u5f02\u5e38", exception, this.getGatewayId());
                }
            } else if (this.getProtocol() == AGatewayHelper.Protocols.TEXT) {
                this._$2(collection, messageClasses, 0);
            }
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            InboundMessage inboundMessage = iterator.next();
            if (!inboundMessage.getGatewayId().equals(this.getGatewayId())) continue;
            if (!this._$1(inboundMessage, string)) {
                iterator.remove();
                continue;
            }
            SerialModemBean serialModemBean2 = DeviceInfoCache.getInstance().get(this.getGatewayId());
            string = serialModemBean2.getSerialnum();
            if (string.trim().length() <= 0) {
                string = serialModemBean2.getManufacturer().equalsIgnoreCase("Wavecom") && !serialModemBean2.getModel().equalsIgnoreCase("WISMOQCDMA") ? this.getSerialNumber() : this.getSerialNo();
            }
            if (string.indexOf("N/A") >= 0) {
                throw new GatewayException("\u83b7\u53d6\u8bbe\u5907\u5e8f\u5217\u53f7\u5931\u8d25");
            }
            int n = Authorize1.getAvaliableNum(string);
            --n;
            try {
                Authorize1.updateAvaliableNum(string, n);
            }
            catch (SQLException sQLException) {
                return;
            }
        }
    }

    private boolean _$1(Message message, String string) {
        String string2 = "<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>";
        try {
            if (string == null) {
                SerialModemBean serialModemBean = DeviceInfoCache.getInstance().get(this.getGatewayId());
                string = serialModemBean.getSerialnum();
                if (string.trim().length() <= 0) {
                    string = serialModemBean.getManufacturer().equalsIgnoreCase("Wavecom") && !serialModemBean.getModel().equalsIgnoreCase("WISMOQCDMA") ? this.getSerialNumber() : this.getSerialNo();
                }
                if (string.indexOf("N/A") >= 0) {
                    throw new GatewayException("\u83b7\u53d6\u8bbe\u5907\u5e8f\u5217\u53f7\u5931\u8d25");
                }
            }
            if (!Authorize1.isAuthorized2(string)) {
                int n = Authorize1.getAvaliableNum(string);
                Logger.getInstance().logWarn("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u5f53\u524d\u8fd8\u53ef\u6536\u53d1\u77ed\u4fe1" + n + "\u6761", null, this.getGatewayId());
                if (n < 1) {
                    Logger.getInstance().logWarn("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1", null, this.getGatewayId());
                    return false;
                }
                if (!(message instanceof InboundBinaryMessage)) {
                    if (message instanceof InboundMessage) {
                        if (message.getText().indexOf(string2) == -1) {
                            message.setText(string2 + message.getText());
                        }
                    } else {
                        if (message instanceof OutboundBinaryMessage) {
                            Logger.getInstance().logWarn("\u4e0d\u652f\u6301\u53d1\u9001\u5f69\u4fe1", null, this.getGatewayId());
                            return false;
                        }
                        if (message instanceof OutboundMessage && message.getText().indexOf(string2) == -1) {
                            message.setText(string2 + message.getText());
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InboundMessage readMessage(String string, int n) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
            return null;
        }
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            ArrayList<InboundMessage> arrayList = new ArrayList<InboundMessage>();
            this.readMessages(arrayList, InboundMessage.MessageClasses.ALL);
            Iterator iterator = arrayList.iterator();
            if (iterator.hasNext()) {
                InboundMessage inboundMessage = (InboundMessage)iterator.next();
                if (inboundMessage.getMemIndex() == n && inboundMessage.getMemLocation().equals(string)) {
                    iterator = null;
                }
                return inboundMessage;
            }
            iterator = null;
            return null;
        }
    }

    @Override
    public boolean sendMessage(OutboundMessage outboundMessage) throws TimeoutException, GatewayException, IOException, InterruptedException, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        AlertInfo alertInfo;
        SerialModemBean serialModemBean;
        DbHelper dbHelper;
        if (this.sendMessageA(outboundMessage)) {
            dbHelper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            serialModemBean = DeviceInfoCache.getInstance().get(this.getGatewayId());
            alertInfo = serialModemBean.getAlert();
            if (alertInfo == null) {
                return true;
            }
            int n = alertInfo.getSentNumber();
            int n2 = alertInfo.getAlertNumber();
            String string = alertInfo.getCallNumber();
            String string2 = alertInfo.getAlertMsg();
            int n3 = alertInfo.getMaxLimitNumber();
            for (int i = outboundMessage.getSplitNum(); i > 0; --i) {
                String string3;
                alertInfo.setSentNumber(++n);
                if (n != n3 || n3 <= 0 || n3 > n2) continue;
                OutboundMessage outboundMessage2 = outboundMessage;
                if (string2.indexOf("#K#") != -1) {
                    string2 = string3 = string2.substring(0, string2.indexOf("#K#")) + String.valueOf(alertInfo.getAlertNumber()) + string2.substring(string2.indexOf("#K#") + 3);
                }
                if (string2.indexOf("#Y#") != -1) {
                    string2 = string3 = string2.substring(0, string2.indexOf("#Y#")) + String.valueOf(alertInfo.getSentNumber()) + string2.substring(string2.indexOf("#Y#") + 3);
                }
                if (string2.indexOf("#S#") != -1) {
                    string2 = string3 = string2.substring(0, string2.indexOf("#S#")) + String.valueOf(alertInfo.getAlertNumber() - alertInfo.getSentNumber()) + string2.substring(string2.indexOf("#S#") + 3);
                }
                outboundMessage2.setText(string2);
                outboundMessage2.setRecipient(string);
                try {
                    dbHelper.insertMessage(false, string, string2, serialModemBean.getGatewayID(), null, null);
                    continue;
                }
                catch (Exception exception) {
                    Logger.getInstance().logError("\u63d2\u5165\u544a\u8b66\u51fa\u9519", exception, this.getGatewayId());
                    exception.printStackTrace();
                }
            }
        } else {
            return false;
        }
        serialModemBean.setAlert(alertInfo);
        dbHelper.AddAlertInfoToDB(alertInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessageA(OutboundMessage outboundMessage) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logDebug("in sendMessageA", null, this.getGatewayId());
        boolean bl = false;
        boolean bl2 = false;
        if (this.getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
            return false;
        }
        long l = 3600 / Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.send_speed", "600")) * 1000;
        Object object = this._$12;
        synchronized (object) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (this._$2() == -1L) {
                bl = true;
            }
            if (!bl && System.currentTimeMillis() - this._$2() > 4000L) {
                bl = true;
            }
            Logger.getInstance().logDebug("in sendMessageA--before processMsg", null, this.getGatewayId());
            if (!this._$1(outboundMessage, null)) {
                return false;
            }
            if (this.getModemDriver().isOccurFull()) {
                Logger.getInstance().logInfo("\u77ed\u4fe1\u6c60\u5df2\u6ee1,\u7b49\u5f85\u5904\u7406,\u53d1\u9001\u88ab\u6682\u505c", null, this.getGatewayId());
                if (!this.threadWait(6000L)) {
                    // empty if block
                }
                return false;
            }
            Logger.getInstance().logDebug("in sendMessageA--after processMsg", null, this.getGatewayId());
            Object object2 = this.getDriver().getSYNCCommander();
            synchronized (object2) {
                Logger.getInstance().logInfo("send command lock", null, this.getGatewayId());
                if (this.getModemDriver().isOccurTimeoutError()) {
                    return false;
                }
                int n = this.getAtHandler().getSimNums();
                if (this.threadWait(Integer.valueOf(JDSMSServer.getInstance().getProperties().getString("settings.seek_time", "1000")).intValue()) && (n = this.getAtHandler().getSimNums()) > 0) {
                    Logger.getInstance().logInfo("\u83b7\u53d6\u5230\u7684\u77ed\u4fe1\u6570\u91cf\u4e3a" + n, null, this.getGatewayId());
                    return false;
                }
                if (bl) {
                    this.getAtHandler().keepLinkOpen();
                }
                this._$1(System.currentTimeMillis());
                bl2 = this.getProtocol() == AGatewayHelper.Protocols.PDU ? this._$1(outboundMessage) : (this.getProtocol() == AGatewayHelper.Protocols.TEXT ? this._$2(outboundMessage) : false);
                Logger.getInstance().logInfo("send command unlock", null, this.getGatewayId());
            }
            if (bl2) {
                object2 = DeviceInfoCache.getInstance().get(this.getGatewayId());
                String string = "";
                string = ((SerialModemBean)object2).getSerialnum();
                if (string.trim().length() <= 0) {
                    string = ((SerialModemBean)object2).getManufacturer().equalsIgnoreCase("Wavecom") && !((SerialModemBean)object2).getModel().equalsIgnoreCase("WISMOQCDMA") ? this.getSerialNumber() : this.getSerialNo();
                }
                if (string.indexOf("N/A") >= 0) {
                    throw new GatewayException("\u83b7\u53d6\u8bbe\u5907\u5e8f\u5217\u53f7\u5931\u8d25");
                }
                int n = Authorize1.getAvaliableNum(string);
                --n;
                try {
                    Authorize1.updateAvaliableNum(string, n);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            stopWatch.stop();
            if (l - stopWatch.getTime() <= 0L || !this.threadWait(l - stopWatch.getTime())) {
                // empty if block
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteMessage(InboundMessage inboundMessage) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
            return false;
        }
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            if (inboundMessage.getMemIndex() >= 0) {
                return this._$1(inboundMessage.getMemIndex(), inboundMessage.getMemLocation());
            }
            if (inboundMessage.getMemIndex() == -1 && inboundMessage.getMpMemIndex().length() != 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(inboundMessage.getMpMemIndex(), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    this._$1(Integer.parseInt(stringTokenizer.nextToken()), inboundMessage.getMemLocation());
                }
            }
            return true;
        }
    }

    @Override
    public int readPhonebook(Phonebook phonebook) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int n = 0;
        String string = this.getATHandler().readPhonebookLocations();
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().replaceAll("\"", "");
                String string3 = this.getATHandler().readPhonebook(string2);
                if (string3 == null || string3.trim().length() == 0) continue;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
                String string4 = bufferedReader.readLine().trim();
                while (!string4.equalsIgnoreCase("OK")) {
                    string4 = string4.replaceAll("\\s*\\+CPBR:\\s*", "");
                    string4 = string4.replaceAll("\"\"", "\" \"");
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4 = string4.replaceAll("\"", ""), ",");
                    String string5 = stringTokenizer2.nextToken();
                    string5 = string5 == null ? "" : string5.trim();
                    String string6 = stringTokenizer2.nextToken();
                    string6 = string6 == null ? "" : string6.trim();
                    String string7 = stringTokenizer2.nextToken();
                    string7 = string7 == null ? "" : string7.trim();
                    String string8 = stringTokenizer2.nextToken();
                    string8 = string8 == null ? "" : string8.trim();
                    phonebook.getContacts().add(new Contact(string8, string6, string2, Integer.parseInt(string5)));
                    ++n;
                    string4 = bufferedReader.readLine().trim();
                }
                bufferedReader.close();
            }
        }
        return n;
    }

    private boolean _$1(int n, String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.getATHandler().deleteMessage(n, string);
    }

    private boolean _$2(OutboundMessage outboundMessage) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logDebug("in sendMessageTEXT", null, this.getGatewayId());
        boolean bl = false;
        int n = this.getATHandler().sendMessage(0, "", outboundMessage.getRecipient(), outboundMessage.getText());
        int n2 = this.getATHandler().getTextSplitNum(outboundMessage.getText());
        outboundMessage.setSplitNum(n2);
        if (n >= 0) {
            outboundMessage.setGatewayId(this.getGatewayId());
            outboundMessage.setRefNo("" + n);
            outboundMessage.setDispatchDate(new Date());
            outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            this.incOutboundMessageCount();
            bl = true;
        } else {
            outboundMessage.setRefNo(null);
            outboundMessage.setDispatchDate(null);
            outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
            outboundMessage.setErrorMessage(this._$27.getLastErrorText());
        }
        return bl;
    }

    private void _$2(Collection<InboundMessage> collection, InboundMessage.MessageClasses messageClasses, int n) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int n2 = n < 0 ? 0 : n;
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        for (int i = 0; i < this.getATHandler().getStorageLocations().length() / 2; ++i) {
            InboundMessage inboundMessage;
            String string;
            String string2;
            StringTokenizer stringTokenizer;
            String string3;
            int n3;
            int n4;
            int n5;
            String string4;
            if (!this.getATHandler().switchStorageLocation(this.getATHandler().getStorageLocations().substring(i * 2, i * 2 + 2))) continue;
            String string5 = this.getATHandler().listMessages(messageClasses);
            if (string5.startsWith("OK") && string5.length() < 10) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string5));
            if (string5.startsWith("^HCMGR")) {
                while ((string4 = bufferedReader.readLine()) != null && (string4 = string4.trim()).length() <= 0) {
                }
                while (string4 != null && string4.length() > 0 && !string4.equalsIgnoreCase("OK")) {
                    n5 = string4.indexOf(58);
                    n4 = string4.indexOf(44);
                    n3 = 0;
                    if (string4.indexOf("#") + 1 >= string4.lastIndexOf("#")) break;
                    try {
                        n3 = Integer.parseInt(string4.substring(string4.indexOf("#") + 1, string4.lastIndexOf("#")).trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        Logger.getInstance().logWarn("Incorrect Memory Index number parsed!", numberFormatException, this.getGatewayId());
                    }
                    string3 = "";
                    stringTokenizer = new StringTokenizer(string4, ",");
                    stringTokenizer.nextToken();
                    string2 = string4.substring(string4.indexOf(":") + 1, string4.indexOf(",")).trim();
                    calendar.set(1, Integer.parseInt(stringTokenizer.nextToken().trim()));
                    calendar.set(2, Integer.parseInt(stringTokenizer.nextToken().trim()) - 1);
                    calendar.set(5, Integer.parseInt(stringTokenizer.nextToken().trim()));
                    calendar.set(11, Integer.parseInt(stringTokenizer.nextToken().trim()));
                    calendar.set(12, Integer.parseInt(stringTokenizer.nextToken().trim()));
                    calendar.set(13, Integer.parseInt(stringTokenizer.nextToken().trim()));
                    string = "";
                    while ((string3 = bufferedReader.readLine()) != null && !string3.startsWith("^HCMGR") && !string3.startsWith("^HCMGL")) {
                        string = string + (string.length() == 0 ? "" : "\n") + string3;
                    }
                    string4 = string3;
                    string = string.trim();
                    string = string.replaceAll(String.valueOf('\u001a'), "");
                    string = string.replaceAll("\nOK", "");
                    inboundMessage = new InboundMessage(calendar.getTime(), string2, string, n3, this.getATHandler().getStorageLocations().substring(i * 2, i * 2 + 2));
                    inboundMessage.setGatewayId(this.getGatewayId());
                    Logger.getInstance().logDebug("IN-DTLS: MI:" + inboundMessage.getMemIndex(), null, this.getGatewayId());
                    inboundMessage.setCdmaFlag(true);
                    collection.add(inboundMessage);
                    this.incInboundMessageCount();
                    do {
                        String string6 = string4 = string3 == null || string3.length() == 0 ? bufferedReader.readLine() : string3;
                    } while (string4 != null && (string4 = string4.trim()).length() <= 0);
                    if (n2 <= 0 || collection.size() != n2) continue;
                }
                bufferedReader.close();
                continue;
            }
            while ((string4 = bufferedReader.readLine()) != null && (string4 = string4.trim()).length() <= 0) {
            }
            while (string4 != null && string4.length() > 0) {
                String string7;
                n5 = string4.indexOf(58);
                n4 = string4.indexOf(44);
                n3 = 0;
                try {
                    n3 = Integer.parseInt(string4.substring(n5 + 1, n4).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    Logger.getInstance().logWarn("Incorrect Memory Index number parsed!", numberFormatException, this.getGatewayId());
                }
                stringTokenizer = new StringTokenizer(string4, ",");
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                string3 = "";
                if (Character.isDigit(stringTokenizer.nextToken().trim().charAt(0))) {
                    string4 = string4.replaceAll(",,", ", ,");
                    stringTokenizer = new StringTokenizer(string4, ",");
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    String string8 = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    string7 = stringTokenizer.nextToken().replaceAll("\"", "");
                    calendar.set(1, 2000 + Integer.parseInt(string7.substring(0, 2)));
                    calendar.set(2, Integer.parseInt(string7.substring(3, 5)) - 1);
                    calendar.set(5, Integer.parseInt(string7.substring(6, 8)));
                    string7 = stringTokenizer.nextToken().replaceAll("\"", "");
                    calendar.set(11, Integer.parseInt(string7.substring(0, 2)));
                    calendar.set(12, Integer.parseInt(string7.substring(3, 5)));
                    calendar.set(13, Integer.parseInt(string7.substring(6, 8)));
                    string7 = stringTokenizer.nextToken().replaceAll("\"", "");
                    calendar2.set(1, 2000 + Integer.parseInt(string7.substring(0, 2)));
                    calendar2.set(2, Integer.parseInt(string7.substring(3, 5)) - 1);
                    calendar2.set(5, Integer.parseInt(string7.substring(6, 8)));
                    string7 = stringTokenizer.nextToken().replaceAll("\"", "");
                    calendar2.set(11, Integer.parseInt(string7.substring(0, 2)));
                    calendar2.set(12, Integer.parseInt(string7.substring(3, 5)));
                    calendar2.set(13, Integer.parseInt(string7.substring(6, 8)));
                    inboundMessage = new StatusReportMessage(string8, n3, this.getATHandler().getStorageLocations().substring(i * 2, i * 2 + 2), calendar.getTime(), calendar2.getTime());
                    inboundMessage.setGatewayId(this.getGatewayId());
                    Logger.getInstance().logDebug("IN-DTLS: MI:" + inboundMessage.getMemIndex(), null, this.getGatewayId());
                    collection.add(inboundMessage);
                    this.incInboundMessageCount();
                } else {
                    string4 = string4.replaceAll(",,", ", ,");
                    stringTokenizer = new StringTokenizer(string4, ",");
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken().replaceAll("\"", "");
                    stringTokenizer.nextToken();
                    string7 = stringTokenizer.nextToken().replaceAll("\"", "");
                    calendar.set(1, 2000 + Integer.parseInt(string7.substring(0, 2)));
                    calendar.set(2, Integer.parseInt(string7.substring(3, 5)) - 1);
                    calendar.set(5, Integer.parseInt(string7.substring(6, 8)));
                    string7 = stringTokenizer.nextToken().replaceAll("\"", "");
                    calendar.set(11, Integer.parseInt(string7.substring(0, 2)));
                    calendar.set(12, Integer.parseInt(string7.substring(3, 5)));
                    calendar.set(13, Integer.parseInt(string7.substring(6, 8)));
                    string = "";
                    while ((string3 = bufferedReader.readLine()) != null && !string3.startsWith("+CMGL") && !string3.startsWith("+CMGR")) {
                        string = string + (string.length() == 0 ? "" : "\n") + string3;
                    }
                    string4 = string3;
                    string = string.trim();
                    string = string.replaceAll("(\n)+OK", "");
                    inboundMessage = new InboundMessage(calendar.getTime(), string2, string, n3, this.getATHandler().getStorageLocations().substring(i * 2, i * 2 + 2));
                    inboundMessage.setGatewayId(this.getGatewayId());
                    Logger.getInstance().logDebug("IN-DTLS: MI:" + inboundMessage.getMemIndex(), null, this.getGatewayId());
                    collection.add(inboundMessage);
                    this.incInboundMessageCount();
                }
                do {
                    String string9 = string4 = string3 == null || string3.length() == 0 ? bufferedReader.readLine() : string3;
                } while (string4 != null && (string4 = string4.trim()).length() <= 0);
                if (n2 <= 0 || collection.size() != n2) continue;
            }
            bufferedReader.close();
        }
    }

    private boolean _$1(OutboundMessage outboundMessage) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logDebug("in sendMessagePDU", null, this.getGatewayId());
        boolean bl = false;
        List<String> list = outboundMessage.getPdus(this.getSmscNumber(), this._$14);
        long l = 3600 / Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.send_speed", "600")) * 1000;
        outboundMessage.setSplitNum(list.size());
        Logger.getInstance().logInfo("\u53d1\u9001\u77ed\u4fe1\u6761\u6570" + list.size(), null, this.getGatewayId());
        for (int i = 0; i < list.size(); ++i) {
            int n;
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            String string = list.get(i);
            Pdu pdu = new PduParser().parsePdu(string);
            Logger.getInstance().logDebug(pdu.toString(), null, this.getGatewayId());
            int n2 = string.length() / 2;
            if (this.getSmscNumber() != null) {
                if (this.getSmscNumber().length() == 0) {
                    --n2;
                } else {
                    n = this.getSmscNumber().length();
                    if (this.getSmscNumber().charAt(0) == '+') {
                        --n;
                    }
                    if (n % 2 != 0) {
                        ++n;
                    }
                    int n3 = (2 + n) / 2;
                    n2 = n2 - n3 - 1;
                }
            }
            Logger.getInstance().logDebug("Sending Pdu: " + string, null, this.getGatewayId());
            Logger.getInstance().logInfo("\u53d1\u9001\u7b2c" + i + "\u6761\u77ed\u4fe1", null, this.getGatewayId());
            n = this.getATHandler().sendMessage(n2, string, null, null);
            if (n >= 0) {
                outboundMessage.setGatewayId(this.getGatewayId());
                outboundMessage.setRefNo(String.valueOf(n));
                outboundMessage.setDispatchDate(new Date());
                outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
                outboundMessage.setFailureCause(OutboundMessage.FailureCauses.NO_ERROR);
                this.incOutboundMessageCount();
                bl = true;
            } else {
                Logger.getInstance().logInfo("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25,\u8fd4\u56de" + n, null, this.getGatewayId());
                outboundMessage.setRefNo(null);
                outboundMessage.setDispatchDate(null);
                outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                outboundMessage.setFailureCause(OutboundMessage.FailureCauses.UNKNOWN);
                bl = false;
                outboundMessage.setErrorMessage(this._$27.getLastErrorText());
            }
            stopWatch.stop();
            if (l - stopWatch.getTime() > 0L && this.threadWait(l - stopWatch.getTime())) continue;
        }
        if (list.size() > 1) {
            this._$14 = (this._$14 + 1) % 65536;
        }
        return bl;
    }

    private void _$1(Collection<InboundMessage> collection, InboundMessage.MessageClasses messageClasses, int n) throws Exception {
        Object object;
        Object object2;
        Object object3;
        int n2;
        boolean bl = false;
        SerialModemBean serialModemBean = DeviceInfoCache.getInstance().get(this.getGatewayId());
        String string = serialModemBean.getCcid();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DbHelper dbHelper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
        PduParser pduParser = new PduParser();
        int n3 = n < 0 ? 0 : n;
        for (int i = 0; i < this.getATHandler().getStorageLocations().length() / 2; ++i) {
            String string2;
            if (!this.getATHandler().switchStorageLocation(this.getATHandler().getStorageLocations().substring(i * 2, i * 2 + 2))) continue;
            String string3 = this.getATHandler().listMessages(messageClasses);
            string3 = string3.replaceAll("\\s+OK\\s+", "\nOK");
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
            while ((string2 = bufferedReader.readLine()) != null && (string2 = string2.trim()).length() <= 0) {
            }
            while (this.threadWait(1L) && string2 != null && (string2 = string2.trim()).length() > 0 && !string2.equalsIgnoreCase("OK") && string2.length() > 0 && !string2.equalsIgnoreCase("ERROR")) {
                if (string2.indexOf("+CMTI") != -1) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.indexOf("^RRCSTAT") != -1) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.indexOf("^SMMEMFULL:") != -1) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.indexOf("^LENDC:") != -1) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.indexOf("+CGREG:") != -1) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.indexOf("+C5GREG:") != -1) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.indexOf("^LWURC:") != -1) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.matches("\\s*OK\\s*")) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.indexOf("+CPMS") != -1) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                int n4 = string2.indexOf(58);
                int n5 = string2.indexOf(44);
                if (n4 == -1 || n5 == -1) break;
                int n6 = 0;
                try {
                    n6 = Integer.parseInt(string2.substring(n4 + 1, n5).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    Logger.getInstance().logWarn("Incorrect Memory Index number parsed!", numberFormatException, this.getGatewayId());
                }
                String string4 = bufferedReader.readLine().trim();
                for (n2 = 0; string4.indexOf("+CMTI") != -1 && n2 < 3 && this.threadWait(1L); ++n2) {
                    string4 = bufferedReader.readLine().trim();
                }
                if (n2 >= 3) break;
                try {
                    object3 = this.getATHandler().getStorageLocations().substring(i * 2, i * 2 + 2);
                    dbHelper.addTmpMsg(string4, n6, (String)object3, i, string);
                    object2 = new TmpMsg();
                    ((TmpMsg)object2).setPdustring(string4);
                    ((TmpMsg)object2).setMemindex(n6);
                    ((TmpMsg)object2).setMemlocation((String)object3);
                    ((TmpMsg)object2).setMl(i);
                    ((TmpMsg)object2).setCCID(string);
                    arrayList.add(object2);
                    Logger.getInstance().logDebug("READ PDU: " + string4, null, this.getGatewayId());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                while (this.threadWait(1L) && (string2 = bufferedReader.readLine()) != null && (string2 = string2.trim()).length() <= 0) {
                }
                if (n3 <= 0 || collection.size() != n3) continue;
                break;
            }
            bufferedReader.close();
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object3 = (TmpMsg)arrayList.get(n2);
            try {
                object2 = pduParser.parsePdu(((TmpMsg)object3).getPdustring());
                Logger.getInstance().logDebug("raw pdu:" + ((TmpMsg)object3).getPdustring(), null, this.getGatewayId());
                Logger.getInstance().logDebug("pdu decode text:" + ((Pdu)object2).getDecodedText(), null, this.getGatewayId());
                if (object2 instanceof SmsDeliveryPdu) {
                    if (((Pdu)object2).isBinary()) {
                        object = new InboundBinaryMessage((SmsDeliveryPdu)object2, ((TmpMsg)object3).getMemindex(), ((TmpMsg)object3).getMemlocation(), ((TmpMsg)object3).getCCID());
                        if (Service.getInstance().getKeyManager().getKey(((InboundMessage)object).getOriginator()) != null) {
                            object = new InboundEncryptedMessage((SmsDeliveryPdu)object2, ((TmpMsg)object3).getMemindex(), ((TmpMsg)object3).getMemlocation(), ((TmpMsg)object3).getCCID());
                        }
                    } else {
                        object = new InboundMessage((SmsDeliveryPdu)object2, ((TmpMsg)object3).getMemindex(), ((TmpMsg)object3).getMemlocation(), ((TmpMsg)object3).getCCID());
                    }
                    ((Message)object).setGatewayId(this.getGatewayId());
                    ((InboundMessage)object).setTmpDeleteFlag(true);
                    if (this._$3()) {
                        ((InboundMessage)object).setFlag4G(true);
                    }
                    arrayList2.add(object);
                    continue;
                }
                if (!(object2 instanceof SmsStatusReportPdu)) continue;
                object = new StatusReportMessage((SmsStatusReportPdu)object2, ((TmpMsg)object3).getMemindex(), this.getATHandler().getStorageLocations().substring(((TmpMsg)object3).getMl() * 2, ((TmpMsg)object3).getMl() * 2 + 2));
                ((InboundMessage)object).setTmpDeleteFlag(true);
                if (this._$3()) {
                    ((InboundMessage)object).setFlag4G(true);
                }
                arrayList2.add(object);
                continue;
            }
            catch (Exception exception) {
                object = new UnknownMessage(((TmpMsg)object3).getPdustring(), ((TmpMsg)object3).getMemindex(), this.getATHandler().getStorageLocations().substring(((TmpMsg)object3).getMl() * 2, ((TmpMsg)object3).getMl() * 2 + 2));
                ((Message)object).setGatewayId(this.getGatewayId());
                ((InboundMessage)object).setTmpDeleteFlag(true);
                if (this._$3()) {
                    ((InboundMessage)object).setFlag4G(true);
                }
                arrayList2.add(object);
            }
        }
        List<TmpMsg> list = dbHelper.getTmpMsg(true, string);
        this._$13 = new ArrayList<List<InboundMessage>>();
        int n7 = 1;
        for (int i = 0; i < list.size(); ++i) {
            UnknownMessage unknownMessage;
            object = list.get(i);
            Pdu pdu = null;
            try {
                InboundMessage inboundMessage;
                try {
                    pdu = pduParser.parsePdu(((TmpMsg)object).getPdustring());
                }
                catch (Exception exception) {
                    unknownMessage = new UnknownMessage(((TmpMsg)object).getPdustring(), ((TmpMsg)object).getMemindex(), this.getATHandler().getStorageLocations().substring(((TmpMsg)object).getMl() * 2, ((TmpMsg)object).getMl() * 2 + 2));
                    unknownMessage.setGatewayId(this.getGatewayId());
                    unknownMessage.setTmpFlag(false);
                    unknownMessage.setTmpMsgId(((TmpMsg)object).getId());
                    unknownMessage.setTmpDeleteFlag(false);
                    collection.add(unknownMessage);
                    dbHelper.deleteTmpMsg(unknownMessage.getTmpMsgId());
                    this.incInboundMessageCount();
                    Logger.getInstance().logError("Unhandled SMS in inbox, skipping...", exception, this.getGatewayId());
                    Logger.getInstance().logError("ERROR PDU: " + ((TmpMsg)object).getPdustring(), null, this.getGatewayId());
                    continue;
                }
                if (pdu instanceof SmsDeliveryPdu) {
                    if (pdu.isBinary()) {
                        inboundMessage = new InboundBinaryMessage((SmsDeliveryPdu)pdu, ((TmpMsg)object).getMemindex(), ((TmpMsg)object).getMemlocation(), ((TmpMsg)object).getCCID());
                        if (Service.getInstance().getKeyManager().getKey(inboundMessage.getOriginator()) != null) {
                            inboundMessage = new InboundEncryptedMessage((SmsDeliveryPdu)pdu, ((TmpMsg)object).getMemindex(), ((TmpMsg)object).getMemlocation(), ((TmpMsg)object).getCCID());
                        }
                    } else {
                        inboundMessage = new InboundMessage((SmsDeliveryPdu)pdu, ((TmpMsg)object).getMemindex(), ((TmpMsg)object).getMemlocation(), ((TmpMsg)object).getCCID());
                    }
                    if (!(inboundMessage instanceof InboundBinaryMessage)) {
                        Logger.getInstance().logDebug("index:" + n7, null, this.getGatewayId());
                        Logger.getInstance().logDebug("PDU:" + ((TmpMsg)object).getPdustring(), null, this.getGatewayId());
                        Logger.getInstance().logDebug("\u6765\u6e90\u53f7\u7801:" + inboundMessage.getOriginator(), null, this.getGatewayId());
                        Logger.getInstance().logDebug("\u5185\u5bb9:" + inboundMessage.getText(), null, this.getGatewayId());
                        Logger.getInstance().logDebug("refno:" + inboundMessage.getMpRefNo(), null, this.getGatewayId());
                        Logger.getInstance().logDebug("MaxMp:" + inboundMessage.getMpMaxNo(), null, this.getGatewayId());
                        Logger.getInstance().logDebug("seqno:" + inboundMessage.getMpSeqNo(), null, this.getGatewayId());
                    }
                    ++n7;
                    inboundMessage.setGatewayId(this.getGatewayId());
                    inboundMessage.setTmpFlag(true);
                    inboundMessage.setTmpMsgId(((TmpMsg)object).getId());
                    inboundMessage.setTmpDeleteFlag(false);
                    if (inboundMessage.getMpRefNo() == 0 && inboundMessage.getMpMaxNo() <= 1) {
                        inboundMessage.setTmpFlag(false);
                        collection.add(inboundMessage);
                        dbHelper.deleteTmpMsg(inboundMessage.getTmpMsgId());
                        this.incInboundMessageCount();
                        continue;
                    }
                    List<InboundMessage> list2 = null;
                    boolean bl2 = false;
                    for (int j = 0; j < this._$13.size(); ++j) {
                        list2 = this._$13.get(j);
                        InboundMessage inboundMessage2 = list2.get(0);
                        int n8 = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.recvdiff", "5"));
                        boolean bl3 = false;
                        if ((long)(n8 * 3600) * 1000L > Math.abs(inboundMessage2.getDate().getTime() - inboundMessage.getDate().getTime())) {
                            bl3 = true;
                        }
                        if (!bl3 || inboundMessage2.getMpRefNo() != inboundMessage.getMpRefNo() || inboundMessage2.getMpMaxNo() != inboundMessage.getMpMaxNo() || !inboundMessage.getOriginator().equals(inboundMessage2.getOriginator()) || !inboundMessage.getCCID().equals(inboundMessage2.getCCID())) continue;
                        boolean bl4 = false;
                        for (int k = 0; k < list2.size(); ++k) {
                            inboundMessage2 = list2.get(k);
                            if (inboundMessage2.getMpSeqNo() != inboundMessage.getMpSeqNo()) continue;
                            bl4 = true;
                            break;
                        }
                        if (!bl4) {
                            list2.add(inboundMessage);
                        }
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    list2 = new ArrayList<InboundMessage>();
                    list2.add(inboundMessage);
                    this._$13.add(list2);
                    continue;
                }
                if (pdu instanceof SmsStatusReportPdu) {
                    inboundMessage = new StatusReportMessage((SmsStatusReportPdu)pdu, ((TmpMsg)object).getMemindex(), this.getATHandler().getStorageLocations().substring(((TmpMsg)object).getMl() * 2, ((TmpMsg)object).getMl() * 2 + 2));
                    inboundMessage.setGatewayId(this.getGatewayId());
                    inboundMessage.setTmpFlag(false);
                    inboundMessage.setTmpMsgId(((TmpMsg)object).getId());
                    inboundMessage.setTmpDeleteFlag(false);
                    collection.add(inboundMessage);
                    dbHelper.deleteTmpMsg(inboundMessage.getTmpMsgId());
                    this.incInboundMessageCount();
                    continue;
                }
                if (!this._$11) continue;
                Logger.getInstance().logError("Wrong type of PDU detected: " + pdu.getClass().getName(), null, this.getGatewayId());
                Logger.getInstance().logError("ERROR PDU: " + ((TmpMsg)object).getPdustring(), null, this.getGatewayId());
                continue;
            }
            catch (Exception exception) {
                unknownMessage = new UnknownMessage(((TmpMsg)object).getPdustring(), ((TmpMsg)object).getMemindex(), this.getATHandler().getStorageLocations().substring(((TmpMsg)object).getMl() * 2, ((TmpMsg)object).getMl() * 2 + 2));
                unknownMessage.setGatewayId(this.getGatewayId());
                unknownMessage.setTmpFlag(false);
                unknownMessage.setTmpMsgId(((TmpMsg)object).getId());
                unknownMessage.setTmpDeleteFlag(false);
                collection.add(unknownMessage);
                dbHelper.deleteTmpMsg(unknownMessage.getTmpMsgId());
                this.incInboundMessageCount();
                Logger.getInstance().logError("Unhandled SMS in inbox, skipping...", exception, this.getGatewayId());
                Logger.getInstance().logError("ERROR PDU: " + ((TmpMsg)object).getPdustring(), null, this.getGatewayId());
            }
        }
        this._$1(collection);
        collection.addAll(arrayList2);
    }

    public void setDisplayIllegalReceivedMessages(boolean bl) {
        this._$11 = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageByIndex(int n) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().getMessageByIndex(n);
        }
    }

    private void _$1(Collection<InboundMessage> collection) throws TimeoutException, GatewayException, IOException, InterruptedException {
        DbHelper dbHelper = null;
        try {
            dbHelper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        InboundMessage inboundMessage = null;
        Logger.getInstance().logDebug("CheckMpMsgList(): MAINLIST: " + this._$13.size(), null, this.getGatewayId());
        for (int i = 0; i < this._$13.size(); ++i) {
            List<InboundMessage> list = this._$13.get(i);
            Logger.getInstance().logDebug("CheckMpMsgList(): SUBLIST[" + i + "]: " + list.size(), null, this.getGatewayId());
            InboundMessage inboundMessage2 = list.get(0);
            boolean bl = false;
            if (inboundMessage2.getMpMaxNo() == list.size()) {
                bl = true;
                block9: for (int j = 0; j < list.size(); ++j) {
                    for (int k = 0; k < list.size(); ++k) {
                        Object object;
                        inboundMessage2 = list.get(k);
                        if (inboundMessage2.getMpSeqNo() != j + 1) continue;
                        if (inboundMessage2.getMpSeqNo() == 1) {
                            inboundMessage = inboundMessage2;
                            inboundMessage.setMpMemIndex(inboundMessage.getMemIndex());
                            if (inboundMessage2.getMpMaxNo() != 1) continue block9;
                            collection.add(inboundMessage);
                            try {
                                for (int i2 = 0; i2 < list.size(); ++i2) {
                                    dbHelper.deleteTmpMsg(list.get(i2).getTmpMsgId());
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            this.incInboundMessageCount();
                            continue block9;
                        }
                        if (inboundMessage == null) continue block9;
                        if (inboundMessage instanceof InboundBinaryMessage) {
                            object = (InboundBinaryMessage)inboundMessage;
                            InboundBinaryMessage inboundBinaryMessage = (InboundBinaryMessage)inboundMessage2;
                            ((InboundBinaryMessage)object).addDataBytes(inboundBinaryMessage.getDataBytes());
                        } else {
                            object = inboundMessage2.getText();
                            if (inboundMessage.getEndsWithMultiChar()) {
                                Logger.getInstance().logDebug("Adjusting dangling multi-char: " + ((String)object).charAt(0) + " --> " + PduUtils.getMultiCharFor(((String)object).charAt(0)), null, this.getGatewayId());
                                object = PduUtils.getMultiCharFor(((String)object).charAt(0)) + ((String)object).substring(1);
                            }
                            inboundMessage.setEndsWithMultiChar(inboundMessage2.getEndsWithMultiChar());
                            try {
                                inboundMessage.addText((String)object);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                        inboundMessage.setMpSeqNo(inboundMessage2.getMpSeqNo());
                        inboundMessage.setMpMemIndex(inboundMessage2.getMemIndex());
                        if (inboundMessage2.getMpSeqNo() != inboundMessage2.getMpMaxNo()) continue block9;
                        inboundMessage.setMemIndex(-1);
                        collection.add(inboundMessage);
                        try {
                            for (int i3 = 0; i3 < list.size(); ++i3) {
                                dbHelper.deleteTmpMsg(list.get(i3).getTmpMsgId());
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        this.incInboundMessageCount();
                        inboundMessage = null;
                        continue block9;
                    }
                }
                list.clear();
                list = null;
            }
            if (!bl) continue;
            this._$13.remove(i);
            --i;
        }
    }

    private long _$2() {
        return this._$21;
    }

    private void _$1(long l) {
        this._$21 = l;
    }

    public void setSimPin(String string) {
        this._$18 = string;
    }

    public void setSimPin2(String string) {
        this._$17 = string;
    }

    public String getSimPin() {
        return this._$18;
    }

    public String getSimPin2() {
        return this._$17;
    }

    public AModemDriver getModemDriver() {
        return this._$27;
    }

    public AATHandler getATHandler() {
        return this._$26;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManufacturer() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String string = this.getATHandler().getManufacturer();
            if (string.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            string = string.replaceAll("\\s+OK\\s+", "");
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String string = this.getATHandler().getModel();
            if (string.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            string = string.replaceAll("\\s+OK\\s+", "");
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String string = this.getATHandler().getSerialNo();
            if (string.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            string = string.replaceAll("\\s+OK\\s+", "");
            string = string.replaceAll("\\+CGSN:", "");
            return string.trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImsi() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (Service.getInstance().getSettings().MASK_IMSI) {
            return "** MASKED **";
        }
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String string = this.getATHandler().getImsi();
            if (string.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            string = string.replaceAll("\\s+OK\\s+", "");
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSwVersion() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String string = this.getATHandler().getSwVersion();
            if (string.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            string = string.replaceAll("\\s+OK\\s+", "");
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _$1() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().getGprsStatus().matches("\\+CGATT[\\p{ASCII}]*1\\sOK\\s");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBatteryLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String string = this.getATHandler().getBatteryLevel();
            if (string.indexOf("ERROR") >= 0) {
                return 0;
            }
            Matcher matcher = Pattern.compile("\\+CBC: (\\d+),\\s*(\\d+)").matcher(string);
            if (matcher.find()) {
                return Integer.parseInt(matcher.group(2));
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSignalLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String string = this.getATHandler().getSignalLevel();
            if (string.indexOf("ERROR") >= 0) {
                return 0;
            }
            string = string.replaceAll("\\s+OK\\s+", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":,");
            stringTokenizer.nextToken();
            Integer n = Integer.parseInt(stringTokenizer.nextToken().trim());
            if (n == 99) {
                return 99;
            }
            return -113 + 2 * n;
        }
    }

    public String getSmscNumber() {
        return this._$15;
    }

    public void setSmscNumber(String string) {
        this._$15 = string;
    }

    public String getCustomInitString() {
        return this._$16;
    }

    public void setCustomInitString(String string) {
        this._$16 = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendCustomATCommand(String string) throws GatewayException, TimeoutException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().sendCustomATCommand(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendUSSDCommand(String string) throws GatewayException, TimeoutException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().sendUSSDCommand(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendUSSDCommand(String string, boolean bl) throws GatewayException, TimeoutException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().sendUSSDCommand(string, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendUSSDRequest(USSDRequest uSSDRequest) throws GatewayException, TimeoutException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().sendUSSDRequest(Integer.toString(uSSDRequest.getResultPresentation().getNumeric()), uSSDRequest.getContent(), Integer.toString(uSSDRequest.getDcs().getNumeric()));
        }
    }

    public AModemDriver getDriver() {
        return this._$27;
    }

    protected void setDriver(AModemDriver aModemDriver) {
        this._$27 = aModemDriver;
    }

    public AATHandler getAtHandler() {
        return this._$26;
    }

    protected void setAtHandler(AATHandler aATHandler) {
        this._$26 = aATHandler;
    }

    protected String getModemDevice() {
        return this._$25;
    }

    protected void setModemDevice(String string) {
        this._$25 = string;
    }

    protected int getModemParms() {
        return this._$24;
    }

    protected void setModemParms(int n) {
        this._$24 = n;
    }

    protected int getAgeInHours(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        long l = calendar.getTimeInMillis();
        calendar.setTime(date);
        long l2 = calendar.getTimeInMillis();
        return (int)((l - l2) / 3600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNumber() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String string = this.getATHandler().getSerialNumber();
            if (string.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            string = string.replaceAll("\\s+OK\\s+", "");
            String[] stringArray = string.split(" ");
            return stringArray[stringArray.length - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNumber1() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String string = this.getATHandler().getSerialNo();
            if (string.indexOf("ERROR") >= 0) {
                return null;
            }
            string = string.replaceAll("\\s+OK\\s+", "");
            String[] stringArray = string.split(" ");
            return stringArray[stringArray.length - 1];
        }
    }

    @Override
    public int getQueueSchedulingInterval() {
        return 5000;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IPProtocols {
        TEXT,
        BINARY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModemTypes {
        SERIAL,
        IP;

    }
}

