/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduParser;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler;
import cn.sendsms.util.Logger;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ATHandler_Huawei_ME909
extends ATHandler {
    public ATHandler_Huawei_ME909(ModemGateway modemGateway) {
        super(modemGateway);
        this.setStorageLocations("SM");
    }

    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT^CURC=0\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CLIP=1\r");
        this.getModemDriver().getResponse();
    }

    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().clearBuffer();
        this.getModemDriver().write("AT^CURC=0\r");
        this.getModemDriver().getResponse();
    }

    public int findMatchingTerminator(String string) {
        if (string.indexOf("OK") != -1) {
            return 0;
        }
        for (int i = 0; i < this.terminators.length; ++i) {
            if (!string.matches(this.terminators[i])) continue;
            return i;
        }
        return -1;
    }

    public String getCCID() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT^ICCID?\r");
        String string = this.getModemDriver().getResponse();
        return string;
    }

    public String readTextMode() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.threadWait(2000L);
        this.getModemDriver().write("AT+CREG?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return this.getModemDriver().getResponse();
    }

    public String listMessages(InboundMessage.MessageClasses messageClasses) throws TimeoutException, GatewayException, IOException, InterruptedException {
        StringBuilder stringBuilder = new StringBuilder();
        this.getModemDriver().write("AT+CMGD=?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        String string = this.getModemDriver().getResponse();
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        String string2 = "";
        if (n + 1 < n2) {
            String[] stringArray = string.substring(n + 1, n2).split(",");
            PduParser pduParser = new PduParser();
            long l = System.currentTimeMillis();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                try {
                    int n3;
                    this.getModemDriver().write("AT+CMGR=" + string3 + "\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    string = this.getModemDriver().getResponse();
                    string = string.substring(string.indexOf("+CMGR"));
                    Matcher matcher = this.delLineSeparatorAfterCMGR.matcher(string);
                    if (matcher.find()) {
                        string = string.replace(matcher.group(), matcher.group(1) + "\r");
                    }
                    String string4 = string.trim();
                    Logger.getInstance().logInfo("\u6536\u5230\u77ed\u4fe1:" + string4, null, null);
                    int n4 = string4.indexOf("\n");
                    if (n4 == -1) {
                        n4 = string4.indexOf("\r");
                    }
                    if ((n3 = string4.lastIndexOf("\nOK")) == -1) {
                        n3 = string4.lastIndexOf("\rOK");
                    }
                    string2 = string4 = string4.substring(n4 + 1, n3);
                    Pdu pdu = pduParser.parsePdu(string4);
                    String string5 = "";
                    if (pdu instanceof SmsDeliveryPdu) {
                        string5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((SmsDeliveryPdu)pdu).getTimestamp());
                    }
                    stringBuilder.append(string.replace("CMGR:", "CMGL: " + string3 + ",").replaceFirst("\n*OK.*", ""));
                    this.getModemDriver().write("AT+CMGD=" + string3 + "\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    this.getModemDriver().getResponse();
                    if (this.getModemDriver().isOk()) continue;
                    throw new RuntimeException("\u5220\u9664\u77ed\u4fe1 " + string + " : \u4f4d\u7f6e" + string3 + "\u51fa\u9519");
                }
                catch (Exception exception) {
                    Logger.getInstance().logError("\u8bfb\u53d6" + string3 + "\u4f4d\u7f6e\u7684\u77ed\u4fe1" + string2 + "\u65f6\u51fa\u9519", exception, this.getGateway().getGatewayId());
                }
            }
            long l2 = System.currentTimeMillis();
            System.out.println("\u65f6\u95f4\u5386\u65f6" + (l2 - l));
        }
        stringBuilder.append("\nOK");
        return stringBuilder.toString();
    }

    public boolean deleteMessage(int n, String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return true;
    }

    public static void main(String[] stringArray) {
        Pattern pattern = Pattern.compile("(\\+CMGR:.*?)[\r|\n]+");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("^SRVST: 1\n+CREG: 2\n+CMGR: 0,\"\",26\n\n");
        stringBuilder.append("0891683108100005F04005A10180F600089120720171302388050003EF040367E56D4191CF300167E58BDD8D393001529E4E1A52A1FF0C8FD853EF53C252A0591A79CD4F1860E06D3B52A8FF0C514D8D396D4191CF98864E0D505C30024E0B8F7D57305740FF1A00680074007400700073003A002F002F006100700070002E00310030003000380036002E0063006E002F0044004C0031003000300073006D3002\n");
        stringBuilder.append("OK");
        String string = stringBuilder.toString();
        string = string.substring(string.indexOf("+CMGR"));
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string = string.replace(matcher.group(), matcher.group(1) + "\r");
        }
        System.out.println("indexstr=" + string);
        String string2 = string.trim();
        System.out.println(string2);
        int n = string2.indexOf("\n");
        int n2 = string2.lastIndexOf("\nOK");
        String string3 = string2 = string2.substring(n + 1, n2).replaceFirst("[\r|\n]+", "");
        System.out.println("pduString=" + string2);
        Logger.getInstance().logInfo("\u6536\u5230\u77ed\u4fe1:" + string2, null, null);
        PduParser pduParser = new PduParser();
        Pdu pdu = pduParser.parsePdu(string2);
        String string4 = "";
        if (pdu instanceof SmsDeliveryPdu) {
            string4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((SmsDeliveryPdu)pdu).getTimestamp());
        }
    }
}

