/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.sendsms.GatewayException;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler;
import java.io.IOException;

public class ATHandler_Wavecom
extends ATHandler {
    public ATHandler_Wavecom(ModemGateway modemGateway) {
        super(modemGateway);
        this.setStorageLocations("SM");
    }

    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.reset();
        if (!JDSMSServer.getInstance().getProperties().getString("settings.at.cfun", "0").equals("0")) {
            this.getModemDriver().write("AT+CFUN=1\r");
        }
        this.threadWait(Service.getInstance().getSettings().AT_WAIT_AFTER_RESET);
        this.getModemDriver().clearBuffer();
    }

    public void done() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        if (!JDSMSServer.getInstance().getProperties().getString("settings.at.cfun", "0").equals("0")) {
            this.getModemDriver().write("AT+CFUN=0\r");
        }
        this.threadWait(Service.getInstance().getSettings().AT_WAIT_AFTER_RESET);
    }

    public String readTextMode() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.threadWait(2000L);
        this.getModemDriver().write("AT+CMGF?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return this.getModemDriver().getResponse();
    }

    public boolean switchStorageLocation(String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (string.equalsIgnoreCase("--")) {
            return true;
        }
        this.getModemDriver().write("ATE0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CPMS=\"" + string + "\"\r");
        boolean bl = true;
        int n = 0;
        String string2 = this.getModemDriver().getResponse();
        boolean bl2 = this.getModemDriver().isOk();
        while (string2.indexOf("+CPMS") == -1) {
            if (n > 50) {
                Logger.getInstance().logError("AT+CPMS\u8d85\u8fc710S\u672a\u54cd\u5e94", null, this.getGateway().getGatewayId());
                Logger.getInstance().logError("AT+CPMS\u54cd\u5e94\u503c\uff1a" + string2, null, this.getGateway().getGatewayId());
                bl = false;
                break;
            }
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            string2 = string2 + this.getModemDriver().getResponse();
            ++n;
        }
        Logger.getInstance().logInfo(bl2 + "", null, this.getGateway().getGatewayId());
        Logger.getInstance().logInfo(bl + "", null, this.getGateway().getGatewayId());
        return bl2 && bl;
    }
}

