/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduParser;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler;
import cn.sendsms.util.Logger;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ATHandler_Yuga
extends ATHandler {
    public ATHandler_Yuga(ModemGateway modemGateway) {
        super(modemGateway);
        this.setStorageLocations("SM");
    }

    public String getStorageLocations() {
        return "SM";
    }

    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.reset();
        this.getModemDriver().clearBuffer();
    }

    public String sendCustomATCommand(String string) throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.getModemDriver().write(string);
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return this.getModemDriver().getResponse();
    }

    public void done() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT_AFTER_RESET);
    }

    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.init();
        this.threadWait(2000L);
        this.getModemDriver().write("ATE0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CPMS=\"SM\",\"MT\",\"SM\"\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT&W\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
    }

    public String readTextMode() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.threadWait(2000L);
        this.getModemDriver().write("AT+CMGF?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return this.getModemDriver().getResponse();
    }

    public int findMatchingTerminator(String string) {
        if (string.indexOf("OK") != -1) {
            return 0;
        }
        for (int i = 0; i < this.terminators.length; ++i) {
            if (!string.matches(this.terminators[i])) continue;
            return i;
        }
        return -1;
    }

    public String listMessages(InboundMessage.MessageClasses messageClasses) throws TimeoutException, GatewayException, IOException, InterruptedException {
        StringBuilder stringBuilder = new StringBuilder();
        this.getModemDriver().write("AT+CMGD=?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        String string = this.getModemDriver().getResponse();
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        String string2 = "";
        if (n + 1 < n2) {
            String[] stringArray = string.substring(n + 1, n2).split(",");
            PduParser pduParser = new PduParser();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                try {
                    int n3;
                    this.getModemDriver().write("ATE0\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    this.getModemDriver().getResponse();
                    this.getModemDriver().write("AT+CMGR=" + string3 + "\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    string = this.getModemDriver().getResponse();
                    string = string.substring(string.indexOf("+CMGR"));
                    Matcher matcher = this.delLineSeparatorAfterCMGR.matcher(string);
                    if (matcher.find()) {
                        string = string.replace(matcher.group(), matcher.group(1) + "\r");
                    }
                    String string4 = string.trim();
                    Logger.getInstance().logInfo("\u6536\u5230\u77ed\u4fe1:" + string4, null, null);
                    int n4 = string4.indexOf("\n");
                    if (n4 == -1) {
                        n4 = string4.indexOf("\r");
                    }
                    if ((n3 = string4.lastIndexOf("\nOK")) == -1) {
                        n3 = string4.lastIndexOf("\rOK");
                    }
                    string2 = string4 = string4.substring(n4 + 1, n3).replaceFirst("[\r|\n]+", "");
                    Pdu pdu = pduParser.parsePdu(string4);
                    String string5 = "";
                    if (pdu instanceof SmsDeliveryPdu) {
                        string5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((SmsDeliveryPdu)pdu).getTimestamp());
                    }
                    stringBuilder.append(string.replace("CMGR:", "CMGL: " + string3 + ",").replaceFirst("\n*OK.*", ""));
                    this.getModemDriver().write("AT+CMGD=" + string3 + "\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    this.getModemDriver().getResponse();
                    if (!this.getModemDriver().isOk()) {
                        throw new RuntimeException("\u5220\u9664\u77ed\u4fe1 " + string + " : \u4f4d\u7f6e" + string3 + "\u51fa\u9519");
                    }
                    continue;
                }
                catch (Exception exception) {
                    Logger.getInstance().logError("\u8bfb\u53d6" + string3 + "\u4f4d\u7f6e\u7684\u77ed\u4fe1" + string2 + "\u65f6\u51fa\u9519", exception, this.getGateway().getGatewayId());
                }
            }
        }
        stringBuilder.append("\nOK");
        return stringBuilder.toString();
    }

    public boolean deleteMessage(int n, String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return true;
    }

    public static void main(String[] stringArray) {
        Pattern pattern = Pattern.compile("(\\+CMGR:.*?)[\r|\n]{2,}");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n\n+CMGR: 0,\"\",26\n");
        stringBuilder.append("0891683108100005F04005A10180F600089120720171302388050003EF040367E56D4191CF300167E58BDD8D393001529E4E1A52A1FF0C8FD853EF53C252A0591A79CD4F1860E06D3B52A8FF0C514D8D396D4191CF98864E0D505C30024E0B8F7D57305740FF1A00680074007400700073003A002F002F006100700070002E00310030003000380036002E0063006E002F0044004C0031003000300073006D3002\n");
        stringBuilder.append("OK");
        String string = stringBuilder.toString();
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string = string.replace(matcher.group(), matcher.group(1) + "\r");
        }
        System.out.println("indexstr=" + string);
        String string2 = string.trim();
        System.out.println(string2);
        int n = string2.indexOf("\n");
        int n2 = string2.lastIndexOf("\nOK");
        String string3 = string2 = string2.substring(n + 1, n2).replaceFirst("[\r|\n]+", "");
        System.out.println("pduString=" + string2);
        Logger.getInstance().logInfo("\u6536\u5230\u77ed\u4fe1:" + string2, null, null);
        PduParser pduParser = new PduParser();
        Pdu pdu = pduParser.parsePdu(string2);
        String string4 = "";
        if (pdu instanceof SmsDeliveryPdu) {
            string4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((SmsDeliveryPdu)pdu).getTimestamp());
        }
    }

    public void modifyMMSRemindWay() throws IOException, InterruptedException {
        this.getModemDriver().write("AT+MMSMODE=1\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        String string = "";
        try {
            string = this.getModemDriver().getResponse();
        }
        catch (Exception exception) {
            Logger.getInstance().logError("\u5f69\u4fe1\u63a5\u6536\u6a21\u5f0f\u53d8\u66f4\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5c1d\u8bd5\u91cd\u65b0\u542f\u52a8!\u8bbe\u5907\u54cd\u5e94\uff1a" + string, exception, "");
        }
        if (string.contains("ERROR")) {
            Logger.getInstance().logInfo("\u5f69\u4fe1\u63a5\u6536\u6a21\u5f0f\u53d8\u66f4\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5c1d\u8bd5\u91cd\u65b0\u542f\u52a8!\u8bbe\u5907\u54cd\u5e94\uff1a" + string, null, null);
        }
    }
}

