/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.common;

import cn.sendsms.tools.IntStater;
import cn.sendsms.tools.TimeChecker;
import cn.sendsms.util.ComRecvBuffer;
import java.io.UnsupportedEncodingException;
import java.util.List;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComReadWriter {
    private String _$2;
    private ComRecvBuffer _$1 = new ComRecvBuffer();

    public String getIdInfo() {
        return this._$2;
    }

    public void setIdInfo(String string) {
        this._$2 = string;
    }

    public String getRecvLine() {
        return this._$1.popLineString();
    }

    public void clearRecv() {
        this._$1.reset();
    }

    public boolean send(SerialPort serialPort, String string) {
        if (!ComReadWriter.xIsPortOk(serialPort)) {
            return false;
        }
        this.recvNoWait(serialPort);
        Logger.getRootLogger().info((Object)(serialPort.getPortName() + "-SENDING(1):" + string));
        boolean bl = false;
        try {
            bl = serialPort.writeBytes(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (SerialPortException serialPortException) {
            serialPortException.printStackTrace();
        }
        return bl;
    }

    public String recvNoWait(SerialPort serialPort) {
        String string;
        if (!ComReadWriter.xIsPortOk(serialPort)) {
            return "";
        }
        byte[] byArray = null;
        try {
            byArray = serialPort.readBytes();
        }
        catch (SerialPortException serialPortException) {
            serialPortException.printStackTrace();
        }
        if (byArray == null || byArray.length < 1) {
            return "";
        }
        this._$1.append(byArray);
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            string = "";
        }
        return string;
    }

    public ComReadResult recv(SerialPort serialPort, long l) {
        return this.recv(serialPort, "OK", "ERROR", l);
    }

    public ComReadResult recv(SerialPort serialPort, String string, String string2, long l) {
        ComReadResult comReadResult = new ComReadResult();
        long l2 = l;
        if (l2 < 0L || l2 > 60000L) {
            l2 = 60000L;
        }
        String string3 = string;
        String string4 = string2;
        if (string3 == null || string3.length() < 1) {
            string3 = "OK";
        }
        if (string4 == null || string4.length() < 1) {
            string4 = "ERROR";
        }
        long l3 = TimeChecker.currentMilliSeconds();
        while (comReadResult.code == 0) {
            comReadResult.szValue = comReadResult.szValue + this.recvNoWait(serialPort);
            if (comReadResult.szValue.indexOf(string3) >= 0) {
                comReadResult.code = 1;
                break;
            }
            if (comReadResult.szValue.indexOf(string4) >= 0) {
                comReadResult.code = 2;
                break;
            }
            if (TimeChecker.checkTimeoutMillSeconds(l3, l2)) {
                comReadResult.code = 3;
                break;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return comReadResult;
    }

    public ComReadResult recv(SerialPort serialPort, List<String> list, List<String> list2, long l) {
        if (list.size() < 1 || list2.size() < 1) {
            return this.recv(serialPort, l);
        }
        ComReadResult comReadResult = new ComReadResult();
        long l2 = l;
        if (l2 < 0L || l2 > 60000L) {
            l2 = 60000L;
        }
        long l3 = TimeChecker.currentMilliSeconds();
        while (comReadResult.code == 0) {
            comReadResult.szValue = comReadResult.szValue + this.recvNoWait(serialPort);
            boolean bl = false;
            for (String string : list) {
                if (comReadResult.szValue.indexOf(string) < 0) continue;
                bl = true;
                comReadResult.code = 1;
                break;
            }
            if (bl) break;
            for (String string : list2) {
                if (comReadResult.szValue.indexOf(string) < 0) continue;
                bl = true;
                comReadResult.code = 2;
                break;
            }
            if (bl) break;
            if (TimeChecker.checkTimeoutMillSeconds(l3, l2)) {
                comReadResult.code = 3;
                break;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return comReadResult;
    }

    public ComReadResult recvWithStater(SerialPort serialPort, long l, IntStater intStater) {
        return this.recvWithStater(serialPort, "OK", "ERROR", l, intStater);
    }

    public ComReadResult recvWithStater(SerialPort serialPort, String string, String string2, long l, IntStater intStater) {
        ComReadResult comReadResult = new ComReadResult();
        long l2 = l;
        if (l2 < 0L || l2 > 60000L) {
            l2 = 60000L;
        }
        String string3 = string;
        String string4 = string2;
        if (string3 == null || string3.length() < 1) {
            string3 = "OK";
        }
        if (string4 == null || string4.length() < 1) {
            string4 = "ERROR";
        }
        long l3 = TimeChecker.currentMilliSeconds();
        while (comReadResult.code == 0) {
            comReadResult.szValue = comReadResult.szValue + this.recvNoWait(serialPort);
            if (comReadResult.szValue.indexOf(string3) >= 0) {
                comReadResult.code = 1;
                break;
            }
            if (comReadResult.szValue.indexOf(string4) >= 0) {
                comReadResult.code = 2;
                break;
            }
            if (TimeChecker.checkTimeoutMillSeconds(l3, l2)) {
                comReadResult.code = 3;
                break;
            }
            if (intStater != null && intStater.getVal() >= 99900) break;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return comReadResult;
    }

    public static boolean xIsPortOk(SerialPort serialPort) {
        if (serialPort == null) {
            return false;
        }
        return serialPort.isOpened();
    }

    public static void xClosePort(SerialPort serialPort) {
        if (!ComReadWriter.xIsPortOk(serialPort)) {
            return;
        }
        try {
            serialPort.closePort();
        }
        catch (SerialPortException serialPortException) {
            serialPortException.printStackTrace();
        }
    }

    public static boolean xSend(SerialPort serialPort, String string) {
        if (!ComReadWriter.xIsPortOk(serialPort)) {
            return false;
        }
        ComReadWriter.xRecvNoWait(serialPort);
        Logger.getRootLogger().info((Object)(serialPort.getPortName() + "-SENDING(0):" + string));
        boolean bl = false;
        try {
            bl = serialPort.writeBytes(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (SerialPortException serialPortException) {
            serialPortException.printStackTrace();
        }
        return bl;
    }

    public static String xRecvNoWait(SerialPort serialPort) {
        String string;
        if (!ComReadWriter.xIsPortOk(serialPort)) {
            return "";
        }
        byte[] byArray = null;
        try {
            byArray = serialPort.readBytes();
        }
        catch (SerialPortException serialPortException) {
            serialPortException.printStackTrace();
        }
        if (byArray == null || byArray.length < 1) {
            return "";
        }
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            string = "";
        }
        return string;
    }

    public static ComReadResult xRecv(SerialPort serialPort, long l) {
        return ComReadWriter.xRecv(serialPort, "OK", "ERROR", l);
    }

    public static ComReadResult xRecv(SerialPort serialPort, String string, String string2, long l) {
        ComReadResult comReadResult = new ComReadResult();
        if (serialPort == null) {
            return comReadResult;
        }
        if (!ComReadWriter.xIsPortOk(serialPort)) {
            return comReadResult;
        }
        long l2 = l;
        if (l2 < 0L || l2 > 60000L) {
            l2 = 60000L;
        }
        String string3 = string;
        String string4 = string2;
        if (string3 == null || string3.length() < 1) {
            string3 = "OK";
        }
        if (string4 == null || string4.length() < 1) {
            string4 = "ERROR";
        }
        long l3 = TimeChecker.currentMilliSeconds();
        while (comReadResult.code == 0) {
            comReadResult.szValue = comReadResult.szValue + ComReadWriter.xRecvNoWait(serialPort);
            if (comReadResult.szValue.indexOf(string3) >= 0) {
                comReadResult.code = 1;
                break;
            }
            if (comReadResult.szValue.indexOf(string4) >= 0) {
                comReadResult.code = 2;
                break;
            }
            if (TimeChecker.checkTimeoutMillSeconds(l3, l2)) {
                comReadResult.code = 3;
                break;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return comReadResult;
    }

    public static ComReadResult xRecvWithStater(SerialPort serialPort, long l, IntStater intStater) {
        return ComReadWriter.xRecvWithStater(serialPort, "OK", "ERROR", l, intStater);
    }

    public static ComReadResult xRecvWithStater(SerialPort serialPort, String string, String string2, long l, IntStater intStater) {
        ComReadResult comReadResult = new ComReadResult();
        long l2 = l;
        if (l2 < 0L || l2 > 60000L) {
            l2 = 60000L;
        }
        String string3 = string;
        String string4 = string2;
        if (string3 == null || string3.length() < 1) {
            string3 = "OK";
        }
        if (string4 == null || string4.length() < 1) {
            string4 = "ERROR";
        }
        long l3 = TimeChecker.currentMilliSeconds();
        while (comReadResult.code == 0) {
            comReadResult.szValue = comReadResult.szValue + ComReadWriter.xRecvNoWait(serialPort);
            if (comReadResult.szValue.indexOf(string3) >= 0) {
                comReadResult.code = 1;
                break;
            }
            if (comReadResult.szValue.indexOf(string4) >= 0) {
                comReadResult.code = 2;
                break;
            }
            if (TimeChecker.checkTimeoutMillSeconds(l3, l2)) {
                comReadResult.code = 3;
                break;
            }
            if (intStater != null && intStater.getVal() >= 99900) break;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return comReadResult;
    }

    public static class ComReadResult {
        public int code = 0;
        public String szValue = "";
    }
}

