/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.common;

import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.DbHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Random;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final Logger log = Logger.getRootLogger();

    public static String getString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)Utils.byteArrayToStr(byArray), (Throwable)unsupportedEncodingException);
            return "";
        }
    }

    public static byte[] getByteArray(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static byte[] getByteArray(String string, String string2) {
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String getString(byte[] byArray, String string) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)Utils.byteArrayToStr(byArray), (Throwable)unsupportedEncodingException);
            return "";
        }
    }

    public static String byteArrayToStr(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i] + " ");
        }
        return stringBuffer.toString();
    }

    public static byte[] mergeByteArray(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return null;
        }
        if (byArray == null && byArray2 != null) {
            return byArray2;
        }
        if (byArray != null && byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    public static String complementStrWithZero(String string, int n) {
        if (string == null) {
            return "";
        }
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(n2 - n);
        }
        if (n2 == n) {
            return string;
        }
        for (int i = 0; i < n - n2; ++i) {
            string = "0" + string;
        }
        return string;
    }

    public static String complementStrWithSpace(String string, int n) {
        if (string == null) {
            return "";
        }
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(n2 - n);
        }
        if (n2 == n) {
            return string;
        }
        for (int i = 0; i < n - n2; ++i) {
            string = " " + string;
        }
        return string;
    }

    public static String deleteSuffix(String string, String string2) {
        if (string == null || string.equals("") || !string.endsWith(string2)) {
            return string;
        }
        return string.substring(0, string.length() - string2.length());
    }

    public static String deletePrefix(String string, String string2) {
        if (string == null || string.equals("") || !string.startsWith(string2)) {
            return string;
        }
        return string.substring(string2.length());
    }

    public static boolean isEmptyStr(String string) {
        return string == null || "".equals(string);
    }

    public static int getRandom(int n, int n2) {
        if (n2 <= n) {
            return 0;
        }
        return new Random().nextInt(n2 - n) + n;
    }

    public static String byteArr2HexStr(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = byArray[i]; n2 < 0; n2 += 256) {
            }
            if (n2 < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toString(n2, 16));
        }
        return stringBuffer.toString();
    }

    public static byte[] hexStr2ByteArr(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        byte[] byArray2 = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            String string2 = new String(byArray, i, 2);
            byArray2[i / 2] = (byte)Integer.parseInt(string2, 16);
        }
        return byArray2;
    }

    public static ArrayList<String> getEmptyList(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add("");
        }
        return arrayList;
    }

    public static String getXORCheckStr(byte[] byArray) {
        String string = "";
        byte by = byArray[0];
        for (int i = 1; i < byArray.length; ++i) {
            by = (byte)(by ^ byArray[i]);
        }
        String string2 = Integer.toHexString((by & 0xF0) >> 4);
        String string3 = Integer.toHexString(by & 0xF);
        string = string2 + string3;
        return string.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConnectionOK(String string, int n) {
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(string, n), 100);
            boolean bl = socket.isConnected();
            return bl;
        }
        catch (Exception exception) {
            log.error((Object)("\u65e0\u6cd5\u8fde\u63a5\u5230\u3010" + string + ":" + n + "\u3011\uff01"), (Throwable)exception);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                log.error((Object)("\u3010" + string + ":" + n + "\u3011\u65ad\u5f00\u8fde\u63a5\u5f02\u5e38\uff01"), (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean closePort(SerialPort serialPort) {
        if (serialPort == null) {
            return true;
        }
        String string = serialPort.getPortName();
        if (string.matches("Vitual-[0-9]+-COM")) {
            return true;
        }
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            try {
                if (!serialPort.isOpened()) {
                    return true;
                }
                serialPort.closePort();
                return true;
            }
            catch (SerialPortException serialPortException) {
                if (!serialPort.isOpened()) {
                    log.info((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u5173\u95ed\u6210\u529f"));
                    return true;
                }
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u5173\u95ed\u5931\u8d25"));
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean openPort(int n, SerialPort serialPort) {
        if (serialPort == null) {
            return false;
        }
        String string = serialPort.getPortName();
        if (string.matches("Vitual-[0-9]+-COM")) {
            return true;
        }
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (serialPort.isOpened()) {
                log.info((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u5df2\u7ecf\u6253\u5f00\u4e86\u3002\u3002\u3002"));
                return true;
            }
            try {
                serialPort.openPort();
                serialPort.setFlowControlMode(0);
                serialPort.setParams(n, 8, 1, 0);
                return true;
            }
            catch (SerialPortException serialPortException) {
                log.error((Object)"\u7aef\u53e3\u6253\u5f00\u5931\u8d25\u3002\u3002\u3002", (Throwable)serialPortException);
                try {
                    if (serialPort.isOpened()) {
                        serialPort.closePort();
                    }
                }
                catch (SerialPortException serialPortException2) {
                    log.error((Object)"\u7aef\u53e3\u5173\u95ed\u5f02\u5e38...", (Throwable)serialPortException2);
                }
                return false;
            }
        }
    }

    public static void deleteTmpmsg(String string, String string2) {
        DbHelper dbHelper = null;
        try {
            dbHelper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
        }
        catch (Exception exception) {
            log.error((Object)"\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\u3002\u3002\u3002\u3002\u3002", (Throwable)exception);
        }
        boolean bl = dbHelper.deleteTmpMsgByType(string, string2);
        if (!bl) {
            log.info((Object)("\u4e34\u65f6\u8868\u4fe1\u606f\u5220\u9664\u8fd4\u56defalse\uff1a" + string), null);
        }
    }
}

