/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.nbiotDriver;

import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.otherModem.bean.BC26NbIoTBean;
import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.common.Const;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.NbIoTDriver;
import cn.sendsms.otherModem.thread.WatchDog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.commons.configuration.PropertiesConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BC26NbIoTDriver
extends NbIoTDriver {
    private static final BC26NbIoTDriver _$2 = new BC26NbIoTDriver();

    public static final BC26NbIoTDriver getInstance() {
        return _$2;
    }

    @Override
    public String getSignal(SerialPort serialPort) {
        String string = "99,99";
        boolean bl = false;
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!serialPort.isOpened()) {
            log.info((Object)("\u6b63\u5728\u5c1d\u8bd5\u6253\u5f00\u7aef\u53e3:" + serialPort.getPortName()));
            if (Utils.openPort(nbIoTBean.getBaudrate(), serialPort)) {
                bl = true;
            } else {
                return string;
            }
        }
        if (!BC26NbIoTDriver.execAtCommand(nbIoTBean, serialPort, "AT+CSQ\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return string;
        }
        String string2 = "[+]{0,1}CSQ: [0-9]+,[0-9]+OK";
        string = ModemDriver.getStrResponse(serialPort, false, string2, "UTF-8");
        Pattern pattern = Pattern.compile("[+]{0,1}CSQ:[0-9]+,[0-9]+");
        Matcher matcher = pattern.matcher(string.replaceAll("\\s+", ""));
        if (matcher.find()) {
            string = matcher.group(0).replace("+CSQ:", "");
        }
        if (bl) {
            Utils.closePort(serialPort);
        }
        return string;
    }

    @Override
    public String getSerialNumber(SerialPort serialPort) {
        String string = "";
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!BC26NbIoTDriver.execAtCommand(nbIoTBean, serialPort, "AT+CGSN\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return string;
        }
        String string2 = "[A-Z,0-9]+";
        string = ModemDriver.getStrResponse(serialPort, false, string2, "UTF-8");
        if ("ERROR".equals(string)) {
            log.error((Object)("\u8bbe\u5907\u5e8f\u5217\u53f7\u53d6\u5f97\u5931\u8d25" + string));
            return "";
        }
        string = Utils.deletePrefix(string, "AT+CGSN");
        string = Utils.deleteSuffix(string, "OK");
        for (int i = 0; i < Const.UNSOLICITED_RESPONSE_REGEX.size(); ++i) {
            string = string.replaceAll(Const.UNSOLICITED_RESPONSE_REGEX.get(i), "");
        }
        if (string.length() > 17 && string.endsWith("OK")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    @Override
    public String getCommunicationID(String string) {
        String string2 = "";
        if (string == null || string.equals("")) {
            return string2;
        }
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string3 = propertiesConfiguration.getString("random_number_seed", "");
        if (string3 != null && !"".equals(string3) && string3.length() >= 10 && string3.matches("[0-9a-zA-Z]+")) {
            string = string3;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            string2 = new BigInteger(1, byArray).toString(16).substring(8, 16).toUpperCase();
        }
        catch (Exception exception) {
            log.error((Object)"\u83b7\u53d6\u901a\u4fe1ID\u5931\u8d25\u3002\u3002\u3002", (Throwable)exception);
            string2 = "";
        }
        return string2;
    }

    @Override
    public boolean networkNormal(SerialPort serialPort) {
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!BC26NbIoTDriver.execAtCommand(nbIoTBean, serialPort, "AT+CEREG?\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        String string = "[+]{0,1}CEREG:[\\s]*[0-9]+,[0-9]+OK";
        String string2 = ModemDriver.getStrResponse(serialPort, false, string, "UTF-8");
        Pattern pattern = Pattern.compile("[+]{0,1}CEREG:[\\s]*0,1");
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            log.info((Object)(serialPort.getPortName() + "\u7f51\u7edc\u6b63\u5e38\u3002\u3002\u3002"));
            return true;
        }
        log.info((Object)(string2 + "\u5f53\u524d\u7f51\u7edc\u72b6\u6001\uff1a" + string2));
        return false;
    }

    @Override
    public boolean isCompleteMessages(byte[] byArray, NbIoTBean nbIoTBean, List<String> list, List<String> list2) {
        String string = Utils.getString(byArray);
        String string2 = "";
        List<String> list3 = this._$1(string, nbIoTBean);
        if (list3 == null || list3.size() == 0) {
            return false;
        }
        String string3 = "(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + nbIoTBean.getCommunicationID() + "\",\"" + "[\\s\\S]+" + "\"$";
        String string4 = "(\\+QMT){0,1}RECV:,[0-9]+[\\s]*";
        for (int i = 0; i < list3.size(); ++i) {
            String string5 = list3.get(i);
            if (string5.matches(string3)) {
                String string6 = string5.replaceFirst("(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + nbIoTBean.getCommunicationID() + "\",", "");
                int n = 0;
                if (Utils.isEmptyStr(string6)) {
                    log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + string5));
                    continue;
                }
                if (string6.startsWith("\"")) {
                    string6 = string6.substring(1);
                }
                if (string6.endsWith("\"")) {
                    string6 = string6.substring(0, string6.length() - 1);
                }
                if (Utils.isEmptyStr(string6)) {
                    log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + string5));
                    continue;
                }
                if (string6.length() <= 38) {
                    log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + string5));
                    continue;
                }
                String string7 = string6.substring(35, 38);
                try {
                    n = Integer.valueOf(string7, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + string5));
                    continue;
                }
                string2 = string6;
                string7 = string6.substring(34, 35);
                if ("U".equals(string7)) {
                    String string8 = string6.substring(0, 38);
                    String string9 = string6.substring(38);
                    try {
                        string2 = string8 + Utils.getString(Utils.hexStr2ByteArr(string9));
                    }
                    catch (Exception exception) {
                        log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + string5));
                        continue;
                    }
                }
                if ("S".equals(string7)) {
                    log.info((Object)"Quectel_BC26\u4e0d\u652f\u6301\u652f\u6301\u53d1\u9001\u4e2d\u6587\u4fe1\u606f");
                    continue;
                }
                int n2 = Utils.getByteArray(string6.substring(38)).length;
                if (n <= n2) {
                    list.add(string2);
                    continue;
                }
                log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + string5));
                continue;
            }
            if (string5.matches(string4)) {
                log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + string5));
                continue;
            }
            list2.add(string5);
            return false;
        }
        return true;
    }

    private List<String> _$1(String string, NbIoTBean nbIoTBean) {
        String[] stringArray;
        Object object;
        String string2 = "";
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String string3 = "(\\+QMT){0,1}OPEN: [0-9]+,[0-9]+";
        String string4 = "(\\+QMT){0,1}STAT: [0-9]+,[0-9]+";
        String string5 = "(\\+QMT){0,1}CONN: [0-9]+,[0-9]+,[0-9]+";
        String string6 = "(\\+QMT){0,1}CONN: [0-9]+,[0-9]+";
        String string7 = "(\\+QMT){0,1}SUB: [0-9]+,[0-9]+,[0-9]+,[0-9]+";
        String string8 = "(\\+QMT){0,1}SUB: [0-9]+,[0-9]+,[0-9]+";
        String string9 = "(\\+QMT){0,1}PUB: [0-9]+,[0-9]+,[0-9]";
        String string10 = "(\\+QMT){0,1}PUB: [0-9]+,[0-9]+,[0-9]";
        String string11 = "(\\+QMT){0,1}CLOSE: [0-9]+,[0-9]";
        String string12 = "AT(\\+QMT){0,1}CLOSE: [0-9]+,[0-9]";
        String string13 = "AT(\\+QMT){0,1}CLOSE=[0-9]+";
        String string14 = "[+]{0,1}CPIN: NOT READY";
        String string15 = "[+]{0,1}CPIN: READY";
        String string16 = "[+]{0,1}IP: [0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+";
        String string17 = "[\\s]*------------- Exception called -------------[\\s]*";
        String string18 = "[\\s]*assert failed: pxQueue[\\s]*";
        String string19 = "[\\s]*file: ../../../../../kernel/rtos/FreeRTOS/Source/queue.c[\\s]*";
        String string20 = "[\\s]*line: 1741[\\s]*";
        String string21 = "[\\s]*genie connected: No[\\s]";
        String string22 = "[\\s]*auto-reboot: Yes[\\s]*";
        String string23 = "(Rb[\\S\\s]+B[\\S\\s]+)+";
        boolean bl = false;
        while (true) {
            object = null;
            try {
                object = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                log.error((Object)"\u4fe1\u606f\u89e3\u6790\u5931\u8d25\u3002\u3002\u3002", (Throwable)iOException);
            }
            if (object == null) break;
            if (object.trim().equals("") || object.replace("\r", "").replace("\n", "").equals("OK")) continue;
            if (object.startsWith("OK")) {
                string2 = string2 + object.substring(2);
                continue;
            }
            if (object.replace("\r", "").replace("\n", "").equals("ERROR") || object.replace("\r", "").replace("\n", "").matches(string5) || object.replace("\r", "").replace("\n", "").matches(string6)) continue;
            if (object.replace("\r", "").replace("\n", "").matches(string4)) {
                bl = true;
                continue;
            }
            if (object.replace("\r", "").replace("\n", "").matches(string17) || object.replace("\r", "").replace("\n", "").matches(string18) || object.replace("\r", "").replace("\n", "").matches(string19) || object.replace("\r", "").replace("\n", "").matches(string20) || object.replace("\r", "").replace("\n", "").matches(string21) || object.replace("\r", "").replace("\n", "").matches(string22) || object.replace("\r", "").replace("\n", "").matches(string23)) {
                bl = true;
                continue;
            }
            if (object.replace("\r", "").replace("\n", "").matches(string7) || object.replace("\r", "").replace("\n", "").matches(string8) || object.replace("\r", "").replace("\n", "").matches(string9) || object.replace("\r", "").replace("\n", "").matches(string10) || object.replace("\r", "").replace("\n", "").matches(string11) || object.replace("\r", "").replace("\n", "").matches(string12) || object.replace("\r", "").replace("\n", "").matches(string13) || object.replace("\r", "").replace("\n", "").matches(string14) || object.replace("\r", "").replace("\n", "").matches(string15) || object.replace("\r", "").replace("\n", "").matches(string16) || object.replace("\r", "").replace("\n", "").matches(string3)) continue;
            stringArray = object;
            object = object.replaceAll(string23, "");
            string2 = string2 + (String)object;
            if (stringArray.equals(object)) continue;
            log.error((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u6536\u5230\u5f02\u5e38\u4fe1\u606f\uff1a" + (String)stringArray));
            bl = true;
        }
        if (bl) {
            this._$1(nbIoTBean.getPortID());
        }
        try {
            bufferedReader.close();
            stringReader.close();
        }
        catch (IOException iOException) {
            log.error((Object)"\u6570\u636e\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)iOException);
        }
        object = string2.split("(\\+QMT){0,1}RECV:");
        stringArray = new ArrayList();
        for (int i = 0; i < ((String[])object).length; ++i) {
            if (object[i] == null || object[i].length() == 0) continue;
            stringArray.add((String)("+QMTRECV:" + object[i]));
        }
        if (string2.endsWith("RECV:")) {
            stringArray.add((String)"+QMTRECV:");
        }
        return stringArray;
    }

    private void _$1(String string) {
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        if (nbIoTBean != null) {
            log.error((Object)"\u8bbe\u5907\u8fde\u63a5\u5f02\u5e38\uff0c\u5373\u5c06\u91cd\u542f\uff01\u3010BC26-prepareRestartDevice\u3011");
            nbIoTBean.setUsingStatus("2");
            log.info((Object)(nbIoTBean.getGatewayID() + "\u5373\u5c06\u91cd\u542f\u3002\u3002\u3002"));
            WatchDog.getInstance().interrupt();
        }
    }

    @Override
    public boolean initDevice(SerialPort serialPort) {
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!BC26NbIoTDriver.execAtCommand(nbIoTBean, serialPort, "AT+QRST=1\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            log.info((Object)"\u8bbe\u5907\u521d\u59cb\u5316\u7b49\u5f85\u88ab\u6253\u65ad(1)");
        }
        String string = ModemDriver.getStrResponse(serialPort, false, "", "UTF-8");
        int n = 0;
        while (BC26NbIoTDriver.serialportConnected(serialPort)) {
            ++n;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                log.info((Object)"\u8bbe\u5907\u521d\u59cb\u5316\u7b49\u5f85\u88ab\u6253\u65ad(2)");
            }
            if ((!(string = string + ModemDriver.getStrResponse(serialPort, false, "", "UTF-8")).startsWith("AT+QRST=?") || string.length() != 31) && string.startsWith("AT+QRST=?") && string.length() == 22 && n <= 30) continue;
        }
        if (!Utils.isEmptyStr(string)) {
            this.commandNotEcho(serialPort);
            return true;
        }
        log.info((Object)("\u8bbe\u5907\u521d\u59cb\u5316\u5f02\u5e38\u3002\u3002\u3002" + string));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(String string, String string2, NbIoTBean nbIoTBean) {
        BC26NbIoTBean bC26NbIoTBean = (BC26NbIoTBean)nbIoTBean;
        if (!"Quectel_BC26".equals(bC26NbIoTBean.getDeviceType())) {
            log.error((Object)(bC26NbIoTBean.getGatewayID() + "\u8bbf\u95ee\u5f02\u5e38\u3002\u3002"));
            return false;
        }
        if ("0".equals(bC26NbIoTBean.getUsingStatus())) {
            log.info((Object)(bC26NbIoTBean.getGatewayID() + "\u5df2\u7ecf\u505c\u6b62\u3002\u3002"));
            return false;
        }
        if ("2".equals(bC26NbIoTBean.getUsingStatus())) {
            log.info((Object)(bC26NbIoTBean.getGatewayID() + "\u6b63\u5728\u91cd\u542f\u3002\u3002"));
            return false;
        }
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string3 = bC26NbIoTBean.getPortID();
        boolean bl = false;
        SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(string3);
        int n = propertiesConfiguration.getInt("settings.mqtt_qos", 1);
        int n2 = bC26NbIoTBean.getMessageID();
        if (n == 0) {
            n2 = 0;
        }
        String string4 = "AT+QMTPUB=" + bC26NbIoTBean.getTcpConnectID() + "," + n2 + "," + n + ",0,\"" + string + "\",\"" + string2 + "\"\r";
        String string5 = "OK[\\s\\S]*(\\+QMT){0,1}PUB: " + bC26NbIoTBean.getTcpConnectID() + "," + n2 + "," + "0";
        Pattern pattern = Pattern.compile(string5);
        String string6 = "(\\+QMT){0,1}STAT: [0-9]+,[0-9]+";
        String string7 = "[\\s]*------------- Exception called -------------[\\s]*[\\s]*assert failed: pxQueue[\\s]*[\\s]file: ../../../../../kernel/rtos/FreeRTOS/Source/queue.c[\\s]*[\\s]line: 1741[\\s]*[\\s]genie connected: No[\\s]*[\\s]auto-reboot: Yes[\\s]*";
        Pattern pattern2 = Pattern.compile(string6);
        Pattern pattern3 = Pattern.compile(string7);
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (!BC26NbIoTDriver.execAtCommand(bC26NbIoTBean, serialPort, string4, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            byte[] byArray = ModemDriver.getBytesResponse(serialPort, "UTF-8");
            int n3 = 0;
            while (BC26NbIoTDriver.serialportConnected(serialPort)) {
                String string8 = Utils.getString(byArray);
                if (string8.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    log.info((Object)("\u8bbe\u5907" + bC26NbIoTBean.getGatewayID() + "\u4fe1\u606f\u53d1\u9001\u5931\u8d25." + "\u8fd4\u56de\u503c\uff1a" + string8));
                    return false;
                }
                Matcher matcher = pattern.matcher(string8.replace("\r", "").replace("\n", ""));
                if (matcher.find()) {
                    bl = true;
                    break;
                }
                Matcher matcher2 = pattern2.matcher(string8.replace("\r", "").replace("\n", ""));
                Matcher matcher3 = pattern3.matcher(string8.replace("\r", "").replace("\n", ""));
                if (matcher2.find() || matcher3.find()) {
                    this._$1(serialPort.getPortName());
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    log.error((Object)"\u7b49\u5f85\u53d1\u9001\u4fe1\u606f\u547d\u4ee4\u7684\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] byArray2 = ModemDriver.getBytesResponse(serialPort, "UTF-8");
                byArray = Utils.mergeByteArray(byArray2, byArray);
                if (++n3 < 300) continue;
                break;
            }
            this.getCompleteMessages(byArray, serialPort, bC26NbIoTBean, "\u53d1\u4fe1\u7ebf\u7a0b");
            if ("2".equals(bC26NbIoTBean.getUsingStatus())) {
                log.info((Object)("\u7531\u4e8e\u8bbe\u5907\u53d1\u751f\u4e86\u91cd\u542f\uff0c" + string2 + "\u8981\u91cd\u65b0\u53d1\u9001\uff01"));
                bl = false;
            }
            return bl;
        }
    }

    @Override
    public void commandNotEcho(SerialPort serialPort) {
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!BC26NbIoTDriver.execAtCommand(nbIoTBean, serialPort, "ATE0\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return;
        }
        String string = "[\\s\\S]*OK";
        String string2 = ModemDriver.getStrResponse(serialPort, false, string, "UTF-8");
        if (string2.contains("OK")) {
            log.info((Object)"\u5173\u95ed\u547d\u4ee4\u56de\u663e\u6210\u529f");
        } else {
            log.error((Object)"\u5173\u95ed\u547d\u4ee4\u56de\u663e\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subSucessed(String string) {
        SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(string);
        BC26NbIoTBean bC26NbIoTBean = (BC26NbIoTBean)nbiotDeviceInfoGetter.findDeviceByPortID(string);
        if (!"Quectel_BC26".equals(bC26NbIoTBean.getDeviceType())) {
            log.error((Object)(bC26NbIoTBean.getGatewayID() + "\u8bbf\u95ee\u5f02\u5e38\u3002\u3002"));
            return false;
        }
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        int n = propertiesConfiguration.getInt("settings.mqtt_qos", 1);
        String string2 = "OK[\\s\\S]*(\\+QMT){0,1}SUB: [0-9]+,[0-9]+,0," + n;
        String string3 = "OK[\\s\\S]*(\\+QMT){0,1}SUB: [0-9]+,[0-9]+,[1-2]+";
        String string4 = "[\\s]*------------- Exception called -------------[\\s]*";
        String string5 = "(\\+QMT){0,1}STAT: [0-9]+,[0-9]+";
        String string6 = "(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + bC26NbIoTBean.getCommunicationID() + "\",\"" + "[\\s\\S]+" + "\"$";
        Pattern pattern = Pattern.compile(string2);
        Pattern pattern2 = Pattern.compile(string3);
        Pattern pattern3 = Pattern.compile(string4);
        Pattern pattern4 = Pattern.compile(string5);
        Pattern pattern5 = Pattern.compile(string6);
        Matcher matcher = null;
        Matcher matcher2 = null;
        Matcher matcher3 = null;
        Matcher matcher4 = null;
        Matcher matcher5 = null;
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            String string7 = "AT+QMTSUB=" + bC26NbIoTBean.getTcpConnectID() + "," + bC26NbIoTBean.getMessageID() + ",\"" + bC26NbIoTBean.getCommunicationID() + "\"," + n + "\r";
            if (!BC26NbIoTDriver.execAtCommand(bC26NbIoTBean, serialPort, string7, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            byte[] byArray = ModemDriver.getBytesResponse(serialPort, "UTF-8");
            int n2 = 0;
            String string8 = "";
            while (BC26NbIoTDriver.serialportConnected(serialPort)) {
                string8 = Utils.getString(byArray);
                if (string8.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    return false;
                }
                matcher = pattern.matcher(string8.replace("\r", "").replace("\n", ""));
                matcher2 = pattern2.matcher(string8.replace("\r", "").replace("\n", ""));
                matcher3 = pattern3.matcher(string8.replace("\r", "").replace("\n", ""));
                matcher4 = pattern4.matcher(string8.replace("\r", "").replace("\n", ""));
                matcher5 = pattern5.matcher(string8.replace("\r", "").replace("\n", ""));
                if (matcher.find() || matcher2.find() || matcher3.find() || matcher4.find() || matcher5.find()) break;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8ba2\u9605\u662f\u5426\u6210\u529f\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] byArray2 = ModemDriver.getBytesResponse(serialPort, "UTF-8");
                byArray = Utils.mergeByteArray(byArray2, byArray);
                if (++n2 < 300) continue;
                break;
            }
            if (string8 == null || string8.equals("")) {
                return false;
            }
            this.getCompleteMessages(byArray, serialPort, bC26NbIoTBean, "\u8ba2\u9605\u4e3b\u9898");
            matcher.reset();
            matcher5.reset();
            matcher2.reset();
            matcher3.reset();
            matcher4.reset();
            if (matcher2.find() || matcher3.find() || matcher4.find()) {
                log.error((Object)"\u8ba2\u9605\u4e3b\u9898\u5931\u8d25");
                log.error((Object)(serialPort.getPortName() + "\u8fd4\u56de\uff1a" + string8));
                return false;
            }
            if (matcher.find() || matcher5.find()) {
                log.info((Object)"\u8ba2\u9605\u4e3b\u9898\u6210\u529f");
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectSucessed(String string) {
        SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(string);
        BC26NbIoTBean bC26NbIoTBean = (BC26NbIoTBean)nbiotDeviceInfoGetter.findDeviceByPortID(string);
        if (!"Quectel_BC26".equals(bC26NbIoTBean.getDeviceType())) {
            log.error((Object)(bC26NbIoTBean.getGatewayID() + "\u8bbf\u95ee\u5f02\u5e38\u3002\u3002"));
            return false;
        }
        if (!this._$3(serialPort, bC26NbIoTBean)) {
            return false;
        }
        if (!this._$2(serialPort, bC26NbIoTBean)) {
            return false;
        }
        if (!this._$1(serialPort, bC26NbIoTBean)) {
            return false;
        }
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string2 = propertiesConfiguration.getString("settings.mqtt_user", "0000");
        String string3 = propertiesConfiguration.getString("settings.mqtt_password", "0000");
        String string4 = "AT+QMTCONN=" + bC26NbIoTBean.getTcpConnectID() + ",\"" + bC26NbIoTBean.getCommunicationID() + "\"," + string2 + "," + string3 + "\r";
        String string5 = "OK[\\s\\S]*(\\+QMT){0,1}CONN: " + bC26NbIoTBean.getTcpConnectID() + ",0,0";
        String string6 = "(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + bC26NbIoTBean.getCommunicationID() + "\",\"" + "[\\s\\S]+" + "\"$";
        Pattern pattern = Pattern.compile(string5);
        Pattern pattern2 = Pattern.compile(string6);
        Matcher matcher = null;
        Matcher matcher2 = null;
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (!BC26NbIoTDriver.execAtCommand(bC26NbIoTBean, serialPort, string4, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            byte[] byArray = ModemDriver.getBytesResponse(serialPort, "UTF-8");
            int n = 0;
            String string7 = "";
            while (BC26NbIoTDriver.serialportConnected(serialPort)) {
                string7 = Utils.getString(byArray);
                if (string7.replace("\r", "").replace("\n", "").matches(string5)) {
                    return true;
                }
                if (string7.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    return false;
                }
                matcher = pattern.matcher(string7.replace("\r", "").replace("\n", ""));
                matcher2 = pattern2.matcher(string7.replace("\r", "").replace("\n", ""));
                if (matcher.find() || matcher2.find()) break;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8fde\u63a5\u662f\u5426\u6210\u529f\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] byArray2 = ModemDriver.getBytesResponse(serialPort, "UTF-8");
                byArray = Utils.mergeByteArray(byArray2, byArray);
                if (++n < 150) continue;
                break;
            }
            if (string7 == null || string7.equals("")) {
                return false;
            }
            this.getCompleteMessages(byArray, serialPort, bC26NbIoTBean, "\u8fde\u63a5MQTT\u670d\u52a1\u5668");
            matcher.reset();
            matcher2.reset();
            boolean bl = matcher.find();
            boolean bl2 = matcher2.find();
            if (bl || bl2) {
                if (bl2) {
                    bC26NbIoTBean.setUsingStatus("1");
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _$3(SerialPort serialPort, BC26NbIoTBean bC26NbIoTBean) {
        String string = "AT+QMTCFG=\"SESSION\"," + bC26NbIoTBean.getTcpConnectID() + ",0\r";
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (!BC26NbIoTDriver.execAtCommand(bC26NbIoTBean, serialPort, string, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            String string2 = ModemDriver.getStrResponse(serialPort, false, "OK", "UTF-8");
            if ("OK".equals(string2)) {
                log.info((Object)(bC26NbIoTBean.getGatewayID() + "\u8fde\u63a5\u53c2\u6570\u3010Session\u3011\u8bbe\u5b9a\u6210\u529f\u3002"));
                return true;
            }
            log.error((Object)(bC26NbIoTBean.getGatewayID() + "\u8fde\u63a5\u53c2\u6570\u3010Session\u3011\u8bbe\u5b9a\u5931\u8d25\uff1a" + string2));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _$2(SerialPort serialPort, BC26NbIoTBean bC26NbIoTBean) {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        int n = propertiesConfiguration.getInt("settings.mqtt_keepalive", 10);
        String string = "AT+QMTCFG=\"KEEPALIVE\"," + bC26NbIoTBean.getTcpConnectID() + "," + n + "\r";
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (!BC26NbIoTDriver.execAtCommand(bC26NbIoTBean, serialPort, string, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            String string2 = ModemDriver.getStrResponse(serialPort, false, "OK", "UTF-8");
            if ("OK".equals(string2)) {
                log.info((Object)(bC26NbIoTBean.getGatewayID() + "\u8fde\u63a5\u53c2\u6570\u3010KeepAlive\u3011\u8bbe\u5b9a\u6210\u529f\u3002"));
                return true;
            }
            log.error((Object)(bC26NbIoTBean.getGatewayID() + "\u8fde\u63a5\u53c2\u6570\u3010KeepAlive\u3011\u8bbe\u5b9a\u5931\u8d25\uff1a" + string2));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _$1(SerialPort serialPort, BC26NbIoTBean bC26NbIoTBean) {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string = propertiesConfiguration.getString("settings.mqtt_server", "119.90.56.92");
        String string2 = propertiesConfiguration.getString("settings.mqtt_port", "1883");
        String string3 = "OK[\\s\\S]*(\\+QMT){0,1}OPEN: " + bC26NbIoTBean.getTcpConnectID() + "," + "0";
        String string4 = "AT+QMTOPEN=" + bC26NbIoTBean.getTcpConnectID() + ",\"" + string + "\"," + string2 + "\r";
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (!BC26NbIoTDriver.execAtCommand(bC26NbIoTBean, serialPort, string4, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            String string5 = ModemDriver.getStrResponse(serialPort, false, string3, "UTF-8");
            if (string5.matches(string3)) {
                log.info((Object)(bC26NbIoTBean.getGatewayID() + "\u6253\u5f00\u8fde\u63a5\u6210\u529f\u3002"));
                return true;
            }
            log.error((Object)(bC26NbIoTBean.getGatewayID() + "\u6253\u5f00\u8fde\u63a5\u5931\u8d25\u5931\u8d25\uff1a" + string5));
            return false;
        }
    }

    @Override
    public void disconnectMQTTServer(SerialPort serialPort) {
        BC26NbIoTBean bC26NbIoTBean = nbiotDeviceInfoGetter.findBC26NbIoTBeanByPortID(serialPort.getPortName());
        String string = bC26NbIoTBean.getTcpConnectID() + "";
        String string2 = "AT+QMTCLOSE=" + string + "\r";
        if (!BC26NbIoTDriver.execAtCommand(bC26NbIoTBean, serialPort, string2, "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return;
        }
        String string3 = "(\\+QMT){0,1}CLOSE: [0-9]+,0";
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = null;
        byte[] byArray = ModemDriver.getBytesResponse(serialPort, "UTF-8");
        int n = 0;
        String string4 = "";
        while (BC26NbIoTDriver.serialportConnected(serialPort)) {
            string4 = Utils.getString(byArray);
            if (string4.replace("\r", "").replace("\n", "").matches(string3)) {
                log.info((Object)(bC26NbIoTBean.getGatewayID() + "\u7f51\u7edc\u5173\u95ed\u6210\u529f(1)"));
                break;
            }
            if (string4.replace("\r", "").replace("\n", "").equals("ERROR")) {
                log.info((Object)(bC26NbIoTBean.getGatewayID() + "\u7f51\u7edc\u5173\u95ed\u5931\u8d25(1)\u3002"));
                break;
            }
            matcher = pattern.matcher(string4.replace("\r", "").replace("\n", ""));
            if (matcher.find()) break;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8fde\u63a5\u662f\u5426\u6210\u529f\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
            }
            byte[] byArray2 = ModemDriver.getBytesResponse(serialPort, "UTF-8");
            byArray = Utils.mergeByteArray(byArray2, byArray);
            if (++n < 150) continue;
            break;
        }
        if (string4 == null || string4.equals("")) {
            log.info((Object)(bC26NbIoTBean.getGatewayID() + "\u7f51\u7edc\u5173\u95ed\u5931\u8d25(2)"));
        }
        this.getCompleteMessages(byArray, serialPort, bC26NbIoTBean, "\u65ad\u5f00MQTT\u670d\u52a1\u5668\u8fde\u63a5");
    }

    @Override
    public boolean connectionOK(String string) {
        log.info((Object)("\u8bbe\u5907" + nbiotDeviceInfoGetter.findDeviceByPortID(string).getGatewayID() + "\u662f" + "Quectel_BC26" + "\u8bbe\u5907\uff0c\u8df3\u8fc7\u68c0\u6d4b\u3002\u3002"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _$1(SerialPort serialPort, String string, NbIoTBean nbIoTBean) {
        String string2;
        if ("Quectel_BC26".equals(nbIoTBean.getDeviceType()) && string.endsWith("\"") && string.matches(string2 = "(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + nbIoTBean.getCommunicationID() + "\",\"" + "[\\s\\S]+" + "\"$")) {
            log.info((Object)("\u4fe1\u606f\u4e0d\u5b8c\u6574\uff08\u8bbe\u5907\u5bfc\u81f4\u7684\u4fe1\u606f\u4e22\u5931\uff09\uff1a" + string));
            return Utils.getByteArray(string);
        }
        int n = 0;
        byte[] byArray = null;
        byte[] byArray2 = string.getBytes();
        while (true) {
            SerialPort serialPort2 = serialPort;
            synchronized (serialPort2) {
                byte[] byArray3;
                block25: {
                    byArray3 = new byte[1];
                    if (!BC26NbIoTDriver.serialportConnected(serialPort)) {
                        return null;
                    }
                    try {
                        if (!serialPort.isOpened()) break block25;
                        while (serialPort.getInputBufferBytesCount() <= 0 && n < 50) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException interruptedException) {
                                log.info((Object)"\u7ebf\u7a0b\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002\u3002");
                            }
                            if (++n < 49) continue;
                            log.error((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u672a\u54cd\u5e94!"));
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            return byArray2;
                        }
                        byArray3 = serialPort.readBytes(1);
                    }
                    catch (SerialPortException serialPortException) {
                        log.error((Object)("\u8bfb\u4e32\u53e3" + serialPort.getPortName() + "\u5931\u8d25\u3002\u3002\u3002"), (Throwable)serialPortException);
                        break;
                    }
                }
                if (byArray3 == null) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        log.info((Object)"\u7ebf\u7a0b\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002\u3002");
                    }
                    if (++n > 50) {
                        break;
                    }
                } else {
                    Matcher matcher;
                    Matcher matcher2;
                    Pattern pattern;
                    Pattern pattern2;
                    String string3;
                    String string4;
                    byArray = Utils.mergeByteArray(byArray3, byArray);
                    byArray2 = Utils.mergeByteArray(byArray3, byArray2);
                    String string5 = Utils.getString(byArray2);
                    if ("Quectel_BC26".equals(nbIoTBean.getDeviceType())) {
                        if (string5.endsWith("+QMT")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            log.info((Object)("\u4fe1\u606f\u7f3a\u5931\u90e8\u5206\u5df2\u7ecf\u8bfb\u5b8c\uff1a" + string5));
                            return Utils.getByteArray(string5.substring(0, string5.length() - 4));
                        }
                        string4 = "((\\+QMT){0,1}STAT: [0-9]+,[0-9]+)$";
                        string3 = "Rb[\\S\\s]+B[\\S\\s]+";
                        pattern2 = Pattern.compile(string4);
                        pattern = Pattern.compile(string3);
                        matcher2 = pattern2.matcher(string5.replace("\r", "").replace("\n", ""));
                        matcher = pattern.matcher(string5.replace("\r", "").replace("\n", ""));
                        if (matcher2.find() || matcher.find()) {
                            nbIoTBean.setUsingStatus("2");
                            WatchDog.getInstance().interrupt();
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            return Utils.getByteArray(string5.replaceAll(string3, "").replaceAll(string4, ""));
                        }
                        if (string5.replace("\r", "").replace("\n", "").endsWith("ERROR")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            return Utils.getByteArray(string5.replace("ERROR", ""));
                        }
                    }
                    if ("M5310-A".equals(nbIoTBean.getDeviceType())) {
                        if (string5.endsWith("+MQTT")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            log.info((Object)("\u4fe1\u606f\u7f3a\u5931\u90e8\u5206\u5df2\u7ecf\u8bfb\u5b8c\uff1a" + string5));
                            return Utils.getByteArray(string5.substring(0, string5.length() - 5));
                        }
                        string4 = "(\\+MQTT){0,1}REC:[0-9]+";
                        string3 = "(\\+MQTT){0,1}PUBREC:[0-9]+,[0-9]+";
                        pattern2 = Pattern.compile(string4);
                        pattern = Pattern.compile(string3);
                        matcher2 = pattern2.matcher(string5.replace("\r", "").replace("\n", ""));
                        matcher = pattern.matcher(string5.replace("\r", "").replace("\n", ""));
                        if (matcher2.find() && !matcher.find()) {
                            nbIoTBean.setUsingStatus("2");
                            WatchDog.getInstance().interrupt();
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            return Utils.getByteArray(string5.replaceAll(string4, ""));
                        }
                        String string6 = "REBOOT_CAUSE_APPLICATION_WATCHDOG";
                        String string7 = "REBOOT_CAUSE_PROTOCOL_RPC_TIMEOUT";
                        if (string5.contains(string6) || string5.contains(string7)) {
                            this.stopDevice(serialPort.getPortName());
                        }
                    }
                }
            }
        }
        if (byArray2 != null && byArray2.length != 0) {
            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCompleteMessages(byte[] byArray, SerialPort serialPort, NbIoTBean nbIoTBean, String string) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            while (!this.isCompleteMessages(byArray, nbIoTBean, arrayList, arrayList2)) {
                byte[] byArray2;
                log.debug((Object)("\u6536\u5230\u4e0d\u5b8c\u6574\u4fe1\u606f\uff1a\u3010" + string + "\u3011" + Utils.getString(byArray)));
                if (n >= 15 || arrayList.size() > 50) {
                    log.info((Object)("\u8bfb\u4e32\u53e3\u6b21\u6570:" + n));
                    log.info((Object)("\u5185\u5b58\u4e2d\u4fe1\u606f\u6761\u6570\uff1a" + arrayList.size()));
                    if (arrayList2.isEmpty()) break;
                    log.info((Object)("\u4fe1\u606f\u63a5\u6536\u5b8c\u6574\u524d" + (String)arrayList2.get(0)));
                    byArray2 = this._$1(serialPort, (String)arrayList2.get(0), nbIoTBean);
                    log.info((Object)("\u4fe1\u606f\u63a5\u6536\u5b8c\u6574\u540e" + Utils.getString(byArray2)));
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    arrayList2 = new ArrayList();
                    if (!this.isCompleteMessages(byArray2, nbIoTBean, arrayList3, arrayList2)) {
                        log.error((Object)"\u4e0b\u5217\u4fe1\u606f\u672a\u63a5\u6536\u5b8c\u3002\u3002\u3002\u3002");
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            log.info(arrayList2.get(i));
                        }
                        break;
                    }
                    arrayList.addAll(arrayList3);
                    break;
                }
                if (!BC26NbIoTDriver.serialportConnected(serialPort)) {
                    log.info((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u6389\u7ebf\u4e86\u3002\u3002\u3002"));
                    log.info((Object)("\u4fe1\u606f\u53ef\u80fd\u6709\u4e22\u5931\uff1a" + Utils.getString(byArray)));
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                byArray2 = ModemDriver.getBytesResponse(serialPort, "UTF-8");
                byArray = Utils.mergeByteArray(byArray2, byArray);
                arrayList = new ArrayList();
                arrayList2 = new ArrayList();
                ++n;
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            nbiotMessageHolder.updateMessageList(nbIoTBean, (String)arrayList.get(i));
        }
    }

    @Override
    public boolean isDeviceAT(SerialPort serialPort) {
        if (!BC26NbIoTDriver.execAtCommand(null, serialPort, "AT\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            log.info((Object)"\u7b49\u5f85AT\u54cd\u5e94\u65f6\u88ab\u6253\u65ad");
        }
        String string = ModemDriver.getStrResponse(serialPort, false, "", "UTF-8");
        string = string.replace("AT", "");
        return "OK".equals(string);
    }
}

