/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.nbiotDriver;

import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.bean.VitualNbIoTBean;
import cn.sendsms.otherModem.common.Const;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.NbIoTDriver;
import cn.sendsms.otherModem.nbiot.JDMqttConnectOptions;
import cn.sendsms.otherModem.thread.WatchDog;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualNbIoTDriver
extends NbIoTDriver {
    private static final VirtualNbIoTDriver _$2 = new VirtualNbIoTDriver();

    public static final VirtualNbIoTDriver getInstance() {
        return _$2;
    }

    @Override
    public String getSignal(SerialPort serialPort) {
        String string = "99,99";
        if (this.connectionOK("")) {
            return "30,00";
        }
        return string;
    }

    @Override
    public String getSerialNumber(SerialPort serialPort) {
        String string = "";
        return string;
    }

    @Override
    public String getCommunicationID(String string) {
        String string2 = UUID.randomUUID().toString();
        String string3 = Const.DATEFORMAT.format(new Date());
        String string4 = string3 + string2;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string4.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            string4 = new BigInteger(1, byArray).toString(16).substring(8, 16).toUpperCase();
        }
        catch (Exception exception) {
            log.error((Object)"\u83b7\u53d6\u901a\u4fe1ID\u5931\u8d25\u3002\u3002\u3002", (Throwable)exception);
            string4 = "";
        }
        return string4;
    }

    @Override
    public boolean networkNormal(SerialPort serialPort) {
        return this.connectionOK("");
    }

    @Override
    public boolean isCompleteMessages(byte[] byArray, NbIoTBean nbIoTBean, List<String> list, List<String> list2) {
        return true;
    }

    @Override
    public boolean initDevice(SerialPort serialPort) {
        return true;
    }

    @Override
    public boolean sendMessage(String string, String string2, NbIoTBean nbIoTBean) {
        VitualNbIoTBean vitualNbIoTBean = (VitualNbIoTBean)nbIoTBean;
        if (!"JD-VITUAL-NBIOT-DEVICE".equals(vitualNbIoTBean.getDeviceType())) {
            log.error((Object)(vitualNbIoTBean.getGatewayID() + "\u8bbf\u95ee\u5f02\u5e38\u3002\u3002"));
            return false;
        }
        if ("0".equals(vitualNbIoTBean.getUsingStatus())) {
            log.info((Object)(vitualNbIoTBean.getGatewayID() + "\u5df2\u7ecf\u505c\u6b62\u3002\u3002"));
            return false;
        }
        if ("2".equals(vitualNbIoTBean.getUsingStatus())) {
            log.info((Object)(vitualNbIoTBean.getGatewayID() + "\u6b63\u5728\u91cd\u542f\u3002\u3002"));
            return false;
        }
        try {
            MqttMessage mqttMessage = vitualNbIoTBean.getMessage();
            mqttMessage.clearPayload();
            mqttMessage.setPayload(Utils.getByteArray(string2));
            vitualNbIoTBean.getClient().publish(string, mqttMessage);
        }
        catch (Exception exception) {
            log.error((Object)("\u4fe1\u606f\u3010" + string2 + "\u3011\u53d1\u9001\u5931\u8d25"), (Throwable)exception);
            return false;
        }
        return true;
    }

    @Override
    public void commandNotEcho(SerialPort serialPort) {
    }

    @Override
    public boolean subSucessed(String string) {
        VitualNbIoTBean vitualNbIoTBean = nbiotDeviceInfoGetter.findVitualNbIoTBeanByPortID(string);
        try {
            vitualNbIoTBean.getClient().subscribe(vitualNbIoTBean.getCommunicationID());
        }
        catch (Exception exception) {
            log.error((Object)("\u865a\u62df\u8bbe\u5907" + vitualNbIoTBean.getGatewayID() + "\u8ba2\u9605\u4e3b\u9898\u5931\u8d25\uff01"), (Throwable)exception);
        }
        return true;
    }

    @Override
    public boolean connectSucessed(String string) {
        VitualNbIoTBean vitualNbIoTBean = nbiotDeviceInfoGetter.findVitualNbIoTBeanByPortID(string);
        vitualNbIoTBean.setClient(nbiotDeviceInfoGetter.generateMqttClient(vitualNbIoTBean.getCommunicationID()));
        try {
            if (vitualNbIoTBean.getClient().isConnected()) {
                return true;
            }
            vitualNbIoTBean.getClient().connect(JDMqttConnectOptions.getOptions());
            log.info((Object)("\u8bbe\u5907" + vitualNbIoTBean.getGatewayID() + "\u5df2\u7ecf\u6210\u529f\u8fde\u63a5\u5230MQTT\u670d\u52a1\u5668\uff01"));
        }
        catch (Exception exception) {
            log.error((Object)("\u865a\u62df\u8bbe\u5907" + vitualNbIoTBean.getGatewayID() + "\u8fde\u63a5MQTT\u670d\u52a1\u5668\u5931\u8d25\uff01"), (Throwable)exception);
            return false;
        }
        return true;
    }

    @Override
    public void disconnectMQTTServer(SerialPort serialPort) {
        VitualNbIoTBean vitualNbIoTBean = nbiotDeviceInfoGetter.findVitualNbIoTBeanByPortID(serialPort.getPortName());
        try {
            vitualNbIoTBean.getClient().disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean connectionOK(String string) {
        return true;
    }

    public String decodeMessage(String string) {
        int n;
        String string2 = "";
        int n2 = 0;
        String string3 = string.substring(35, 38);
        try {
            n2 = Integer.valueOf(string3, 16);
        }
        catch (NumberFormatException numberFormatException) {
            log.info((Object)"\u4fe1\u606f\u672a\u63a5\u6536\u5b8c(1)");
            return "";
        }
        String string4 = string.substring(34, 35);
        string2 = string;
        if ("U".equals(string4)) {
            String string5 = string.substring(0, 38);
            String string6 = string.substring(38);
            try {
                string2 = string5 + Utils.getString(Utils.hexStr2ByteArr(string6));
            }
            catch (Exception exception) {
                log.info((Object)"\u4fe1\u606f\u672a\u63a5\u6536\u5b8c(2)");
                return "";
            }
        }
        if (n2 != (n = Utils.getByteArray(string.substring(38)).length)) {
            log.info((Object)"\u4fe1\u606f\u672a\u63a5\u6536\u5b8c(3)");
            return "";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _$1(SerialPort serialPort, String string, NbIoTBean nbIoTBean) {
        String string2;
        if ("Quectel_BC26".equals(nbIoTBean.getDeviceType()) && string.endsWith("\"") && string.matches(string2 = "(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + nbIoTBean.getCommunicationID() + "\",\"" + "[\\s\\S]+" + "\"$")) {
            log.info((Object)("\u4fe1\u606f\u4e0d\u5b8c\u6574\uff08\u8bbe\u5907\u5bfc\u81f4\u7684\u4fe1\u606f\u4e22\u5931\uff09\uff1a" + string));
            return Utils.getByteArray(string);
        }
        int n = 0;
        byte[] byArray = null;
        byte[] byArray2 = string.getBytes();
        while (true) {
            SerialPort serialPort2 = serialPort;
            synchronized (serialPort2) {
                byte[] byArray3;
                block25: {
                    byArray3 = new byte[1];
                    if (!VirtualNbIoTDriver.serialportConnected(serialPort)) {
                        return null;
                    }
                    try {
                        if (!serialPort.isOpened()) break block25;
                        while (serialPort.getInputBufferBytesCount() <= 0 && n < 50) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException interruptedException) {
                                log.info((Object)"\u7ebf\u7a0b\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002\u3002");
                            }
                            if (++n < 49) continue;
                            log.error((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u672a\u54cd\u5e94!"));
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            return byArray2;
                        }
                        byArray3 = serialPort.readBytes(1);
                    }
                    catch (SerialPortException serialPortException) {
                        log.error((Object)("\u8bfb\u4e32\u53e3" + serialPort.getPortName() + "\u5931\u8d25\u3002\u3002\u3002"), (Throwable)serialPortException);
                        break;
                    }
                }
                if (byArray3 == null) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        log.info((Object)"\u7ebf\u7a0b\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002\u3002");
                    }
                    if (++n > 50) {
                        break;
                    }
                } else {
                    Matcher matcher;
                    Matcher matcher2;
                    Pattern pattern;
                    Pattern pattern2;
                    String string3;
                    String string4;
                    byArray = Utils.mergeByteArray(byArray3, byArray);
                    byArray2 = Utils.mergeByteArray(byArray3, byArray2);
                    String string5 = Utils.getString(byArray2);
                    if ("Quectel_BC26".equals(nbIoTBean.getDeviceType())) {
                        if (string5.endsWith("+QMT")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            log.info((Object)("\u4fe1\u606f\u7f3a\u5931\u90e8\u5206\u5df2\u7ecf\u8bfb\u5b8c\uff1a" + string5));
                            return Utils.getByteArray(string5.substring(0, string5.length() - 4));
                        }
                        string4 = "((\\+QMT){0,1}STAT: [0-9]+,[0-9]+)$";
                        string3 = "Rb[\\S\\s]+B[\\S\\s]+";
                        pattern2 = Pattern.compile(string4);
                        pattern = Pattern.compile(string3);
                        matcher2 = pattern2.matcher(string5.replace("\r", "").replace("\n", ""));
                        matcher = pattern.matcher(string5.replace("\r", "").replace("\n", ""));
                        if (matcher2.find() || matcher.find()) {
                            nbIoTBean.setUsingStatus("2");
                            WatchDog.getInstance().interrupt();
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            return Utils.getByteArray(string5.replaceAll(string3, "").replaceAll(string4, ""));
                        }
                        if (string5.replace("\r", "").replace("\n", "").endsWith("ERROR")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            return Utils.getByteArray(string5.replace("ERROR", ""));
                        }
                    }
                    if ("M5310-A".equals(nbIoTBean.getDeviceType())) {
                        if (string5.endsWith("+MQTT")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            log.info((Object)("\u4fe1\u606f\u7f3a\u5931\u90e8\u5206\u5df2\u7ecf\u8bfb\u5b8c\uff1a" + string5));
                            return Utils.getByteArray(string5.substring(0, string5.length() - 5));
                        }
                        string4 = "(\\+MQTT){0,1}REC:[0-9]+";
                        string3 = "(\\+MQTT){0,1}PUBREC:[0-9]+,[0-9]+";
                        pattern2 = Pattern.compile(string4);
                        pattern = Pattern.compile(string3);
                        matcher2 = pattern2.matcher(string5.replace("\r", "").replace("\n", ""));
                        matcher = pattern.matcher(string5.replace("\r", "").replace("\n", ""));
                        if (matcher2.find() && !matcher.find()) {
                            nbIoTBean.setUsingStatus("2");
                            WatchDog.getInstance().interrupt();
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            return Utils.getByteArray(string5.replaceAll(string4, ""));
                        }
                        String string6 = "REBOOT_CAUSE_APPLICATION_WATCHDOG";
                        String string7 = "REBOOT_CAUSE_PROTOCOL_RPC_TIMEOUT";
                        if (string5.contains(string6) || string5.contains(string7)) {
                            this.stopDevice(serialPort.getPortName());
                        }
                    }
                }
            }
        }
        if (byArray2 != null && byArray2.length != 0) {
            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCompleteMessages(byte[] byArray, SerialPort serialPort, NbIoTBean nbIoTBean, String string) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            while (!this.isCompleteMessages(byArray, nbIoTBean, arrayList, arrayList2)) {
                byte[] byArray2;
                log.debug((Object)("\u6536\u5230\u4e0d\u5b8c\u6574\u4fe1\u606f\uff1a\u3010" + string + "\u3011" + Utils.getString(byArray)));
                if (n >= 15 || arrayList.size() > 50) {
                    log.info((Object)("\u8bfb\u4e32\u53e3\u6b21\u6570:" + n));
                    log.info((Object)("\u5185\u5b58\u4e2d\u4fe1\u606f\u6761\u6570\uff1a" + arrayList.size()));
                    if (arrayList2.isEmpty()) break;
                    log.info((Object)("\u4fe1\u606f\u63a5\u6536\u5b8c\u6574\u524d" + (String)arrayList2.get(0)));
                    byArray2 = this._$1(serialPort, (String)arrayList2.get(0), nbIoTBean);
                    log.info((Object)("\u4fe1\u606f\u63a5\u6536\u5b8c\u6574\u540e" + Utils.getString(byArray2)));
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    arrayList2 = new ArrayList();
                    if (!this.isCompleteMessages(byArray2, nbIoTBean, arrayList3, arrayList2)) {
                        log.error((Object)"\u4e0b\u5217\u4fe1\u606f\u672a\u63a5\u6536\u5b8c\u3002\u3002\u3002\u3002");
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            log.info(arrayList2.get(i));
                        }
                        break;
                    }
                    arrayList.addAll(arrayList3);
                    break;
                }
                if (!VirtualNbIoTDriver.serialportConnected(serialPort)) {
                    log.info((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u6389\u7ebf\u4e86\u3002\u3002\u3002"));
                    log.info((Object)("\u4fe1\u606f\u53ef\u80fd\u6709\u4e22\u5931\uff1a" + Utils.getString(byArray)));
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                byArray2 = ModemDriver.getBytesResponse(serialPort, "UTF-8");
                byArray = Utils.mergeByteArray(byArray2, byArray);
                arrayList = new ArrayList();
                arrayList2 = new ArrayList();
                ++n;
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            nbiotMessageHolder.updateMessageList(nbIoTBean, (String)arrayList.get(i));
        }
    }

    @Override
    public boolean isDeviceAT(SerialPort serialPort) {
        return true;
    }
}

