/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.nbiot;

import cn.sendsms.OutboundMessage;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.Authorize1;
import cn.sendsms.jdsmsserver.web.RegCodeGen;
import cn.sendsms.otherModem.bean.BC26NbIoTBean;
import cn.sendsms.otherModem.bean.ModemBean;
import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.bean.VitualNbIoTBean;
import cn.sendsms.otherModem.common.Const;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.nbiotDriver.NbIoTDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.VirtualNbIoTDriver;
import cn.sendsms.otherModem.modem.Modem;
import cn.sendsms.otherModem.nbiot.DeviceMqttCallback;
import cn.sendsms.otherModem.nbiot.IIllIIllIIIlIllI;
import cn.sendsms.otherModem.nbiot.IIlllIIlIIIlIIIl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jssc.SerialPort;
import jssc.SerialPortList;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbIoTDeviceInfoGetter {
    Map<String, Integer> _$4 = new HashMap<String, Integer>();
    private static int _$3 = -1;
    public static final Logger log = Logger.getRootLogger();
    public static final List<String> NBIOT_DEVICE_TYPE_LIST = new IIllIIllIIIlIllI();
    private static Vector<SerialPort> _$2 = new Vector();
    private static Vector<NbIoTBean> _$1 = new Vector();

    private NbIoTDeviceInfoGetter() {
    }

    public static NbIoTDeviceInfoGetter getInstance() {
        return IIlllIIlIIIlIIIl._$1();
    }

    public synchronized void deleteAll() {
        int n;
        while ((n = this.getindexByDeviceType(_$1)) >= 0) {
            _$1.removeElementAt(n);
        }
        while ((n = this.getindexByComName(_$2)) >= 0) {
            _$2.removeElementAt(n);
        }
    }

    public void addNbIoT(NbIoTBean nbIoTBean) {
        _$1.add(nbIoTBean);
    }

    public List<NbIoTBean> getAll() {
        ArrayList<NbIoTBean> arrayList = new ArrayList<NbIoTBean>();
        for (int i = 0; i < _$1.size(); ++i) {
            arrayList.add(_$1.get(i));
        }
        return arrayList;
    }

    public synchronized void getNbIoTDeviceInfo() throws Exception {
        Object object;
        int n;
        long l = System.currentTimeMillis();
        this.deleteAll();
        String[] stringArray = SerialPortList.getPortNames();
        int n2 = 1;
        block0: for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < Const.BAUDRATES.length; ++i) {
                object = new SerialPort(stringArray[n]);
                log.info((Object)("\u6b63\u5728\u5c1d\u8bd5\u6253\u5f00\u7aef\u53e3:" + stringArray[n]));
                if (!Utils.openPort(Const.BAUDRATES[i], object)) {
                    log.error((Object)("\u7aef\u53e3" + stringArray[n] + "\u6253\u5f00\u5931\u8d25\u3002\u3002\u3002"));
                    continue;
                }
                if (NbIoTDriver.checkAT(object)) {
                    String string = NbIoTDriver.checkDeviceType(object);
                    NbIoTBean nbIoTBean = null;
                    nbIoTBean = "Quectel_BC26".equals(string) ? new BC26NbIoTBean() : new NbIoTBean();
                    if (!this._$1(string)) {
                        Utils.closePort(object);
                        continue;
                    }
                    nbIoTBean.setDeviceType(string);
                    nbIoTBean.setAT(true);
                    nbIoTBean.setBaudrate(Const.BAUDRATES[i]);
                    nbIoTBean.setGatewayID("nbiot" + n2);
                    ++n2;
                    nbIoTBean.setPortID(stringArray[n]);
                    String string2 = Modem.getDriver(nbIoTBean.getDeviceType()).getSignal((SerialPort)object);
                    String string3 = Modem.getDriver(nbIoTBean.getDeviceType()).getSerialNumber((SerialPort)object);
                    String string4 = NbIoTDriver.getNbIoTDriver(nbIoTBean.getDeviceType()).getCommunicationID(string3);
                    nbIoTBean.setSerialNumber(string3);
                    nbIoTBean.setCommunicationID(string4);
                    nbIoTBean.setSignal(string2.replace(" ", ""));
                    nbIoTBean.setUsingStatus("0");
                    this.addNbIoT(nbIoTBean);
                    _$2.add((SerialPort)object);
                    Utils.closePort(object);
                    continue block0;
                }
                Utils.closePort(object);
            }
        }
        for (n = 0; n < _$1.size(); ++n) {
            NbIoTBean nbIoTBean = _$1.get(n);
            object = this.getSerialNumber(nbIoTBean.getPortID());
            nbIoTBean.setSerialNumber((String)object);
            nbIoTBean.updateValidate((String)object);
        }
        long l2 = System.currentTimeMillis();
        log.info((Object)("\u68c0\u6d4b\u8bbe\u5907\u82b1\u8d39\uff1a" + (l2 - l) + "ms"));
    }

    private boolean _$1(String string) {
        return NBIOT_DEVICE_TYPE_LIST.contains(string);
    }

    public List<String> getUsingNbIoTList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < _$1.size(); ++i) {
            NbIoTBean nbIoTBean = _$1.get(i);
            if (!nbIoTBean.getUsingStatus().equals("1")) continue;
            arrayList.add(nbIoTBean.getGatewayID());
        }
        return arrayList;
    }

    public boolean addVitualDevice() {
        String string = this._$1();
        if (Utils.isEmptyStr(string)) {
            log.error((Object)"\u5df2\u7ecf\u5230\u8fbe\u53ef\u6dfb\u52a0\u7684\u865a\u62df\u8bbe\u5907\u7684\u6700\u5927\u6570\u76ee\uff01");
            return false;
        }
        VitualNbIoTBean vitualNbIoTBean = new VitualNbIoTBean();
        vitualNbIoTBean.setDeviceType("JD-VITUAL-NBIOT-DEVICE");
        vitualNbIoTBean.setNetworkNormal(true);
        vitualNbIoTBean.setPortID(string);
        String string2 = "nbiot" + string.split("-")[1] + "(V)";
        vitualNbIoTBean.setGatewayID(string2);
        vitualNbIoTBean.setAT(true);
        vitualNbIoTBean.setSignal(VirtualNbIoTDriver.getInstance().getSignal(null));
        String string3 = VirtualNbIoTDriver.getInstance().getCommunicationID("");
        vitualNbIoTBean.setCommunicationID(string3);
        MqttClient mqttClient = this.generateMqttClient(string3);
        if (mqttClient == null) {
            return false;
        }
        vitualNbIoTBean.setClient(mqttClient);
        vitualNbIoTBean.setSerialNumber(string3);
        vitualNbIoTBean.updateValidate(string3);
        this.addNbIoT(vitualNbIoTBean);
        SerialPort serialPort = new SerialPort(string);
        _$2.add(serialPort);
        return true;
    }

    private String _$1() {
        String string;
        int n;
        String string2 = "";
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        int n2 = propertiesConfiguration.getInt("max_number_of_vitual_device", 100);
        ArrayList<NbIoTBean> arrayList = this.getVitualDevice();
        HashSet<String> hashSet = new HashSet<String>();
        for (n = 0; n < arrayList.size(); ++n) {
            string = arrayList.get(n).getPortID();
            if (Utils.isEmptyStr(string)) continue;
            hashSet.add(string);
        }
        for (n = 1; n <= n2; ++n) {
            string = "Vitual-" + n + "-COM";
            if (hashSet.contains(string)) continue;
            string2 = string;
            break;
        }
        return string2;
    }

    public ArrayList<NbIoTBean> getVitualDevice() {
        ArrayList<NbIoTBean> arrayList = new ArrayList<NbIoTBean>();
        for (int i = 0; i < _$1.size(); ++i) {
            if (!"JD-VITUAL-NBIOT-DEVICE".equals(_$1.get(i).getDeviceType())) continue;
            arrayList.add(_$1.get(i));
        }
        return arrayList;
    }

    public String getSerialNumber(String string) {
        String string2 = "";
        for (int i = 0; i < _$1.size(); ++i) {
            NbIoTBean nbIoTBean = _$1.get(i);
            if (!string.equals(nbIoTBean.getPortID())) continue;
            string2 = nbIoTBean.getSerialNumber();
        }
        return string2;
    }

    public List<NbIoTBean> getUsingNbIoTs() {
        ArrayList<NbIoTBean> arrayList = new ArrayList<NbIoTBean>();
        for (int i = 0; i < _$1.size(); ++i) {
            NbIoTBean nbIoTBean = _$1.get(i);
            if (!nbIoTBean.getUsingStatus().equals("1")) continue;
            arrayList.add(nbIoTBean);
        }
        return arrayList;
    }

    public boolean isNbIoTUsing(String string) {
        for (int i = 0; i < _$1.size(); ++i) {
            NbIoTBean nbIoTBean = _$1.get(i);
            if (!string.equals(nbIoTBean.getPortID()) || !nbIoTBean.getUsingStatus().equals("1")) continue;
            return true;
        }
        return false;
    }

    public void deleteNbIoT(String string) throws ConfigurationException {
        Object object;
        NbIoTBean nbIoTBean = this.findDeviceByPortID(string);
        if (nbIoTBean instanceof VitualNbIoTBean) {
            try {
                String string2 = nbIoTBean.getCommunicationID();
                object = ((VitualNbIoTBean)nbIoTBean).getClient();
                object.unsubscribe(string2);
                object.close(true);
            }
            catch (Exception exception) {
                log.error((Object)("\u865a\u62df\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u5220\u9664\u5f02\u5e38!"));
            }
        }
        block2: for (int i = 0; i < _$1.size(); ++i) {
            object = _$1.get(i);
            if (!((ModemBean)object).getPortID().equals(string)) continue;
            this._$1((NbIoTBean)object);
            _$1.removeElementAt(i);
            for (int j = 0; j < _$2.size(); ++j) {
                SerialPort serialPort = _$2.get(j);
                if (!serialPort.getPortName().equals(string)) continue;
                _$2.removeElementAt(j);
                break block2;
            }
            break;
        }
    }

    private void _$1(NbIoTBean nbIoTBean) throws ConfigurationException {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        boolean bl = false;
        int n = 0;
        for (n = 0; n < 64; ++n) {
            if (propertiesConfiguration.getString("nbiotDevice." + n, "").trim().length() == 0 || propertiesConfiguration.getString("nbiotDevice." + n, "").indexOf(nbIoTBean.getGatewayID()) == -1) continue;
            bl = true;
            propertiesConfiguration.clearProperty("nbiotDevice." + n);
            break;
        }
        if (bl) {
            propertiesConfiguration.clearProperty(nbIoTBean.getGatewayID() + ".port");
            propertiesConfiguration.clearProperty(nbIoTBean.getGatewayID() + ".device_type");
            propertiesConfiguration.clearProperty(nbIoTBean.getGatewayID() + ".baudrate");
            propertiesConfiguration.clearProperty(nbIoTBean.getGatewayID() + ".using_status");
            propertiesConfiguration.clearProperty(nbIoTBean.getGatewayID() + ".serial_number");
            propertiesConfiguration.clearProperty(nbIoTBean.getGatewayID() + ".communication_id");
        }
        propertiesConfiguration.save();
    }

    public void saveConfigInfo(NbIoTBean nbIoTBean) throws ConfigurationException {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        Configuration configuration = JDSMSServer.getInstance().getProperties().subset("nbiotDevice");
        int n = 0;
        boolean bl = false;
        Iterator iterator = configuration.getKeys();
        while (iterator.hasNext()) {
            String string = configuration.getString((String)iterator.next());
            if (!string.equals(nbIoTBean.getGatewayID())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            while (n < 64) {
                if (JDSMSServer.getInstance().getProperties().getString("nbiotDevice." + n, "").length() == 0) {
                    propertiesConfiguration.setProperty("nbiotDevice." + n, (Object)(nbIoTBean.getGatewayID() + ",NbIoT"));
                    break;
                }
                ++n;
            }
        }
        propertiesConfiguration.setProperty(nbIoTBean.getGatewayID() + ".port", (Object)nbIoTBean.getPortID());
        propertiesConfiguration.setProperty(nbIoTBean.getGatewayID() + ".device_type", (Object)nbIoTBean.getDeviceType());
        propertiesConfiguration.setProperty(nbIoTBean.getGatewayID() + ".baudrate", (Object)nbIoTBean.getBaudrate());
        propertiesConfiguration.setProperty(nbIoTBean.getGatewayID() + ".serial_number", (Object)nbIoTBean.getSerialNumber());
        propertiesConfiguration.setProperty(nbIoTBean.getGatewayID() + ".using_status", (Object)nbIoTBean.getUsingStatus());
        propertiesConfiguration.setProperty(nbIoTBean.getGatewayID() + ".communication_id", (Object)nbIoTBean.getCommunicationID());
        propertiesConfiguration.save();
    }

    public boolean checkStartNbIoT(String string) {
        for (int i = 0; i < _$1.size(); ++i) {
            NbIoTBean nbIoTBean = _$1.get(i);
            if (!nbIoTBean.getPortID().equals(string) || !nbIoTBean.getUsingStatus().equals("1")) continue;
            return true;
        }
        return false;
    }

    public boolean checkStopNbIoT(String string) {
        for (int i = 0; i < _$1.size(); ++i) {
            NbIoTBean nbIoTBean = _$1.get(i);
            if (!nbIoTBean.getPortID().equals(string) || !nbIoTBean.getUsingStatus().equals("0")) continue;
            return true;
        }
        return false;
    }

    public int getbaudrate(String string) {
        NbIoTBean nbIoTBean = this.findDeviceByPortID(string);
        if (nbIoTBean != null) {
            return nbIoTBean.getBaudrate();
        }
        log.error((Object)"\u83b7\u53d6\u6ce2\u7279\u7387\u5931\u8d25\uff0c\u91c7\u7528\u9ed8\u8ba4\u6ce2\u7279\u73879600");
        return 9600;
    }

    public NbIoTBean findDeviceByPortID(String string) {
        List<NbIoTBean> list = this.getAll();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getPortID().equals(string)) continue;
            return list.get(i);
        }
        return null;
    }

    public NbIoTBean findDeviceByGatewayID(String string) {
        List<NbIoTBean> list = this.getAll();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getGatewayID().equals(string)) continue;
            return list.get(i);
        }
        return null;
    }

    public VitualNbIoTBean findVitualNbIoTBeanByPortID(String string) {
        NbIoTBean nbIoTBean = this.findDeviceByPortID(string);
        if (nbIoTBean instanceof VitualNbIoTBean) {
            return (VitualNbIoTBean)nbIoTBean;
        }
        return null;
    }

    public NbIoTBean findVitualNbIoTBeanByCommunicationID(String string) {
        List<NbIoTBean> list = this.getAll();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getCommunicationID().equals(string)) continue;
            return list.get(i);
        }
        return null;
    }

    public BC26NbIoTBean findBC26NbIoTBeanByPortID(String string) {
        NbIoTBean nbIoTBean = this.findDeviceByPortID(string);
        if (nbIoTBean instanceof BC26NbIoTBean) {
            return (BC26NbIoTBean)nbIoTBean;
        }
        return null;
    }

    public MqttClient findClientByPortID(String string) {
        VitualNbIoTBean vitualNbIoTBean = this.findVitualNbIoTBeanByPortID(string);
        return vitualNbIoTBean.getClient();
    }

    public String getPortIDByLoop(OutboundMessage outboundMessage) {
        if (this.getUsingNbIoTList().isEmpty()) {
            return "";
        }
        String string = outboundMessage.getGatewayId();
        String string2 = outboundMessage.getRecipient();
        if (string == null || string.equals("")) {
            return "";
        }
        if (string2 == null || string2.equals("")) {
            return "";
        }
        int n = 0;
        if ("~".equals(string)) {
            do {
                ++_$3;
                if (++n <= _$1.size()) continue;
                log.error((Object)"\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u7aef\u53e3");
                return "";
            } while (!(_$3 < _$1.size() ? _$1.get(_$3).getUsingStatus().equals("1") : _$1.get(_$3 = 0).getUsingStatus().equals("1")));
            return _$1.get(_$3).getPortID();
        }
        NbIoTBean nbIoTBean = this.findDeviceByGatewayID(string);
        if (nbIoTBean == null) {
            log.error((Object)("\u8bbe\u5907" + outboundMessage.getGatewayId() + "\u672a\u542f\u7528\u6216\u8005\u4e0d\u5b58\u5728\u3002\u3002\u3002"));
            return "";
        }
        return nbIoTBean.getPortID();
    }

    public void updateAvaliableNum(String string) {
        String string2 = this.findDeviceByPortID(string).getSerialNumber();
        int n = Authorize1.getAvaliableNum(string2);
        --n;
        try {
            Authorize1.updateAvaliableNum(string2, n);
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public boolean hasIdleDevice(OutboundMessage outboundMessage) {
        String string = outboundMessage.getGatewayId();
        if ("~".equals(string)) {
            for (int i = 0; i < _$1.size(); ++i) {
                if (!_$1.get(i).isSendIdle()) continue;
                outboundMessage.setUsingPortID(_$1.get(i).getPortID());
                _$1.get(i).setSendIdle(false);
                return true;
            }
        } else {
            NbIoTBean nbIoTBean = this.findDeviceByGatewayID(string);
            if (nbIoTBean == null) {
                return false;
            }
            if (nbIoTBean.isSendIdle()) {
                outboundMessage.setUsingPortID(nbIoTBean.getPortID());
                nbIoTBean.setSendIdle(false);
                return true;
            }
        }
        return false;
    }

    public synchronized SerialPort getSerialPort(String string) {
        for (int i = 0; i < _$2.size(); ++i) {
            if (!_$2.get(i).getPortName().equals(string)) continue;
            return _$2.get(i);
        }
        SerialPort serialPort = new SerialPort(string);
        Utils.openPort(this.getbaudrate(string), serialPort);
        _$2.add(serialPort);
        Utils.closePort(serialPort);
        return serialPort;
    }

    public boolean isNbIoTRegistered(String string) throws Exception {
        String string2 = Authorize1.getAuthorizeInfo(string, "regcode");
        if (string2 == null || string2.indexOf("null") != -1) {
            string2 = "";
        }
        if (string2.equals("")) {
            return false;
        }
        return RegCodeGen.getRegCode(string).equals(string2);
    }

    public String getOriginator(String string) {
        if (string == null) {
            return "";
        }
        for (int i = 0; i < _$1.size(); ++i) {
            if (!_$1.get(i).getPortID().equals(string)) continue;
            return _$1.get(i).getCommunicationID();
        }
        return "";
    }

    public boolean checkAuthorizeInfo(String string, OutboundMessage outboundMessage) {
        String string2 = this.findDeviceByPortID(string).getGatewayID();
        String string3 = this.findDeviceByPortID(string).getSerialNumber();
        try {
            boolean bl = this.findDeviceByPortID(string).isValidate();
            if (!bl) {
                if (outboundMessage != null) {
                    outboundMessage.setText("<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>" + outboundMessage.getText());
                }
                int n = Authorize1.getAvaliableNum(string3);
                if (this._$4.get(string3) == null || this._$4.get(string3) != n) {
                    this._$4.put(string3, n);
                    log.info((Object)("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u8fd8\u53ef\u6536\u53d1" + n + "\u6761\u77ed\u4fe1" + string2));
                }
                if (n < 1) {
                    log.warn((Object)("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u4fe1\u606f\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u4fe1\u606f" + string2));
                    return false;
                }
            }
        }
        catch (Exception exception) {
            log.info((Object)("\u83b7\u53d6\u8bbe\u5907\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff1a" + string2), (Throwable)exception);
            return false;
        }
        return true;
    }

    public void initForNbIoT() {
        String string;
        Object object;
        Object object2;
        Object object3;
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        _$2.removeAllElements();
        Configuration configuration = propertiesConfiguration.subset("nbiotDevice");
        Iterator iterator = configuration.getKeys();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            object2 = configuration.getString((String)object3);
            object = propertiesConfiguration.getString((String)object2 + ".port", "");
            string = propertiesConfiguration.getString((String)object2 + ".device_type", "");
            int n = propertiesConfiguration.getInt((String)object2 + ".baudrate", 9600);
            String string2 = propertiesConfiguration.getString((String)object2 + ".serial_number", "");
            String string3 = propertiesConfiguration.getString((String)object2 + ".using_status", "0");
            String string4 = propertiesConfiguration.getString((String)object2 + ".communication_id", "");
            NbIoTBean nbIoTBean = null;
            nbIoTBean = "Quectel_BC26".equals(string) ? new BC26NbIoTBean() : ("JD-VITUAL-NBIOT-DEVICE".equals(string) ? new VitualNbIoTBean() : new NbIoTBean());
            nbIoTBean.setGatewayID((String)object2);
            nbIoTBean.setPortID((String)object);
            nbIoTBean.setDeviceType(string);
            nbIoTBean.setBaudrate(n);
            nbIoTBean.setSerialNumber(string2);
            nbIoTBean.setUsingStatus(string3);
            nbIoTBean.setCommunicationID(string4);
            if (nbIoTBean instanceof VitualNbIoTBean) {
                MqttClient mqttClient = this.generateMqttClient(string4);
                if (mqttClient == null) {
                    log.error((Object)("\u7531\u4e8e\u672a\u6210\u529f\u521d\u59cb\u5316MQTT\u5ba2\u6237\u7aef\uff0c" + (String)object2 + "\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002\u3002"));
                    continue;
                }
                ((VitualNbIoTBean)nbIoTBean).setClient(mqttClient);
            }
            this.addNbIoT(nbIoTBean);
        }
        object3 = this.getAll();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (NbIoTBean)object2.next();
            string = ((ModemBean)object).getSerialNumber();
            ((NbIoTBean)object).updateValidate(string);
            SerialPort serialPort = new SerialPort(((ModemBean)object).getPortID());
            if (!Utils.openPort(((ModemBean)object).getBaudrate(), serialPort)) {
                log.error((Object)"\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u7684\u8bbe\u5907\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002\u3002", null);
                continue;
            }
            _$2.add(serialPort);
            boolean bl = NbIoTDriver.checkAT(serialPort);
            if (!bl) {
                ((ModemBean)object).setUsingStatus("0");
            }
            ((ModemBean)object).setAT(bl);
            ((NbIoTBean)object).setSignal(Modem.getDriver(((ModemBean)object).getDeviceType()).getSignal(serialPort));
            if (((ModemBean)object).getUsingStatus().equals("0")) {
                Utils.closePort(serialPort);
                continue;
            }
            if (Modem.getDriver(((ModemBean)object).getDeviceType()).startDevice(serialPort.getPortName())) continue;
            Modem.getDriver(((ModemBean)object).getDeviceType()).stopDevice(serialPort.getPortName());
        }
    }

    public MqttClient generateMqttClient(String string) {
        MqttClient mqttClient = null;
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string2 = propertiesConfiguration.getString("settings.mqtt_server", "119.90.56.92");
        String string3 = propertiesConfiguration.getString("settings.mqtt_port", "1883");
        String string4 = "tcp://" + string2 + ":" + string3;
        MemoryPersistence memoryPersistence = new MemoryPersistence();
        try {
            mqttClient = new MqttClient(string4, string + "JD2021-1124", (MqttClientPersistence)memoryPersistence);
        }
        catch (MqttException mqttException) {
            log.error((Object)"MQTT\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002\u3002", (Throwable)mqttException);
        }
        mqttClient.setCallback((MqttCallback)new DeviceMqttCallback(string));
        return mqttClient;
    }

    public int getindexByDeviceType(Vector<NbIoTBean> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if ("JD-VITUAL-NBIOT-DEVICE".equals(vector.get(i).getDeviceType())) continue;
            return i;
        }
        return -1;
    }

    public int getindexByComName(Vector<SerialPort> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i).getPortName().matches("Vitual-[0-9]+-COM")) continue;
            return i;
        }
        return -1;
    }

    /* synthetic */ NbIoTDeviceInfoGetter(IIllIIllIIIlIllI iIllIIllIIIlIllI) {
        this();
    }
}

