/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.queues;

import cn.sendsms.OutboundMessage;
import cn.sendsms.Service;
import cn.sendsms.helper.Logger;
import cn.sendsms.queues.AbstractQueueManager;
import cn.sendsms.queues.ScheduledOutboundMessage;
import cn.sendsms.queues.lIIIIIIlllIIIIII;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.PriorityBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultQueueManager
extends AbstractQueueManager {
    public static final String MESSAGE_FILE_EXT = ".msg";
    private Map<String, PriorityBlockingQueue<OutboundMessage>> _$6;
    private DelayQueue<ScheduledOutboundMessage> _$5;
    private String _$4;
    private File _$3;
    private File _$2;

    public DefaultQueueManager() {
    }

    public DefaultQueueManager(String string) {
        this._$4 = string;
    }

    public DefaultQueueManager(int n) {
        super(n);
    }

    public DefaultQueueManager(int n, String string) {
        super(n);
        this._$4 = string;
    }

    @Override
    protected void init() {
        super.init();
        this._$6 = new HashMap<String, PriorityBlockingQueue<OutboundMessage>>();
        this._$5 = new DelayQueue();
        if (this._$4 == null) {
            this._$4 = Service.getInstance().getSettings().QUEUE_DIRECTORY;
            if (this._$4 == null) {
                Logger.getInstance().logInfo("Queue directory not defined. Queued messages will not be saved to filesystem.", null, null);
                return;
            }
        }
        File file = new File(this._$4, "queue");
        this._$3 = new File(file, "pending");
        if (!this._$3.exists()) {
            if (!this._$3.mkdirs()) {
                Logger.getInstance().logError("Could not create directory for pending messages queue at " + this._$3.getPath(), null, null);
            }
        } else {
            Logger.getInstance().logDebug("loading pending messages..", null, null);
            this._$2();
        }
        this._$2 = new File(file, "delayed");
        if (!this._$2.exists()) {
            if (!this._$2.mkdirs()) {
                Logger.getInstance().logError("Could not create directory for delayed messages queue at " + this._$2.getPath(), null, null);
            }
        } else {
            Logger.getInstance().logDebug("loading delayed messages..", null, null);
            this._$1();
        }
    }

    @Override
    public boolean queueMessage(OutboundMessage outboundMessage) {
        if (outboundMessage.getDeliveryDelay() > 0L) {
            return this._$1(outboundMessage, true);
        }
        return this._$2(outboundMessage, true);
    }

    @Override
    public boolean removePendingMessage(OutboundMessage outboundMessage) {
        Iterator<PriorityBlockingQueue<OutboundMessage>> iterator = this._$6.values().iterator();
        while (iterator.hasNext()) {
            PriorityBlockingQueue<OutboundMessage> priorityBlockingQueue = iterator.next();
            if (!priorityBlockingQueue.remove(outboundMessage)) continue;
            this._$1(outboundMessage.getGatewayId(), outboundMessage.getUuid());
            iterator = null;
            return true;
        }
        iterator = null;
        return false;
    }

    @Override
    public boolean removePendingMessage(String string) {
        Iterator<PriorityBlockingQueue<OutboundMessage>> iterator = this._$6.values().iterator();
        while (iterator.hasNext()) {
            PriorityBlockingQueue<OutboundMessage> priorityBlockingQueue = iterator.next();
            Iterator<OutboundMessage> iterator2 = priorityBlockingQueue.iterator();
            while (iterator2.hasNext()) {
                OutboundMessage outboundMessage = iterator2.next();
                if (!outboundMessage.getId().equalsIgnoreCase(string) || !priorityBlockingQueue.remove(outboundMessage)) continue;
                this._$1(outboundMessage.getGatewayId(), string);
                iterator2 = null;
                iterator = null;
                return true;
            }
            iterator2 = null;
        }
        iterator = null;
        return false;
    }

    private boolean _$2(OutboundMessage outboundMessage, boolean bl) {
        PriorityBlockingQueue<OutboundMessage> priorityBlockingQueue = this._$6.get(outboundMessage.getGatewayId());
        if (priorityBlockingQueue == null) {
            priorityBlockingQueue = new PriorityBlockingQueue<OutboundMessage>(50, new lIIIIIIlllIIIIII(this));
            this._$6.put(outboundMessage.getGatewayId(), priorityBlockingQueue);
        }
        boolean bl2 = priorityBlockingQueue.add(outboundMessage);
        if (bl && bl2) {
            this._$2(outboundMessage);
        }
        return bl2;
    }

    private boolean _$1(OutboundMessage outboundMessage, boolean bl) {
        boolean bl2 = this._$5.add(new ScheduledOutboundMessage(outboundMessage));
        if (bl && bl2) {
            this._$1(outboundMessage);
        }
        return bl2;
    }

    private boolean _$2(OutboundMessage outboundMessage) {
        if (this._$4 == null) {
            return true;
        }
        File file = new File(this._$3, outboundMessage.getGatewayId());
        if (!file.exists() && !file.mkdir()) {
            Logger.getInstance().logError("Queue directory could be created for gateway " + outboundMessage.getGatewayId() + ". Could not create directory .." + file.getPath(), null, null);
            return false;
        }
        return this._$1(outboundMessage, new File(file, outboundMessage.getUuid() + MESSAGE_FILE_EXT));
    }

    private boolean _$1(String string, String string2) {
        if (this._$4 == null) {
            return true;
        }
        return new File(new File(this._$3, string), string2 + MESSAGE_FILE_EXT).delete();
    }

    private boolean _$2(String string) {
        if (this._$4 == null) {
            return true;
        }
        if (string == null) {
            return this._$1(this._$3, false);
        }
        return this._$1(new File(this._$3, string), true);
    }

    private boolean _$1(OutboundMessage outboundMessage) {
        if (this._$4 == null) {
            return true;
        }
        return this._$1(outboundMessage, new File(this._$2, outboundMessage.getUuid() + MESSAGE_FILE_EXT));
    }

    private boolean _$1(String string) {
        if (this._$4 == null) {
            return true;
        }
        return new File(this._$2, string + MESSAGE_FILE_EXT).delete();
    }

    @Override
    public OutboundMessage pollDelayedMessage() {
        try {
            OutboundMessage outboundMessage = ((ScheduledOutboundMessage)this._$5.take()).getMessage();
            this._$1(outboundMessage.getUuid());
            return outboundMessage;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @Override
    public OutboundMessage pollPendingMessage(String string) {
        PriorityBlockingQueue<OutboundMessage> priorityBlockingQueue = this._$6.get(string);
        if (priorityBlockingQueue == null) {
            return null;
        }
        OutboundMessage outboundMessage = priorityBlockingQueue.poll();
        if (outboundMessage != null) {
            this._$1(string, outboundMessage.getUuid());
        }
        return outboundMessage;
    }

    private boolean _$1(OutboundMessage outboundMessage, File file) {
        if (this._$4 == null) {
            return true;
        }
        if (file.exists()) {
            Logger.getInstance().logError("Cannot save Message " + outboundMessage.getUuid() + " File already exist.", null, null);
            return false;
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(outboundMessage);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.getInstance().logError("Cannot save Message " + outboundMessage.getUuid(), iOException, null);
            return false;
        }
        return true;
    }

    private OutboundMessage _$1(File file) {
        if (!file.exists()) {
            Logger.getInstance().logError("File of queued message doesn't exist " + file.getPath(), null, null);
            return null;
        }
        ObjectInputStream objectInputStream = null;
        OutboundMessage outboundMessage = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            outboundMessage = (OutboundMessage)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            Logger.getInstance().logError("Could not read queued message from file " + file.getPath(), iOException, null);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getInstance().logError("Could not read queued message from file " + file.getPath(), classNotFoundException, null);
            return null;
        }
        return outboundMessage;
    }

    private void _$2() {
        File[] fileArray = this._$3.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (!file.isDirectory()) continue;
            File[] fileArray2 = file.listFiles();
            for (int j = 0; j < fileArray2.length; ++j) {
                File file2 = fileArray2[j];
                if (!file2.getName().endsWith(MESSAGE_FILE_EXT)) continue;
                this._$2(this._$1(file2), false);
            }
        }
    }

    private void _$1() {
        File[] fileArray = this._$2.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (!file.getName().endsWith(MESSAGE_FILE_EXT)) continue;
            OutboundMessage outboundMessage = this._$1(file);
            if (outboundMessage.getDeliveryDelay() > 0L) {
                this._$1(outboundMessage, false);
                continue;
            }
            this._$2(outboundMessage, true);
            this._$1(outboundMessage.getUuid());
        }
    }

    @Override
    public int delayedQueueSize(String string) {
        return this._$5.size();
    }

    @Override
    public Collection<OutboundMessage> getDelayedMessages() {
        ArrayList<OutboundMessage> arrayList = new ArrayList<OutboundMessage>();
        Iterator<ScheduledOutboundMessage> iterator = this._$5.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getMessage());
        }
        iterator = null;
        return arrayList;
    }

    @Override
    public Collection<OutboundMessage> getPendingMessages(String string) {
        PriorityBlockingQueue<OutboundMessage> priorityBlockingQueue = this._$6.get(string);
        if (priorityBlockingQueue == null) {
            return new ArrayList<OutboundMessage>();
        }
        return new ArrayList<OutboundMessage>(priorityBlockingQueue);
    }

    @Override
    public int pendingQueueSize(String string) {
        PriorityBlockingQueue<OutboundMessage> priorityBlockingQueue = this._$6.get(string);
        if (priorityBlockingQueue == null) {
            return 0;
        }
        return priorityBlockingQueue.size();
    }

    @Override
    public boolean removeDelayedMessage(OutboundMessage outboundMessage) {
        Iterator<ScheduledOutboundMessage> iterator = this._$5.iterator();
        while (iterator.hasNext()) {
            ScheduledOutboundMessage scheduledOutboundMessage = iterator.next();
            if (!outboundMessage.equals(scheduledOutboundMessage.getMessage()) || !this._$5.remove(scheduledOutboundMessage)) continue;
            this._$1(outboundMessage.getUuid());
            iterator = null;
            return true;
        }
        iterator = null;
        return false;
    }

    @Override
    public boolean removeDelayedMessage(String string) {
        Iterator<ScheduledOutboundMessage> iterator = this._$5.iterator();
        while (iterator.hasNext()) {
            ScheduledOutboundMessage scheduledOutboundMessage = iterator.next();
            if (!string.equals(scheduledOutboundMessage.getMessage().getUuid()) || !this._$5.remove(scheduledOutboundMessage)) continue;
            this._$1(string);
            iterator = null;
            return true;
        }
        iterator = null;
        return false;
    }

    @Override
    public boolean removeAllDelayedMessages() {
        this._$5.clear();
        if (this._$4 == null) {
            return true;
        }
        return this._$1(this._$2, false);
    }

    @Override
    public boolean removeAllPendingMessages(String string) {
        PriorityBlockingQueue<OutboundMessage> priorityBlockingQueue = this._$6.get(string);
        if (priorityBlockingQueue != null) {
            priorityBlockingQueue.clear();
            this._$6.remove(priorityBlockingQueue);
            this._$2(string);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAllPendingMessages() {
        this._$6.clear();
        this._$2((String)null);
        return false;
    }

    private boolean _$1(File file, boolean bl) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this._$1(file2, true);
                continue;
            }
            if (file2.delete()) continue;
            return false;
        }
        if (bl) {
            return file.delete();
        }
        return true;
    }
}

